//===============================================================
// package : com.tetrasix.majix.uis
// class : com.tetrasix.majix.uis.LabelledTextField
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 * This class provides an window to interactively edit
 * a style map
 *
 * @version 1.1
 */


package com.tetrasix.majix.uis;

import java.awt.*;
import java.awt.event.*;


public class LabelledTextField {

	private Panel          _panel;
	private Label          _label;
	private TextField      _text;
	private ActionListener _listener;

	LabelledTextField(String labeltext, String inittext, int textwidth)
	{
		_panel = new Panel();
		_panel.setLayout(new FlowLayout(FlowLayout.LEFT, 10, 10));

		_label = new Label(labeltext);
		_panel.add(_label);

		_text = new TextField(textwidth);
		_text.setText(inittext);
		_panel.add(_text);
	}

	Panel getAwtPanel()
	{
		return _panel;
	}

	String getText()
	{
		return _text.getText();
	}
}