//===============================================================
// package : com.tetrasix.majix.uis
// class : com.tetrasix.majix.uis.ConverterThread
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.uis;

import java.awt.Frame;

import com.tetrasix.majix.xml.ConversionTemplate;
import com.tetrasix.majix.xml.Converter;
import com.tetrasix.util.MessageSink;

public class ConverterThread extends Thread {

	Frame              _frame;
	ConversionTemplate _template;
	String             _inputfile;
	String             _outputfile;
	MessageSink        _msgsink;
	boolean            _dump;
	boolean            _debug;

	public ConverterThread(Frame frame, MessageSink msgsink, ConversionTemplate template, 
							String inputfile, String outputfile, boolean dump, boolean debug)
	{
		_frame       = frame;
		_template    = template;
		_inputfile   = inputfile;
		_outputfile  = outputfile;
		_dump        = dump;
		_debug       = debug;
		_msgsink     = msgsink;
	}
	
	public void run()
	{
		if (Converter.Convert(_template, _inputfile, _outputfile, _dump, _debug, _msgsink)) {
			(new CheckerTextDisplay(_outputfile)).show();
			_msgsink.MessageUsingResource("status_conversion_ok");
		}
		else {
			_msgsink.MessageUsingResource("status_conversion_ko");
		}
	}
}