//===============================================================
// package : com.tetrasix.majix.tools
// class : com.tetrasix.majix.tools.Splitter
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */

package com.tetrasix.majix.tools;

import java.io.*;
import java.util.Hashtable;

import com.jclark.xml.parse.*;
import com.jclark.xml.parse.io.*;
import com.jclark.xml.output.*;

import com.tetrasix.util.*;

public class Splitter extends ApplicationImpl {

	private String _root;
	private String _dirroot;
	private String _dtdtext;
	private DTD _dtd;
	private int _partcount = 0;
	private XMLWriter _rootw;
	private XMLWriter _currentw;
	private XMLWriter _tocw;

	private Hashtable _ids = new Hashtable();
	static private String _filesep = System.getProperty("file.separator");

	private boolean wait_h1_title = false;
	private boolean in_info_block = false;
	private String RE;
	private String info_block = "";

	public static void main(String arg[])
	{
		if (System.getProperty("java.version").startsWith("1.0")) {
			System.out.println("This application requires Java 1.1 or higher\n");
			System.exit(1);
		}

		Configuration.init("majix", true);
		Configuration.setDefaultLocale(arg);

		String outputroot = null;
		String dirroot = null;

		for (int ii = 0; ii < arg.length; ii++) {
			if (arg[ii].equals("-o")) {
				ii++;
				outputroot = arg[ii];
			}
			else if (arg[ii].equals("-d")) {
				ii++;
				dirroot = arg[ii];
			}
			else {
				if (outputroot == null) {
					outputroot = "s" + arg[ii];
				}
				System.out.println("Splitting " + arg[ii] + " into " + outputroot + "...");
				if (split(arg[ii], outputroot, dirroot) >= 0) {
					System.out.println("Splitting successfully performed");
				}
				else {
					System.out.println("Splitting failed");
				}
			}
		}
	}		

	Splitter(String root, String dirroot)
	{
		_root = root;
		_dirroot = dirroot;
		RE = System.getProperty("line.separator");
	}

	static public int split(String xmlfilename, String outfileroot, String outdirroot)
	{
		try {
			Parser parser = new ParserImpl();
			OpenEntity entity = EntityManagerImpl.openFile(xmlfilename);

			Splitter splitter = new Splitter(outfileroot, outdirroot);

			parser.setApplication(new Counter(splitter._ids, outfileroot, outdirroot));
			parser.parseDocument(entity);

			entity = EntityManagerImpl.openFile(xmlfilename);
			parser.setApplication(splitter);
			parser.parseDocument(entity);

			return splitter._partcount;
		}
		catch (NotWellFormedException e) {
		  System.err.println(e.getMessage());
		  return -1;
		}
		catch (IOException e) {
		  System.err.println(e.getMessage());
		  return -1;
		}
	}

	public void startDocument() throws IOException
	{ 
		String filename = _root + ".xml";
		if (_dirroot != null) {
			filename = _dirroot + _filesep + filename;
		}
		_rootw = new ISO8859XMLWriter(new FileOutputStream(filename));
		writeProlog(_rootw);
		_currentw = _rootw;

		String tocname = _root + "_toc.xml";
		if (_dirroot != null) {
			tocname = _dirroot + _filesep + tocname;
		}
			
		_tocw = new ISO8859XMLWriter(
				new FileOutputStream(tocname));
    _tocw.markup("<!DOCTYPE toc [" + RE);
    _tocw.markup("<!ELEMENT toc (tocentry)*>" + RE);
    _tocw.markup("<!ELEMENT tocentry (#PCDATA)>" + RE);
    _tocw.markup("<!ATTLIST tocentry" + RE);
    _tocw.markup("          url CDATA #REQUIRED>" + RE);
    _tocw.markup("]>" + RE);
		_tocw.markup("<toc>" + RE);
	}

	public void endDocument() throws IOException
	{
		_currentw.write('\n');
		_currentw.flush();
  		_currentw.close();

		_tocw.endElement("toc");
		_tocw.write("\n");
		_tocw.flush();
  		_tocw.close();
	}

	private String insert_count(String data, int partcount)
	{
		int pos = data.indexOf("$$");
		if (pos >= 0) {
			String ret = data.substring(0, pos);
			ret += " (Part " + String.valueOf(partcount) + ")";
			ret += data.substring(pos + 2);
			return ret;
		}
		else {
			return data;
		}
	}

	public void startElement(StartElementEvent event) throws IOException
	{
		if (event.getName().equals("h1")) {
			_partcount++;
			String spartcount = String.valueOf(_partcount);
			while (spartcount.length() < 3) {
				spartcount = "0" + spartcount;
			}
			String partname_xml = _root + "_" + spartcount + ".xml";
			String partname_html = _root + "_" + spartcount + ".html";
			//_currentw.markup("<p><link url=\"" + partname_html + "\">" + partname_xml + "</link></p>");

			if (_dirroot != null) {
				partname_xml = _dirroot + _filesep + partname_xml;
			}
			System.out.println("Generating " + partname_xml);
			_currentw = new ISO8859XMLWriter(
						new FileOutputStream(partname_xml));
			writeProlog(_currentw);
			_currentw.markup("<mydoc>" + RE);
			_currentw.markup(insert_count(info_block, _partcount));
			_currentw.markup(RE);

			wait_h1_title = true;
			_tocw.startElement("tocentry");
			_tocw.attribute("url", partname_html);
		}

		if (event.getName().equals("info")) {
			in_info_block = true;
		}


		if (in_info_block) {
			info_block += "<" + event.getName() + ">";
		}

		_currentw.startElement(event.getName());
		int nAtts = event.getAttributeCount();
		for (int ii = 0; ii < nAtts; ii++) {

			String attrname = event.getAttributeName(ii);
			String value = event.getAttributeValue(ii);

			if (attrname.equals("url")) {
				if (value.startsWith("#")) {
					Object partname = _ids.get(value.substring(1));
					if (partname != null) {
						value = (String)partname + value;
					}
				}
			}

			_currentw.attribute(attrname, value);
		}
	}

	public void characterData(CharacterDataEvent event) throws IOException 
	{
		if (wait_h1_title) {
			event.writeChars(_tocw);
		}

		if (in_info_block) {
			char data[] = new char[event.getLength()];
			event.copyChars(data, 0);
			info_block += String.valueOf(data);
		}

		event.writeChars(_currentw);
	}

	public void endElement(EndElementEvent event) throws IOException 
	{
		if (in_info_block) {
			if (event.getName().equals("title")) {
				info_block += "$$";
			}
			info_block += "</" + event.getName() + ">";
		}

		_currentw.endElement(event.getName());

		if (event.getName().equals("h1")) {
			_currentw.endElement("mydoc");
			_currentw.write("\n");
			_currentw.flush();
			_currentw.close();
			_currentw = _rootw;
		}

		if (event.getName().equals("ht")) {
			if (wait_h1_title) {
				wait_h1_title = false;
				_tocw.endElement("tocentry");
				_tocw.write("\n");
			}
		}

		if (event.getName().equals("info")) {
			in_info_block = false;
		}
	}

	public void processingInstruction(ProcessingInstructionEvent event) throws IOException
	{
		_currentw.processingInstruction(event.getName(), event.getInstruction());
	}

	public void endProlog(EndPrologEvent event) throws IOException
	{
		_dtd = event.getDTD();
	}

	void writeProlog(XMLWriter w) throws IOException
	{
		_dtdtext = 
			"<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + RE +
			"<!DOCTYPE mydoc PUBLIC \"-//TetraSix//DTD mydoc v1//EN\" \"mydoc.dtd\" [" + RE + 
			"]>" + RE +
			"<?xml:stylesheet type='text/xsl' href='mydoc.xsl'?>" + RE;

		w.markup(_dtdtext);
	}

}



class Counter extends ApplicationImpl {

	private Hashtable _ids;
	private String    _partname_xml;
	private int       _partcount = 0;
	private String    _root;
	private String _dirroot;

	Counter(Hashtable ids, String root, String dirroot)
	{
		_ids = ids;
		_root = root;
		_dirroot = dirroot;
	}

	public void startDocument() throws IOException
	{ 
	}

	public void endDocument() throws IOException
	{
	}

	public void startElement(StartElementEvent event) throws IOException
	{
		if (event.getName().equals("h1")) {
			_partcount++;
			String spartcount = String.valueOf(_partcount);
			while (spartcount.length() < 3) {
				spartcount = "0" + spartcount;
			}
			_partname_xml = _root + "_" + spartcount + ".xml";
		}

		if (_partname_xml == null) {
			_partname_xml = "default.xml";
		}

		int nAtts = event.getAttributeCount();
		for (int ii = 0; ii < nAtts; ii++) {

		  if (event.getAttributeName(ii).equals("id")) {
			  _ids.put(event.getAttributeValue(ii), _partname_xml);
		  }
		}
	}

	public void characterData(CharacterDataEvent event) throws IOException 
	{
	}

	public void endElement(EndElementEvent event) throws IOException 
	{
	}

	public void processingInstruction(ProcessingInstructionEvent event) throws IOException
	{
	}

	public void endProlog(EndPrologEvent event) throws IOException
	{
	}
}
