//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfText
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import java.io.*;
import com.tetrasix.majix.xml.*;

public class RtfText extends RtfObject {

	private String            _data;
	private RtfTextProperties _properties;

	RtfText(String data)
	{
		_data = data;
		// prevent npe if this constructor is ever called
		_properties = new RtfTextProperties();
	}

	public RtfText(String data, RtfTextProperties properties)
	{
		_data = data;
		_properties = properties;
	}

	public String getData()
	{
		return _data;
	}

	public RtfTextProperties getProperties()
	{
		return _properties;
	}

	void Dump(PrintWriter out)
	{
		if (_properties.changedFontSize()) {
			out.print("<font size=\""+_properties.getFontSize()+"\">");
		}
		if (_properties.isBold()) {
			out.print("<b>");
		}
		if (_properties.isItalic()) {
			out.print("<i>");
		}
		if (_properties.isHidden()) {
			out.print("<h>");
		}
		if (_properties.isUnderlined()) {
			out.print("<ul>");
		}
		if (_properties.isSuper()) {
			out.print("<super>");
		}
		if (_properties.isSub()) {
			out.print("<sub>");
		}
		if (_properties.isDeleted()) {
			out.print("<deleted>");
		}

		out.print(_data);

		if (_properties.isDeleted()) {
			out.print("</deleted>");
		}
		if (_properties.isSub()) {
			out.print("</sub>");
		}
		if (_properties.isSuper()) {
			out.print("</super>");
		}
		if (_properties.isUnderlined()) {
			out.print("</ul>");
		}
		if (_properties.isHidden()) {
			out.print("</h>");
		}
		if (_properties.isItalic()) {
			out.print("</i>");
		}
		if (_properties.isBold()) {
			out.print("</b>");
		}
		if (_properties.changedFontSize()) {
			out.print("</font>");
		}
	}

	public void generate(XmlGenerator gen, XmlWriter out, XmlGeneratorContext context)
	{
		gen.rtfgenerate(this, out, context);
	}
}

