//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfTable
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================
/**
 * @version 1.1
 */
package com.tetrasix.majix.rtf;

import java.io.*;
import com.tetrasix.majix.xml.*;

public class RtfTable extends RtfCompoundObject {

	private RtfTableProperties _properties;
	
	RtfTable() {
		_properties = null;
	}
	
	void setProperties(RtfTableProperties properties) {
		if (properties != null) {
			_properties = (RtfTableProperties) properties.clone();
		}
	}
	
	public RtfTableProperties getProperties() {
		return _properties;
	}
	
	void Dump(PrintWriter out) {
		out.print("<table");
		if (_properties != null) {
			_properties.Dump(out);
		}
		out.print(">");
		super.Dump(out);
		out.println("</table>");
	}
	
	public void generate(XmlGenerator gen, XmlWriter out, XmlGeneratorContext context) {
		gen.rtfgenerate(this, out, context);
	}
}
