//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfPicture
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import java.io.*;
import com.tetrasix.majix.xml.*;

public class RtfPicture extends RtfObject {

	String _data;
	int _counter;

	String _pictdata;
	int _picw;
	int _pich;
	int _picwg;
	int _pichg;

	RtfPicture(int counter, String pictdata, 
				int picw, int pich, int picwg, int pichg)
	{
		_data = null;
		_counter = counter;

		_pictdata = pictdata;
		_picw = picw;
		_pich = pich;
		_picwg = picwg;
		_pichg = pichg;
	}

	RtfPicture(String data)
	{
		_data = data;
		_counter = -1;

		_pictdata = null;
		_picw = 0;
		_pich = 0;
		_picwg = 0;
		_pichg = 0;
	}

	public String getData()
	{
		return _data;
	}

	public int getCounter()
	{
		return _counter;
	}

	void Dump(PrintWriter out)
	{
		out.print("<pict count=" + String.valueOf(_counter) + ">");
	}

	public void generate(XmlGenerator gen, XmlWriter out, XmlGeneratorContext context)
	{
		gen.rtfgenerate(this, out, context);
	}

	public String  getPictdata()
	{
		return _pictdata;
	}

	public int getPicw()
	{
		return _picw;
	}
	
	public int getPich()
	{
		return _pich;
	}

	public int getPicwg()
	{
		return _picwg;
	}

	public int getPichg()
	{
		return _pichg;
	}
}

