//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfParagraph
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import java.io.*;
import com.tetrasix.util.*;
import com.tetrasix.majix.xml.*;

public class RtfParagraph extends RtfBlock {

	private RtfParagraphProperties _properties;
	private StringList _idents;

	RtfParagraph()
	{
		_properties = new RtfParagraphProperties();
		_idents = null;
	}

	void setProperties(RtfParagraphProperties properties)
	{
		if (properties != null) {
			_properties = (RtfParagraphProperties)properties.clone();
		}
	}

	public RtfParagraphProperties getProperties()
	{
		return _properties;
	}

	public RtfTextProperties getTextProperties()
	{
		int code = _properties.getStyle();
		if (code >= 0 && XmlGenerator.USE_CHAR_STYLES) {

			RtfStyleSheet styleSheet = RtfStyleSheet.getCurrentStyleSheet();
			return styleSheet.getTextProperties(code);
		}
		else {
			return new RtfTextProperties();
		}
	}

	void Dump(PrintWriter out)
	{
		out.print("<p");
		if (_properties != null) {
			_properties.Dump(out);
			dumpIdent(out);
		}
		out.print(">");
		super.Dump(out);
		out.println("</p>");
	}

	private void dumpIdent(PrintWriter out)
	{
		if (_idents != null) {
			out.print(" ids='");
			StringList idents = _idents;
			String first = "";
			while (idents != null) {
				out.print(first + idents.getData());
				first = " ";
				idents = idents.getNext();
			}
			out.print("'");
		}
	}

	public void generate(XmlGenerator gen, XmlWriter out, XmlGeneratorContext context)
	{
		gen.rtfgenerate(this, out, context);
	}

	public void addIdentifier(String ident)
	{
		_idents = new StringList(ident, _idents);
	}

	public void resetIdentifiers()
	{
		_idents = null;
	}

	public StringList getIdentifiers()
	{
		return _idents;
	}
}
 