//===============================================================
// package : com.tetrasix.majix.rtf
// class : com.tetrasix.majix.RtfCellProperties
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.rtf;

import java.io.*;

public class RtfCellProperties implements Cloneable  {

	public static final int VERT_ALIGN_TOP = 0;
	public static final int VERT_ALIGN_CENTER = 1;
	public static final int VERT_ALIGN_BOTTOM = 2;

    // cell borders
    public static final int CELLBORDER_NONE = 0;
    public static final int CELLBORDER_TOP = 1;
    public static final int CELLBORDER_BOTTOM = 2;
    public static final int CELLBORDER_LEFT = 4;
    public static final int CELLBORDER_RIGHT = 8;

    public static final int CELLWIDTH_TYPE_CELLX = 0;
    public static final int CELLWIDTH_TYPE_AUTO = 1;
    public static final int CELLWIDTH_TYPE_PERCENTAGE = 2;
    public static final int CELLWIDTH_TYPE_TWIPS = 3;

    private int _cellWidth = 0;
    
    // -1 means dont override row-borderdefinition for this side
    private int _borderWidthTop = -1;
    private int _borderWidthBottom = -1;
    private int _borderWidthLeft = -1;
    private int _borderWidthRight = -1;

    // -1 means dont override row-margindefinition for this side
    private int _borderMarginTop = -1;
    private int _borderMarginBottom = -1;
    private int _borderMarginLeft = -1;
    private int _borderMarginRight = -1;

    private int _verticalAlignment;
    
    private int _cellWidthDefType = 0;
    
    // vertical merge
    private boolean _isFirstVerticalMergedCell = false;
    private boolean _isVerticalMergedCell = false;
    private int _rowspan;
    
    // horizontal merge
    private int _colspan;
    
    private int _tableindex;
    private int _columnindex;
    private int _rowindex;
    
	RtfCellProperties()
	{
	    _cellWidth = 0;
	    _cellWidthDefType = 0;
	    // -1 means dont override row-borderdefinition for this side
	    _borderWidthTop = -1;
	    _borderWidthBottom = -1;
	    _borderWidthLeft = -1;
	    _borderWidthRight = -1;
	    // -1 means dont override row-margindefinition for this side
	    _borderMarginTop = -1;
	    _borderMarginBottom = -1;
	    _borderMarginLeft = -1;
	    _borderMarginRight = -1;
		_verticalAlignment = VERT_ALIGN_TOP; // TOP is default
	    // no rowspan over more than one row initially
		_isFirstVerticalMergedCell = false;
	    _isVerticalMergedCell = false;
	    _rowspan = 1;
	    _colspan = 1;
	}

	protected Object clone()
	{
		RtfCellProperties properties = new RtfCellProperties();

		properties.setWidth(getWidth());
		properties.setCellWidthDefType(getCellWidthDefType());
		
		properties.setBorderWidth(RtfCellProperties.CELLBORDER_BOTTOM,
		        getBorderWidth(RtfCellProperties.CELLBORDER_BOTTOM));
		properties.setBorderWidth(RtfCellProperties.CELLBORDER_TOP,
		        getBorderWidth(RtfCellProperties.CELLBORDER_TOP));
		properties.setBorderWidth(RtfCellProperties.CELLBORDER_LEFT,
		        getBorderWidth(RtfCellProperties.CELLBORDER_LEFT));
		properties.setBorderWidth(RtfCellProperties.CELLBORDER_RIGHT,
		        getBorderWidth(RtfCellProperties.CELLBORDER_RIGHT));

		properties.setCellPadding(RtfCellProperties.CELLBORDER_BOTTOM,
				getCellPadding(RtfCellProperties.CELLBORDER_BOTTOM));
		properties.setCellPadding(RtfCellProperties.CELLBORDER_TOP,
				getCellPadding(RtfCellProperties.CELLBORDER_TOP));
		properties.setCellPadding(RtfCellProperties.CELLBORDER_LEFT,
				getCellPadding(RtfCellProperties.CELLBORDER_LEFT));
		properties.setCellPadding(RtfCellProperties.CELLBORDER_RIGHT,
				getCellPadding(RtfCellProperties.CELLBORDER_RIGHT));

		properties.setVerticalAlignment(getVerticalAlignment());
		properties.setRowSpan(getRowSpan());
		properties.setFirstVerticalMerged(getFirstVerticalMerged());
		properties.setVerticalMerged(getVerticalMerged());
		
		properties.setColSpan(getColSpan());

		return properties;
	}

	void setTableIndex(int table) {
	    this._tableindex = table;
	}
	
	public int getTableIndex() {
	    return this._tableindex;
	}
	
	void setColumnIndex(int column) {
	    this._columnindex = column;
	}
	
	public int getColumnIndex() {
	    return this._columnindex;
	}
	
	void setRowIndex(int row) {
	    this._rowindex = row;
	}
	
	public int getRowIndex() {
	    return this._rowindex;
	}
	
	void setCellWidthDefType(int cellwidthdeftype) {
	    this._cellWidthDefType = cellwidthdeftype;
	}
	
	public int getCellWidthDefType() {
	    return this._cellWidthDefType;
	}
	
	void setWidth(int cellwidth) {
	    this._cellWidth = cellwidth;
	}
	
	public int getWidth() {
	    return this._cellWidth;
	}
	
	void setBorderWidth(int borderside, int width)
	{
	    switch (borderside) {
	    	case CELLBORDER_TOP:
	    	    this._borderWidthTop = width;
	    	    break;
	    	case CELLBORDER_BOTTOM:
	    	    this._borderWidthBottom = width;
	    	    break;
	    	case CELLBORDER_LEFT:
	    	    this._borderWidthLeft = width;
	    	    break;
	    	case CELLBORDER_RIGHT:
	    	    this._borderWidthRight = width;
	    	    break;
	    }
	}

	public int getBorderWidth(int borderside)
	{
	    switch (borderside) {
	    	case CELLBORDER_TOP:
	    	    return this._borderWidthTop;
	    	case CELLBORDER_BOTTOM:
	    	    return this._borderWidthBottom;
	    	case CELLBORDER_LEFT:
	    	    return this._borderWidthLeft;
	    	case CELLBORDER_RIGHT:
	    	    return this._borderWidthRight;
	    }
	    
	    return 0;
	}

	void setCellPadding(int borderside, int margin)
	{
	    switch (borderside) {
	    	case CELLBORDER_TOP:
	    	    this._borderMarginTop = margin;
	    	    break;
	    	case CELLBORDER_BOTTOM:
	    	    this._borderMarginBottom = margin;
	    	    break;
	    	case CELLBORDER_LEFT:
	    	    this._borderMarginLeft = margin;
	    	    break;
	    	case CELLBORDER_RIGHT:
	    	    this._borderMarginRight = margin;
	    	    break;
	    }
	}

	public int getCellPadding(int borderside)
	{
	    switch (borderside) {
	    	case CELLBORDER_TOP:
	    	    return this._borderMarginTop;
	    	case CELLBORDER_BOTTOM:
	    	    return this._borderMarginBottom;
	    	case CELLBORDER_LEFT:
	    	    return this._borderMarginLeft;
	    	case CELLBORDER_RIGHT:
	    	    return this._borderMarginRight;
	    }
	    
	    return 0;
	}

	void setVerticalAlignment(int align)
	{
		_verticalAlignment = align;
	}

	public int getVerticalAlignment()
	{
		return _verticalAlignment;
	}

	void setFirstVerticalMerged(boolean vmergedfirst)
	{
		this._isFirstVerticalMergedCell = vmergedfirst;
	}

	public boolean getFirstVerticalMerged()
	{
		return _isFirstVerticalMergedCell;
	}

	void setVerticalMerged(boolean vmerged)
	{
		this._isVerticalMergedCell = vmerged;
	}

	public boolean getVerticalMerged()
	{
		return _isVerticalMergedCell;
	}

	void addRowSpan(int increment)
	{
		_rowspan += increment;
	}

	void setRowSpan(int rowspan)
	{
	    _rowspan = rowspan;
	}
	
	public int getRowSpan()
	{
		return _rowspan;
	}

	void setColSpan(int colspan)
	{
	    _colspan = colspan;
	}
	
	public int getColSpan()
	{
		return _colspan;
	}

	public boolean hasTopBorderDefined() {
		return this._borderWidthTop > -1;
	}
	
	public boolean hasBottomBorderDefined() {
		return this._borderWidthBottom > -1;
	}
	
	public boolean hasLeftBorderDefined() {
		return this._borderWidthLeft > -1;
	}
	
	public boolean hasRightBorderDefined() {
		return this._borderWidthRight > -1;
	}
	
	public boolean hasNoBorderDefined() {
		return this._borderWidthRight == -1 &&
		       this._borderWidthLeft == -1 &&
		       this._borderWidthTop == -1 &&
		       this._borderWidthBottom == -1;
	}
	
	void Dump(PrintWriter out)
	{
	    // TODO check the output
	    
        out.print(" cellwidthtype=\""+getCellWidthDefType()+"\"");
        
	    if (getWidth() > 0) {
	        out.print(" cellwidth=\""+getWidth()+"\"");
	    }
	    if (hasBottomBorderDefined()) {
	        out.print(" border-bottom=\"true\"");
			out.print(" borderwidth_bottom=\"" + _borderWidthBottom + "\"");
	    }
	    if (hasLeftBorderDefined()) {
	        out.print(" border-left=\"true\"");
			out.print(" borderwidth_left=\"" + _borderWidthLeft + "\"");
	    }
	    if (hasRightBorderDefined()) {
	        out.print(" border-right=\"true\"");
			out.print(" borderwidth_right=\"" + _borderWidthRight + "\"");
	    }
	    if (hasTopBorderDefined()) {
	        out.print(" border-top=\"true\"");
			out.print(" borderwidth_top=\"" + _borderWidthTop + "\"");
	    }

	    if (this._borderMarginBottom > -1) {
			out.print(" bordermargin_bottom=\"" + _borderMarginBottom + "\"");
	    }
	    if (this._borderMarginLeft > -1) {
			out.print(" bordermargin_lef=\"" + _borderMarginLeft + "\"");
	    }
	    if (this._borderMarginRight > -1) {
			out.print(" bordermargin_right=\"" + _borderMarginRight + "\"");
	    }
	    if (this._borderMarginTop > -1) {
			out.print(" bordermargin_top=\"" + _borderMarginTop + "\"");
	    }

	    if (this._isFirstVerticalMergedCell) {
			out.print(" firstverticalmerged=\"true\"");
	    }
	    if (this._isVerticalMergedCell) {
			out.print(" verticalmerged=\"true\"");
	    }
	    if (this._colspan > 1) {
			out.print(" colspan=\""+_colspan+"\"");
	    }
	    if (this._rowspan > 1) {
			out.print(" rowspan=\""+_rowspan+"\"");
	    }

	    if (_verticalAlignment != VERT_ALIGN_TOP) {
			switch (_verticalAlignment) {
				case VERT_ALIGN_CENTER:
					out.print(" valign=\"center\"");
					break;
				case VERT_ALIGN_BOTTOM:
					out.print(" valign=\"bottom\"");
					break;
				default: break;
			}
		}
	}
}

