//===============================================================
// package : com.tetrasix.majix
// class : com.tetrasix.majix.Version
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix;

import java.text.DateFormat;
import java.util.Calendar;

/**
 * This class <code>Version</code> returns the program version and the
 * associated date.
 */
public class Version {

	/**
	 * This method returns the actual version of Majix.
	 * 
	 * @return the version-String
	 */
	static public String getVersion()
	{
		return "Majix 2.0";
	}

	/**
	 * This method returns the date of this version.
	 * 
	 * @return the date-String
	 */
	static public String getDate()
	{
		DateFormat fmt = DateFormat.getDateInstance(DateFormat.LONG);
		Calendar cal = Calendar.getInstance();
		cal.set(2004, Calendar.OCTOBER, 29);
		
		return fmt.format(cal.getTime());
	}
}
	