//===============================================================
// package : com.tetrasix.majix
// class : com.tetrasix.majix.DefaultConfiguration
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix;

import java.io.File;

import com.tetrasix.util.*;

public class DefaultConfiguration {

	static public void makeit()
	{
		String userdir = System.getProperty("user.dir");

		if (System.getProperty("java.vendor").equals("Microsoft Corp.")) {
			Configuration.setProperty("majix.enable.doc", "1");
			Configuration.setProperty("majix.dir.doc", checkDir(userdir + "\\docs"));
			Configuration.setProperty("majix.tool.browser", "explorer");
		}
		else {
			Configuration.setProperty("majix.enable.doc", "0");
			Configuration.setProperty("majix.dir.doc", checkDir(userdir + "\\docs"));
			Configuration.setProperty("majix.tool.browser", checkFile("C:\\Program Files\\Netscape\\Communicator\\Program\\netscape.exe -browser"));
		}

		Configuration.setProperty("majix.enable.nsgmls", "0");
		Configuration.setProperty("majix.tool.nsgmls", checkFile("c:\\sp\\bin\\nsgmls.exe"));
		Configuration.setProperty("majix.tool.nsgmls.catalog", "SGML_CATALOG_FILES=" + checkFile("c:\\sp\\pubtext\\xml.soc"));
		
		Configuration.setProperty("majix.enable.msword", "0");
	}

	static String checkDir(String dirname)
	{
		File d = new File(dirname);

		if (d.exists() && d.isDirectory()) {
			return dirname;
		}
		else {
			return "";
		}
	}

	static String checkFile(String filename)
	{
		File f = new File(filename);

		if (f.exists() && ! f.isDirectory()) {
			return filename;
		}
		else {
			return "";
		}
	}
}
	