import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import com.tetrasix.majix.rtf.RtfAnalyser;
import com.tetrasix.majix.rtf.RtfDocument;
import com.tetrasix.majix.rtf.RtfReader;
import com.tetrasix.majix.templates.ConversionTemplateFactory;
import com.tetrasix.majix.xml.ConversionTemplate;
import com.tetrasix.majix.xml.XmlGenerator;
import com.tetrasix.majix.xml.XmlGeneratorParam;
import com.tetrasix.majix.xml.XmlWriter;
import com.tetrasix.util.Configuration;

public class TestXMLGenerator {

	private boolean debug = false;
	private boolean dump;
	private String templatename= "mydoc";
	private ConversionTemplate template;
	private StringBuffer headerText = new StringBuffer();
	private XmlGenerator xmlGenerator;
	private Templates templates;
	
	private static final String DTD_NAME = "chemReport";
	private static final String DTD_FILE = "lib/chemReport.dtd";
	private static final String XSL_FILE = "lib/chemReport.xsl";

	
	public TestXMLGenerator() {
		initConverter();
	}
	
	
	private void initConverter() {
		
		System.setProperty("majix.dir", "lib/");
		System.setProperty("majix.conf", "majix.conf");

		Configuration.init("majix", true);	
		
		ConversionTemplateFactory factory = new ConversionTemplateFactory();
		this.template = factory.getConversionTemplate(templatename);	
		
		this.template.getGeneratorParam().setDtdName(DTD_NAME);
		this.template.getGeneratorParam().setDtdSystemId(DTD_FILE);
		
        xmlGenerator = new XmlGenerator(template);
		
        buildXMLHeader();

	}
	
	public void buildXMLHeader() {
		String is_xml = template.getGeneratorParam().getAttributes("ix");
        XmlGeneratorParam param = template.getGeneratorParam();
		
        param.getDtdName();
        
        
        if ((is_xml != null) && is_xml.equals("true")) {
            String pi = "<?xml version=\"1.0\"";
            String encoding = param.getActualTag("ec", true);
            if (!encoding.equals("")) {
                pi = pi + " encoding=\"" + encoding + "\"";
            }
            String standalone = param.getActualTag("sa", true);
            if (!standalone.equals("")) {
                if (standalone.equals("true")) {
                    pi = pi + " standalone=\"yes\"";
                } else {
                    pi = pi + " standalone=\"no\"";
                }
            }
            pi = pi + "?>";
            headerText.append(pi + "\n");
        }
        if (!param.getActualTag("sn", true).equals("")
                && !param.getActualTag("st", true).equals("")) {

//        	headerText.append("<?xml-stylesheet type=\""
//                    + param.getActualTag("st", true) + "\" href=\""
//                    + param.getActualTag("sn", true) + "\"?>" + "\n");
        }
	}
	
	
	public void convert2XML(InputStream inStream, OutputStream outStream) {
		long start = System.currentTimeMillis();
		try {

			// create The Reader for the input rtf File
			RtfReader reader = new RtfReader(inStream);

			// create a writer for the new XML File
	        BufferedOutputStream bos = new BufferedOutputStream(outStream);
	        XmlWriter xw = new XmlWriter(bos);
	
	        RtfAnalyser ana = new RtfAnalyser(reader, xw);
	        RtfDocument doc;
			doc = ana.parse();

			xw.println(headerText.toString());

	        if (dump) {
	        	headerText.append("<!-- dump of the DOCRTF intermediate structure");
	            doc.Dump(xw);
	            xw.println("-->");
	        }
			
	        xmlGenerator.reset();
	        xmlGenerator.setDebugFlag(debug);
//	        gen.setDirectory("lib");
//	        gen.setFileName("mydoc");
	        xmlGenerator.generate(doc, xw, null);
	
	        xw.flush();
	        xw.close();

		}catch (Exception e) {
			e.printStackTrace();
		}
		
		System.out.println("conversion took: " + (System.currentTimeMillis()-start));
	}
	
	public void setXSLTemplate(InputStream templateStream) throws TransformerConfigurationException {
		TransformerFactory tFactory = TransformerFactoryImpl.newInstance();
		StreamSource source = new StreamSource(templateStream);
        templates = tFactory.newTemplates(source);
	}
	
	public void convert2HTML(InputStream inStream, OutputStream outStream) throws TransformerException {
		
         Transformer transformer = templates.newTransformer();
         StreamSource sourceXML = new StreamSource(inStream);
         StreamResult result = new StreamResult(outStream);
         transformer.transform(sourceXML, result);
         
	}
	
	
	
	
	public static void main(String[] args) {
		
		try {
		
			TestXMLGenerator generator = new TestXMLGenerator();
			
			FileInputStream fin = new FileInputStream(new File("/home/hermenj/rtf/test.rtf"));
			
			FileInputStream template = new FileInputStream(new File(XSL_FILE));
			
			FileOutputStream fout = new FileOutputStream(new File("/home/hermenj/rtf/test.html"));
			
			ByteArrayOutputStream xmlOut = new ByteArrayOutputStream();
			
			generator.setXSLTemplate(template);
			
			generator.convert2XML(fin, xmlOut);

			ByteArrayOutputStream bous = new ByteArrayOutputStream();
			
			System.out.println(xmlOut.toString());
			
			generator.convert2HTML(new ByteArrayInputStream(xmlOut.toByteArray()), bous);
			
			
			FileInputStream fin2  = new FileInputStream(new File("/home/hermenj/rtf/test.html"));
			byte[] buffer2 = new byte[8];
			while (fin2.read(buffer2,0,buffer2.length) != -1)
			{
				bous.write(buffer2);
			}
			
			ReportViewer viewer = new ReportViewer();
			
			
//			.replaceAll("<P></P>", "")
			
			String test = bous.toString().replaceAll("<META.*>","");
			
//			System.out.println(test);
			viewer.showDocument(test);
			
//			fout.write(test.getBytes());
//			fout.close();
		
//			viewer.setVisible(true);
			
			
		}catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
	}
	
}
