/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.crypto.digest.exceptions;

public class Crypto_Exception
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final int LTEC_CRYPTO_GENERAL_ERROR = 65536;
    private static final String LTEC_CRYPTO_GENERAL_ERROR_TEXT = "GENERAL_ERROR";
    public static final int LTEC_CRYPTO_BAD_ARGUMENT = 65537;
    private static final String LTEC_CRYPTO_BAD_ARGUMENT_TEXT = "BAD_ARGUMENT";
    public static final int LTEC_CRYPTO_NOT_SUPPORTED_ALGORITHM = 65538;
    private static final String LTEC_CRYPTO_NOT_SUPPORTED_ALGORITHM_TEXT = "NOT_SUPPORTED_ALGORITHM";

    public Crypto_Exception() {
    }

    public Crypto_Exception(String message) {
        super(message);
    }

    public Crypto_Exception(int code, String message) {
        this("LTEC:" + code + ":" + message);
    }

    public Crypto_Exception(int code, String message, Throwable t) {
        super("LTEC:" + code + ":" + message, t);
    }

    public Crypto_Exception(int code, Throwable t) {
        super("LTEC:" + code + ":", t);
    }

    public String getName() {
        int _code = this.getCode();
        if (_code > 0) {
            switch (_code) {
                case 65536: {
                    return LTEC_CRYPTO_GENERAL_ERROR_TEXT;
                }
                case 65537: {
                    return LTEC_CRYPTO_BAD_ARGUMENT_TEXT;
                }
                case 65538: {
                    return LTEC_CRYPTO_NOT_SUPPORTED_ALGORITHM_TEXT;
                }
            }
            return null;
        }
        return null;
    }

    public int getCode() {
        if (this.getMessage() != null && !this.getMessage().equals("")) {
            String message = this.getMessage();
            String code = message.substring(message.indexOf(":") + 1, message.lastIndexOf(":"));
            int _code = Integer.parseInt(code);
            return _code;
        }
        return 0;
    }
}

