/*
 * Decompiled with CFR 0.152.
 */
package lu.luxtrust.crypto.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import lu.luxtrust.crypto.digest.DigestAlgorithm;
import lu.luxtrust.crypto.digest.exceptions.Crypto_Exception;
import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;

public class Digester {
    private Log logger = Logger.getLogger(Digester.class);

    public byte[] calculateHash(byte[] data, DigestAlgorithm algorithm) throws Crypto_Exception {
        if (data == null) {
            this.logger.error("The data to hash cannot be null", 65537);
            throw new Crypto_Exception(65537, "The data to hash cannot be null");
        }
        if (algorithm == null) {
            this.logger.error("The hash alorithm cannot be null", 65537);
            throw new Crypto_Exception(65537, "The hash alorithm cannot be null");
        }
        MessageDigest messageDigest = null;
        byte[] newHashValue = null;
        try {
            messageDigest = MessageDigest.getInstance(algorithm.value());
            newHashValue = messageDigest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("The provided digest algortihm is not supported: " + algorithm.value(), (Throwable)e, 65538);
            throw new Crypto_Exception(65538, "The provided digest algortihm is not supported");
        }
        return newHashValue;
    }
}

