/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import tracing.EventDispatchThreadHangMonitor;

public final class EventDispatchThreadHangMonitor
extends EventQueue {
    private static final EventDispatchThreadHangMonitor INSTANCE = new EventDispatchThreadHangMonitor();
    private static final long CHECK_INTERVAL_MS = 100L;
    private static final long UNREASONABLE_DISPATCH_DURATION_MS = 1000L;
    private static int hangCount = 0;
    private boolean haveShownSomeComponent = false;
    private final LinkedList<DispatchInfo> dispatches = new LinkedList();

    private EventDispatchThreadHangMonitor() {
        this.initTimer();
    }

    private void initTimer() {
        long l = 0L;
        boolean bl = true;
        Timer timer = new Timer("EventDispatchThreadHangMonitor", true);
        timer.schedule((TimerTask)new HangChecker(), 0L, 100L);
    }

    public static void initMonitoring() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(INSTANCE);
    }

    protected void dispatchEvent(AWTEvent event) {
        try {
            this.preDispatchEvent();
            super.dispatchEvent(event);
        }
        finally {
            this.postDispatchEvent();
            if (!this.haveShownSomeComponent && event instanceof WindowEvent && event.getID() == 200) {
                this.haveShownSomeComponent = true;
            }
        }
    }

    private void debug(String which) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void preDispatchEvent() {
        this.debug("pre");
        LinkedList<DispatchInfo> linkedList = this.dispatches;
        synchronized (linkedList) {
            this.dispatches.addLast(new DispatchInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void postDispatchEvent() {
        LinkedList<DispatchInfo> linkedList = this.dispatches;
        synchronized (linkedList) {
            DispatchInfo justFinishedDispatch = this.dispatches.removeLast();
            justFinishedDispatch.dispose();
            Thread currentEventDispatchThread = Thread.currentThread();
            for (DispatchInfo dispatchInfo : this.dispatches) {
                if (dispatchInfo.eventDispatchThread != currentEventDispatchThread) continue;
                dispatchInfo.lastDispatchTimeMillis = System.currentTimeMillis();
            }
        }
        this.debug("post");
    }

    private static void checkForDeadlock() {
        ThreadInfo[] threadInfos;
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] threadIds = threadBean.findMonitorDeadlockedThreads();
        if (threadIds == null) {
            return;
        }
        Log.warn("deadlock detected involving the following threads:");
        ThreadInfo[] threadInfoArray = threadInfos = threadBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
        int n = 0;
        int n2 = threadInfoArray.length;
        while (n < n2) {
            ThreadInfo info = threadInfoArray[n];
            Log.warn("Thread #" + info.getThreadId() + " " + info.getThreadName() + " (" + (Object)((Object)info.getThreadState()) + ") waiting on " + info.getLockName() + " held by " + info.getLockOwnerName() + EventDispatchThreadHangMonitor.stackTraceToString(info.getStackTrace()));
            ++n;
        }
    }

    private static String stackTraceToString(StackTraceElement[] stackTrace) {
        StringBuilder result = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = 0;
        int n2 = stackTraceElementArray.length;
        while (n < n2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            String indentation = "    ";
            result.append("\n" + indentation + stackTraceElement);
            ++n;
        }
        return result.toString();
    }

    private static synchronized int getNewHangNumber() {
        return ++hangCount;
    }

    public static void main(String[] args) {
        EventDispatchThreadHangMonitor.initMonitoring();
        if (args.length > 0 && "deadlock".equals(args[0])) {
            EventDispatchThreadHangMonitor.INSTANCE.haveShownSomeComponent = true;
            Tests.runDeadlockTest();
            return;
        }
        Tests.main(args);
    }

    private static class DispatchInfo {
        private StackTraceElement[] lastReportedStack;
        private int hangNumber;
        private final Thread eventDispatchThread = Thread.currentThread();
        private long lastDispatchTimeMillis = System.currentTimeMillis();

        public void checkForHang() {
            if (this.timeSoFar() > 1000L) {
                this.examineHang();
            }
        }

        private static boolean stackTraceElementIs(StackTraceElement e, String className, String methodName, boolean isNative) {
            return e.getClassName().equals(className) && e.getMethodName().equals(methodName) && e.isNativeMethod() == isNative;
        }

        private boolean isWaitingForNextEvent(StackTraceElement[] currentStack) {
            return DispatchInfo.stackTraceElementIs(currentStack[0], "java.lang.Object", "wait", true) && DispatchInfo.stackTraceElementIs(currentStack[1], "java.lang.Object", "wait", false) && DispatchInfo.stackTraceElementIs(currentStack[2], "java.awt.EventQueue", "getNextEvent", false);
        }

        private void examineHang() {
            StackTraceElement[] currentStack = this.eventDispatchThread.getStackTrace();
            if (this.isWaitingForNextEvent(currentStack)) {
                return;
            }
            if (DispatchInfo.stacksEqual(this.lastReportedStack, currentStack)) {
                return;
            }
            this.hangNumber = EventDispatchThreadHangMonitor.getNewHangNumber();
            String stackTrace = EventDispatchThreadHangMonitor.stackTraceToString(currentStack);
            this.lastReportedStack = currentStack;
            Log.warn("(hang #" + this.hangNumber + ") event dispatch thread stuck processing event for " + this.timeSoFar() + " ms:" + stackTrace);
            EventDispatchThreadHangMonitor.checkForDeadlock();
        }

        private static boolean stacksEqual(StackTraceElement[] a, StackTraceElement[] b) {
            if (a == null) {
                return false;
            }
            if (a.length != b.length) {
                return false;
            }
            int i = 0;
            while (i < a.length) {
                if (!a[i].equals(b[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private long timeSoFar() {
            return System.currentTimeMillis() - this.lastDispatchTimeMillis;
        }

        public void dispose() {
            if (this.lastReportedStack != null) {
                Log.warn("(hang #" + this.hangNumber + ") event dispatch thread unstuck after " + this.timeSoFar() + " ms.");
            }
        }
    }

    private class HangChecker
    extends TimerTask {
        private HangChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList linkedList = EventDispatchThreadHangMonitor.this.dispatches;
            synchronized (linkedList) {
                if (EventDispatchThreadHangMonitor.this.dispatches.isEmpty() || !EventDispatchThreadHangMonitor.this.haveShownSomeComponent) {
                    return;
                }
                ((DispatchInfo)EventDispatchThreadHangMonitor.this.dispatches.getLast()).checkForHang();
            }
        }
    }

    private static class Tests {
        private Tests() {
        }

        public static void main(final String[] args) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    String[] stringArray = args;
                    int n = 0;
                    int n2 = stringArray.length;
                    while (n < n2) {
                        String arg = stringArray[n];
                        JFrame frame = new JFrame();
                        frame.setDefaultCloseOperation(3);
                        frame.setLocationRelativeTo(null);
                        if (arg.equals("exception")) {
                            Tests.runExceptionTest(frame);
                        } else if (arg.equals("focus")) {
                            Tests.runFocusTest(frame);
                        } else if (arg.equals("modal-hang")) {
                            Tests.runModalTest(frame, true);
                        } else if (arg.equals("modal-no-hang")) {
                            Tests.runModalTest(frame, false);
                        } else {
                            System.err.println("unknown regression test '" + arg + "'");
                            System.exit(1);
                        }
                        frame.pack();
                        frame.setVisible(true);
                        ++n;
                    }
                }
            });
        }

        private static void runDeadlockTest() {
            class Locker {
                private Locker locker;

                Locker() {
                }

                public void setLocker(Locker locker) {
                    this.locker = locker;
                }

                public synchronized void tryToDeadlock() {
                    this.locker.toString();
                }

                public synchronized String toString() {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return super.toString();
                }
            }
            final Locker one = new Locker();
            Locker two = new Locker();
            one.setLocker(two);
            two.setLocker(one);
            int i = 0;
            while (i < 100) {
                SwingUtilities.invokeLater(new Runnable(){
                    {
                    }

                    public void run() {
                        one.tryToDeadlock();
                    }
                });
                two.tryToDeadlock();
                ++i;
            }
        }

        private static void runExceptionTest(JFrame frame) {
            JButton button = new JButton("Throw Exception");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    throw new RuntimeException("Nobody expects the Spanish Inquisition!");
                }
            });
            frame.add(button);
        }

        private static void runFocusTest(JFrame frame) {
            final JDialog dialog = new JDialog((Frame)frame, "Non-Modal Dialog");
            dialog.add(new JLabel("Close me!"));
            dialog.pack();
            dialog.setLocationRelativeTo(frame);
            dialog.addWindowFocusListener(new WindowAdapter(){

                public void windowGainedFocus(WindowEvent e) {
                    System.out.println("FocusTest.windowGainedFocus");
                    Tests.sleep(2500L);
                }
            });
            JButton button = new JButton("Show Non-Modal Dialog");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(true);
                }
            });
            frame.add(button);
        }

        private static void runModalTest(final JFrame frame, final boolean shouldSleep) {
            System.out.println(shouldSleep ? "Expect hangs!" : "There should be no hangs...");
            JButton button = new JButton("Show Modal Dialog");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (shouldSleep) {
                        Tests.sleep(2500L);
                    }
                    JDialog dialog = new JDialog(frame, "Modal dialog", true);
                    dialog.setLayout(new FlowLayout());
                    dialog.add(new JLabel("Close this dialog!"));
                    JLabel label = new JLabel(" ");
                    dialog.add(label);
                    dialog.pack();
                    dialog.setLocation(frame.getX() - 100, frame.getY());
                    new Thread(new Runnable(this, label){
                        final /* synthetic */ 6 this$2;
                        private final /* synthetic */ JLabel val$label;
                        {
                            this.this$2 = var1_1;
                            this.val$label = jLabel;
                        }

                        public void run() {
                            int i = 0;
                            while (i <= 100000) {
                                int value = i++;
                                EventQueue.invokeLater(new Runnable(this, this.val$label, value){
                                    final /* synthetic */ 1 this$3;
                                    private final /* synthetic */ JLabel val$label;
                                    private final /* synthetic */ int val$value;
                                    {
                                        this.this$3 = var1_1;
                                        this.val$label = jLabel;
                                        this.val$value = n;
                                    }

                                    public void run() {
                                        this.val$label.setText(Integer.toString(this.val$value));
                                    }
                                });
                            }
                        }
                    }).start();
                    dialog.setVisible(true);
                    if (shouldSleep) {
                        Tests.sleep(2500L);
                    }
                }
            });
            frame.add(button);
        }

        private static void sleep(long ms) {
            try {
                System.out.println("Sleeping for " + ms + " ms on " + Thread.currentThread() + "...");
                Thread.sleep(ms);
                System.out.println("Finished sleeping...");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class Log {
        private Log() {
        }

        public static void warn(String str) {
            System.out.println(str);
        }
    }
}

