/*
 * Decompiled with CFR 0.152.
 */
package com.netghost.perkup.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class RenderingComponent
extends JComponent
implements PropertyChangeListener,
ComponentListener {
    protected BufferedImage buffer;
    private boolean bufferDirty = true;
    private Component source;
    private BufferedImageOp filter;
    private Color clear;
    float p;

    public RenderingComponent(Component source) {
        this.setSource(source);
        this.clear = new Color(1, 1, 1, 0);
        this.p = 0.75f;
        this.setDoubleBuffered(true);
        this.add(source);
    }

    public Component getSource() {
        return this.source;
    }

    public void setSource(Component source) {
        if (this.source != null) {
            this.source.removePropertyChangeListener(this);
            this.source.removeComponentListener(this);
        }
        this.source = source;
        source.addPropertyChangeListener(this);
        source.addComponentListener(this);
    }

    protected BufferedImage createBuffer() {
        this.buffer = new BufferedImage(this.source.getWidth(), this.source.getHeight(), 2);
        return this.buffer;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int width = this.source.getWidth();
        int height = this.source.getHeight();
        if (this.bufferDirty) {
            Graphics2D sg = this.createBuffer().createGraphics();
            sg.setClip(0, 0, width, height);
            this.source.paint(sg);
            sg.dispose();
            this.bufferDirty = false;
        }
        g2.setColor(Color.RED);
        g2.setComposite(AlphaComposite.getInstance(10, this.p));
        g2.drawImage(this.buffer, this.filter, (this.getWidth() - width) / 2, (this.getHeight() - height) / 2);
    }

    protected void paintChildren(Graphics graphics) {
    }

    public BufferedImageOp getFilter() {
        return this.filter;
    }

    public void setFilter(BufferedImageOp filter) {
        this.filter = filter;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.bufferDirty = true;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.bufferDirty = true;
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

