/*
 * Decompiled with CFR 0.152.
 */
package com.netghost.perkup.demo;

import com.netghost.perkup.swing.SimpleTile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class TileComponentDemo
extends JFrame {
    List<SimpleTile> tiles = new ArrayList<SimpleTile>();
    JCheckBox showIcons;

    public TileComponentDemo() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("Sample Tiles", null, 0), "North");
        JPanel samples = new JPanel();
        samples.setLayout(new BoxLayout(samples, 1));
        samples.add(this.createDemoPanel("Small Tile", "Info", new ImageIcon(this.getClass().getResource("/info.png")), "A small tile."));
        samples.add(this.createDemoPanel("No icon", "Iconless", null, "I'd look nicer with an icon."));
        samples.add(this.createDemoPanel("Large Tile", "More Info", new ImageIcon(this.getClass().getResource("/info_big.png")), "A larger tile, you should see some word wrapping."));
        samples.add(this.createDemoPanel("Huge Tile", "Enormous", new ImageIcon(this.getClass().getResource("/display.png")), "This is just huge.  I could put all of Shakespeare here.\nTo be, or not to be\nThat is the most quoted question."));
        JScrollPane scroll = new JScrollPane(samples);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scroll, "Center");
        this.showIcons = new JCheckBox("Show icons", true);
        this.showIcons.addActionListener(new ToggleIcons(this.tiles));
        this.add((Component)this.showIcons, "South");
    }

    public JPanel createDemoPanel(String title, String text, Icon icon, String description) {
        JPanel demoPanel = new JPanel();
        demoPanel.setLayout(new FlowLayout(0));
        JLabel label = new JLabel(title + ":");
        System.err.println("Icon: " + icon + " ");
        if (icon != null) {
            System.err.println("\t" + icon.getIconWidth() + "x" + icon.getIconHeight());
        }
        SimpleTile tile = new SimpleTile(text, icon, description);
        tile.addMouseListener(new TileHilighter(tile));
        demoPanel.add(label);
        demoPanel.add(tile);
        this.tiles.add(tile);
        return demoPanel;
    }

    public static void main(String[] args) {
        TileComponentDemo demo = new TileComponentDemo();
        demo.setSize(256, 256);
        demo.setTitle("Tile Demo");
        demo.pack();
        demo.setVisible(true);
        demo.setDefaultCloseOperation(3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ToggleIcons
    implements ActionListener {
        List<SimpleTile> tiles;

        public ToggleIcons(List<SimpleTile> tiles) {
            this.tiles = tiles;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (SimpleTile tile : this.tiles) {
                tile.setIconVisible(TileComponentDemo.this.showIcons.isSelected());
            }
        }
    }

    protected class TileHilighter
    extends MouseAdapter {
        Color normal;
        Color selected;
        SimpleTile tile;

        public TileHilighter(SimpleTile tile) {
            this.tile = tile;
            this.normal = tile.getBackground();
            this.selected = UIManager.getDefaults().getColor("List.selectionBackground");
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.tile.setBackground(this.normal);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.tile.setBackground(this.selected);
        }
    }
}

