/*
 * Decompiled with CFR 0.152.
 */
package com.netghost.perkup;

import com.netghost.perkup.WindowPresenter;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.Point2D;

public class WindowSlider
implements WindowPresenter {
    public static final int NORTH_WEST = 0;
    public static final int NORTH_EAST = 1;
    public static final int SOUTH_WEST = 2;
    public static final int SOUTH_EAST = 3;
    private long displayTime;
    private int corner;
    private GraphicsConfiguration gc;

    public WindowSlider() {
        this(500L);
    }

    public WindowSlider(long displayTime) {
        this.setDisplayTime(displayTime);
        this.gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        this.setCorner(this.pickCorner());
    }

    public WindowSlider(Window parent) {
        this.setDisplayTime(500L);
        this.gc = parent.getGraphicsConfiguration();
        this.setCorner(this.pickCorner());
    }

    protected int pickCorner() {
        String os = System.getProperty("os.name");
        int c = 3;
        if (os.startsWith("Windows ")) {
            Insets i = Toolkit.getDefaultToolkit().getScreenInsets(this.gc);
            c = i.top <= i.bottom ? 3 : 1;
        } else if (os.startsWith("Mac ")) {
            c = 1;
        }
        return c;
    }

    public void setCorner(int corner) {
        this.corner = corner;
    }

    public void setGraphicsConfiguration(GraphicsConfiguration gc) {
        this.gc = gc;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.gc;
    }

    public void showWindow(Window window) {
        Point2D.Float start = this.getStartPoint(window);
        Point2D.Float end = this.getTargetPoint(window);
        window.setLocation((int)start.x, (int)start.y);
        window.setAlwaysOnTop(false);
        window.show();
        window.repaint();
        window.setFocusableWindowState(false);
        window.toFront();
        this.moveWindow(start, end, window);
        window.setAlwaysOnTop(true);
    }

    public void hideWindow(Window window) {
        Point2D.Float start = this.getTargetPoint(window);
        Point2D.Float end = this.getStartPoint(window);
        this.moveWindow(start, end, window);
        window.hide();
    }

    protected void moveWindow(Point2D.Float start, Point2D.Float end, Window window) {
        long time = System.currentTimeMillis();
        long endTime = time + this.getDisplayTime();
        while ((time = System.currentTimeMillis()) < endTime) {
            double p = 1.0f - (float)(endTime - time) / (float)this.getDisplayTime();
            window.setLocation((int)((double)(end.x - start.x) * p + (double)start.x), (int)((double)(end.y - start.y) * p + (double)start.y));
        }
        window.setLocation((int)end.x, (int)end.y);
    }

    private Rectangle getViewableScreen() {
        Insets i = Toolkit.getDefaultToolkit().getScreenInsets(this.gc);
        Rectangle b = this.gc.getBounds();
        Rectangle viewable = new Rectangle(b.x + i.left, b.y + i.top, b.width - i.right, b.height - i.bottom);
        return viewable;
    }

    protected Point2D.Float getStartPoint(Window window) {
        Rectangle r = this.getViewableScreen();
        switch (this.getCorner()) {
            case 0: {
                return new Point2D.Float(r.x, r.y - window.getHeight());
            }
            case 1: {
                return new Point2D.Float(r.x + r.width - window.getWidth(), r.y - window.getHeight());
            }
            case 2: {
                return new Point2D.Float(r.x, r.y + r.height);
            }
            case 3: {
                return new Point2D.Float(r.x + r.width - window.getWidth(), r.y + r.height);
            }
        }
        return new Point2D.Float(r.x, r.y - window.getHeight());
    }

    protected Point2D.Float getTargetPoint(Window window) {
        Rectangle r = this.getViewableScreen();
        switch (this.getCorner()) {
            case 0: {
                return new Point2D.Float(r.x, r.y);
            }
            case 1: {
                return new Point2D.Float(r.x + r.width - window.getWidth(), r.y);
            }
            case 2: {
                return new Point2D.Float(r.x, r.y + r.height - window.getHeight());
            }
            case 3: {
                return new Point2D.Float(r.x + r.width - window.getWidth(), r.y + r.height - window.getHeight());
            }
        }
        return new Point2D.Float(r.x, r.y);
    }

    public int getCorner() {
        return this.corner;
    }

    public long getDisplayTime() {
        return this.displayTime;
    }

    public void setDisplayTime(long displayTime) {
        this.displayTime = displayTime;
    }
}

