/*
 * Decompiled with CFR 0.152.
 */
package com.netghost.perkup;

import com.netghost.perkup.DefaultNotification;
import com.netghost.perkup.DefaultNotificationHandler;
import com.netghost.perkup.Notification;
import com.netghost.perkup.NotificationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Notifier {
    private static Notifier perkup;
    private AlertThread alertThread;
    private NotificationHandler handler = new DefaultNotificationHandler();

    public static Notifier getDefault() {
        if (perkup == null) {
            perkup = new Notifier();
        }
        return perkup;
    }

    public void alert(String message) {
        this.alert(new DefaultNotification(message));
    }

    public void alert(Notification notification) {
        if (this.alertThread == null) {
            this.alertThread = new AlertThread();
            this.alertThread.start();
        }
        this.alertThread.addAlert(notification);
    }

    public NotificationHandler getHandler() {
        return this.handler;
    }

    public void setHandler(NotificationHandler handler) {
        this.handler = handler;
    }

    private class AlertThread
    implements Runnable {
        private List alerts = Collections.synchronizedList(new ArrayList(4));
        private Thread alertThread;

        public void start() {
            if (this.alertThread == null) {
                this.alertThread = new Thread((Runnable)this, "AlertThread");
                this.alertThread.setDaemon(true);
                this.alertThread.start();
            }
        }

        public void stop() {
            Thread oldThread = this.alertThread;
            this.alertThread = null;
            if (oldThread != null) {
                oldThread.interrupt();
            }
        }

        public void run() {
            Thread currentThread = Thread.currentThread();
            while (currentThread == this.alertThread) {
                Notification alert = this.getAlert();
                if (alert == null) continue;
                Notifier.this.handler.handleNotification(alert);
            }
        }

        public synchronized void addAlert(Notification notification) {
            this.alerts.add(notification);
            this.notify();
        }

        public synchronized Notification getAlert() {
            Object alert = null;
            try {
                while (this.alerts.isEmpty()) {
                    this.wait();
                }
                alert = this.alerts.remove(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return alert;
        }
    }
}

