/*
 * Decompiled with CFR 0.152.
 */
package com.netghost.perkup;

public class NotificationPriority
implements Comparable {
    private static final int HIGH_VALUE = 0;
    private static final int NORMAL_VALUE = 100;
    private static final int LOW_VALUE = 500;
    public static final NotificationPriority HIGH = new NotificationPriority(0);
    public static final NotificationPriority NORMAL = new NotificationPriority(100);
    public static final NotificationPriority LOW = new NotificationPriority(500);
    int priority;
    long expiresAt;
    boolean displayIfExpired = false;

    private NotificationPriority(int priority) {
        this.priority = priority;
        this.expiresAt = -1L;
    }

    private NotificationPriority(int priority, long expiresAt) {
        this.priority = priority;
        this.expiresAt = expiresAt;
    }

    public static NotificationPriority expiresIn(long millis) {
        return new NotificationPriority(0, System.currentTimeMillis() + millis);
    }

    public static NotificationPriority expiresIn(long millis, boolean displayIfExpired) {
        NotificationPriority p = new NotificationPriority(0, System.currentTimeMillis() + millis);
        p.displayIfExpired = displayIfExpired;
        return p;
    }

    public int compareTo(Object o) {
        if (o instanceof NotificationPriority) {
            NotificationPriority p = (NotificationPriority)o;
            int returnValue = this.priority - p.priority;
            if (returnValue == 0) {
                returnValue = (int)(this.expiresAt - p.expiresAt);
            }
            return returnValue;
        }
        throw new IllegalArgumentException("NotificationPriorities may only be compared to like objects.");
    }
}

