/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.xml;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.xml.SAXAdapter;
import org.objectweb.asm.xml.SAXClassAdapter;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SAXAnnotationAdapter
extends SAXAdapter
implements AnnotationVisitor {
    private final String elementName;

    public SAXAnnotationAdapter(ContentHandler contentHandler, String string, int n2, String string2, String string3) {
        this(contentHandler, string, n2, string3, string2, -1);
    }

    public SAXAnnotationAdapter(ContentHandler contentHandler, String string, int n2, int n3, String string2) {
        this(contentHandler, string, n2, string2, null, n3);
    }

    private SAXAnnotationAdapter(ContentHandler contentHandler, String string, int n2, String string2, String string3, int n3) {
        super(contentHandler);
        this.elementName = string;
        AttributesImpl attributesImpl = new AttributesImpl();
        if (string3 != null) {
            attributesImpl.addAttribute("", "name", "name", "", string3);
        }
        if (n2 != 0) {
            attributesImpl.addAttribute("", "visible", "visible", "", n2 > 0 ? "true" : "false");
        }
        if (n3 != -1) {
            attributesImpl.addAttribute("", "parameter", "parameter", "", Integer.toString(n3));
        }
        if (string2 != null) {
            attributesImpl.addAttribute("", "desc", "desc", "", string2);
        }
        this.addStart(string, attributesImpl);
    }

    public void visit(String string, Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            AnnotationVisitor annotationVisitor = this.visitArray(string);
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    annotationVisitor.visit(null, new Byte(byArray[i2]));
                }
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                for (int i3 = 0; i3 < cArray.length; ++i3) {
                    annotationVisitor.visit(null, new Character(cArray[i3]));
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                for (int i4 = 0; i4 < sArray.length; ++i4) {
                    annotationVisitor.visit(null, new Short(sArray[i4]));
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                for (int i5 = 0; i5 < blArray.length; ++i5) {
                    annotationVisitor.visit(null, blArray[i5]);
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                for (int i6 = 0; i6 < nArray.length; ++i6) {
                    annotationVisitor.visit(null, new Integer(nArray[i6]));
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                for (int i7 = 0; i7 < lArray.length; ++i7) {
                    annotationVisitor.visit(null, new Long(lArray[i7]));
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                for (int i8 = 0; i8 < fArray.length; ++i8) {
                    annotationVisitor.visit(null, new Float(fArray[i8]));
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                for (int i9 = 0; i9 < dArray.length; ++i9) {
                    annotationVisitor.visit(null, new Double(dArray[i9]));
                }
            }
            annotationVisitor.visitEnd();
        } else {
            this.addValueElement("annotationValue", string, Type.getDescriptor(clazz), object.toString());
        }
    }

    public void visitEnum(String string, String string2, String string3) {
        this.addValueElement("annotationValueEnum", string, string2, string3);
    }

    public AnnotationVisitor visitAnnotation(String string, String string2) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotationValueAnnotation", 0, string, string2);
    }

    public AnnotationVisitor visitArray(String string) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotationValueArray", 0, string, null);
    }

    public void visitEnd() {
        this.addEnd(this.elementName);
    }

    private void addValueElement(String string, String string2, String string3, String string4) {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (string2 != null) {
            attributesImpl.addAttribute("", "name", "name", "", string2);
        }
        if (string3 != null) {
            attributesImpl.addAttribute("", "desc", "desc", "", string3);
        }
        if (string4 != null) {
            attributesImpl.addAttribute("", "value", "value", "", SAXClassAdapter.encode(string4));
        }
        this.addElement(string, attributesImpl);
    }
}

