/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.LocalVariablesSorter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingAnnotationAdapter;

public class RemappingMethodAdapter
extends LocalVariablesSorter {
    protected final Remapper remapper;

    public RemappingMethodAdapter(int n2, String string, MethodVisitor methodVisitor, Remapper remapper) {
        super(n2, string, methodVisitor);
        this.remapper = remapper;
    }

    public void visitFieldInsn(int n2, String string, String string2, String string3) {
        super.visitFieldInsn(n2, this.remapper.mapType(string), this.remapper.mapFieldName(string, string2, string3), this.remapper.mapDesc(string3));
    }

    public void visitMethodInsn(int n2, String string, String string2, String string3) {
        super.visitMethodInsn(n2, this.remapper.mapType(string), this.remapper.mapMethodName(string, string2, string3), this.remapper.mapMethodDesc(string3));
    }

    public void visitTypeInsn(int n2, String string) {
        super.visitTypeInsn(n2, this.remapper.mapType(string));
    }

    public void visitLdcInsn(Object object) {
        super.visitLdcInsn(this.remapper.mapValue(object));
    }

    public void visitMultiANewArrayInsn(String string, int n2) {
        super.visitMultiANewArrayInsn(this.remapper.mapDesc(string), n2);
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        super.visitTryCatchBlock(label, label2, label3, string == null ? null : this.remapper.mapType(string));
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        super.visitLocalVariable(string, this.remapper.mapDesc(string2), this.remapper.mapSignature(string3, true), label, label2, n2);
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        AnnotationVisitor annotationVisitor = this.mv.visitAnnotation(string, bl);
        return annotationVisitor == null ? annotationVisitor : new RemappingAnnotationAdapter(annotationVisitor, this.remapper);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitor annotationVisitor = this.mv.visitAnnotationDefault();
        return annotationVisitor == null ? annotationVisitor : new RemappingAnnotationAdapter(annotationVisitor, this.remapper);
    }

    public AnnotationVisitor visitParameterAnnotation(int n2, String string, boolean bl) {
        AnnotationVisitor annotationVisitor = this.mv.visitParameterAnnotation(n2, string, bl);
        return annotationVisitor == null ? annotationVisitor : new RemappingAnnotationAdapter(annotationVisitor, this.remapper);
    }

    public void visitFrame(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        super.visitFrame(n2, n3, this.remapEntries(n3, objectArray), n4, this.remapEntries(n4, objectArray2));
    }

    private Object[] remapEntries(int n2, Object[] objectArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!(objectArray[i2] instanceof String)) continue;
            Object[] objectArray2 = new Object[n2];
            if (i2 > 0) {
                System.arraycopy(objectArray, 0, objectArray2, 0, i2);
            }
            do {
                Object object = objectArray[i2];
                Object object2 = objectArray2[i2++] = object instanceof String ? this.remapper.mapType((String)object) : object;
            } while (i2 < n2);
            return objectArray2;
        }
        return objectArray;
    }
}

