/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.dyndns.fichtner.rsccheck.util.AttributeSetter;

public class BeanInfoAttributeSetter
implements AttributeSetter {
    private Method getSetter(Object object, String string) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptorArray = this.getDescriptors(object);
        for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i2];
            if (!string.equals(propertyDescriptor.getName()) || propertyDescriptor.getWriteMethod() == null || !this.hasStringArg(propertyDescriptor.getWriteMethod())) continue;
            return propertyDescriptor.getWriteMethod();
        }
        return null;
    }

    private PropertyDescriptor[] getDescriptors(Object object) throws IntrospectionException {
        return Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
    }

    private boolean hasStringArg(Method method) {
        return method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == String.class;
    }

    public void setAttribute(Object object, String string, Object object2) {
        if (object == null) {
            throw new RuntimeException("bean must not be null");
        }
        if (string == null) {
            throw new RuntimeException("attribName must not be null");
        }
        try {
            Method method = this.getSetter(object, string);
            if (method == null) {
                throw new RuntimeException("Unable to set attribute " + string + " (available: " + Arrays.toString(this.getAvailableAttribs(object)) + ")");
            }
            method.invoke(object, object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw this.createEx(string, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.createEx(string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.createEx(string, invocationTargetException.getTargetException());
        }
        catch (IntrospectionException introspectionException) {
            throw this.createEx(string, introspectionException);
        }
    }

    private RuntimeException createEx(String string, Throwable throwable) {
        return new RuntimeException("Error setting " + string + ": " + throwable.getMessage(), throwable);
    }

    private String[] getAvailableAttribs(Object object) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptorArray = this.getDescriptors(object);
        ArrayList<String> arrayList = new ArrayList<String>(propertyDescriptorArray.length);
        for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
            Method method = propertyDescriptorArray[i2].getWriteMethod();
            if (method == null || !this.hasStringArg(method)) continue;
            arrayList.add(propertyDescriptorArray[i2].getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

