/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.engine.visitors;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.dyndns.fichtner.rsccheck.engine.AbstractRscBundleVisitor;
import org.dyndns.fichtner.rsccheck.engine.RscBundleContent;
import org.dyndns.fichtner.rsccheck.engine.RscBundleReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceholderVisitor
extends AbstractRscBundleVisitor {
    private final Map<String, Set<String>> placeHolderMap = new HashMap<String, Set<String>>();
    private String placeholderChars = "{}";
    private boolean createMessageFormatInstance = true;

    public static void main(String[] stringArray) {
        String string = MessageFormat.format("{0} est le premier RSSReader  compl\u00e8tement int\u00e8gr\u00e8 dans le desktop. veuillez visiter, pour d''autres informations <a>{1}</a>", "a", "b");
        System.out.println(string);
    }

    @Override
    public boolean visitBundleKeyValue(RscBundleReader rscBundleReader, RscBundleContent rscBundleContent, String string, RscBundleContent.Entry entry) {
        if (entry.getValue().length() != 0 && !this.checkPlaceHolder(rscBundleReader, string, entry)) {
            this.addError(this, "inconsistent placeholder for key " + string + " (expected " + this.getReferenz(string) + ", actual " + this.getActual(rscBundleReader, entry, string) + ")", rscBundleReader, entry);
        }
        return super.visitBundleKeyValue(rscBundleReader, rscBundleContent, string, entry);
    }

    private boolean checkPlaceHolder(RscBundleReader rscBundleReader, String string, RscBundleContent.Entry entry) {
        boolean bl = true;
        Set<String> set = this.getActual(rscBundleReader, entry, string);
        Set<String> set2 = this.getReferenz(string);
        if (set2 == null) {
            this.placeHolderMap.put(string, set);
        } else {
            bl = ((Object)set2).equals(set);
        }
        return bl;
    }

    private Set<String> getActual(RscBundleReader rscBundleReader, RscBundleContent.Entry entry, String string) {
        int n2;
        HashSet<String> hashSet = new HashSet<String>();
        StringBuilder[] stringBuilderArray = new StringBuilder[4];
        for (n2 = 0; n2 < stringBuilderArray.length; ++n2) {
            stringBuilderArray[n2] = new StringBuilder();
        }
        n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        String string2 = entry.getValue();
        block9: for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if (n2 == 0) {
                if (c2 == '\'') {
                    if (i2 + 1 < string2.length() && string2.charAt(i2 + 1) == '\'') {
                        stringBuilderArray[n2].append(c2);
                        ++i2;
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (c2 == '{' && !bl) {
                    n2 = 1;
                    continue;
                }
                stringBuilderArray[n2].append(c2);
                continue;
            }
            if (bl) {
                stringBuilderArray[n2].append(c2);
                if (c2 != '\'') continue;
                bl = false;
                continue;
            }
            switch (c2) {
                case ',': {
                    if (n2 < 3) {
                        ++n2;
                        continue block9;
                    }
                    stringBuilderArray[n2].append(c2);
                    continue block9;
                }
                case '{': {
                    ++n4;
                    stringBuilderArray[n2].append(c2);
                    continue block9;
                }
                case '}': {
                    if (n4 == 0) {
                        n2 = 0;
                        this.handleFormat(hashSet, stringBuilderArray);
                        ++n3;
                        continue block9;
                    }
                    --n4;
                    stringBuilderArray[n2].append(c2);
                    continue block9;
                }
                case '\'': {
                    bl = true;
                }
                default: {
                    stringBuilderArray[n2].append(c2);
                }
            }
        }
        if (n4 == 0 && n2 != 0) {
            this.addError(this, "Unmatched braces", rscBundleReader, entry);
        }
        if (this.createMessageFormatInstance) {
            try {
                new MessageFormat(entry.getValue());
            }
            catch (Exception exception) {
                this.addError(this, "Unable to create MessageFormat instance " + exception.getMessage(), rscBundleReader, entry);
            }
        }
        return hashSet;
    }

    private void handleFormat(Set<String> set, StringBuilder[] stringBuilderArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 1; i2 < stringBuilderArray.length; ++i2) {
            stringBuilder.append((CharSequence)stringBuilderArray[i2]);
        }
        set.add(stringBuilder.toString());
        stringBuilderArray[1].setLength(0);
        stringBuilderArray[2].setLength(0);
        stringBuilderArray[3].setLength(0);
    }

    private Set<String> getReferenz(String string) {
        return this.placeHolderMap.get(string);
    }

    public String getPlaceholderChars() {
        return this.placeholderChars;
    }

    public void setPlaceholderChars(String string) {
        this.placeholderChars = string;
        if (this.placeholderChars == null || this.placeholderChars.length() == 0) {
            throw new BuildException("placeholder must not be null or empty");
        }
        if (this.placeholderChars.length() % 2 != 0) {
            throw new BuildException("content of " + this.placeholderChars + "must contain an EVEN count of characters (e.g. \"{}()\")");
        }
    }

    public void setCreateMessageFormatInstance(boolean bl) {
        this.createMessageFormatInstance = bl;
    }

    @Override
    public String getName() {
        return "placeholder check";
    }
}

