/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.engine.visitors;

import java.util.Map;
import java.util.Set;
import org.dyndns.fichtner.rsccheck.engine.AbstractRscBundleVisitor;
import org.dyndns.fichtner.rsccheck.engine.RscBundleContent;
import org.dyndns.fichtner.rsccheck.engine.RscBundleReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateKeyVisitor
extends AbstractRscBundleVisitor {
    private boolean checkForBloodySimilarKeys;

    @Override
    public boolean visitBundle(RscBundleReader rscBundleReader, RscBundleContent rscBundleContent) {
        if (this.checkForBloodySimilarKeys) {
            for (Map.Entry entry : rscBundleContent.entrySet()) {
                String string = (String)entry.getKey();
                if (!this.definedBloddySimilar(rscBundleContent.keySet(), string)) continue;
                this.addError(this, "key " + string + " defined more than once (already declared as " + string + ")", rscBundleReader, (RscBundleContent.Entry)entry.getValue());
            }
        } else {
            for (Map.Entry entry : rscBundleContent.entrySet()) {
                RscBundleContent.Entry entry2 = (RscBundleContent.Entry)entry.getValue();
                if (entry2.getChainedEntry() == null) continue;
                this.addError(this, "key " + (String)entry.getKey() + " defined more than once (" + entry2.getChainedEntry() + ")", rscBundleReader, entry2);
            }
        }
        return super.visitBundle(rscBundleReader, rscBundleContent);
    }

    private boolean definedBloddySimilar(Set<String> set, String string) {
        for (String string2 : set) {
            if (string.equals(string2) || !string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckForBloodySimilarKeys() {
        return this.checkForBloodySimilarKeys;
    }

    public void setCheckForBloodySimilarKeys(boolean bl) {
        this.checkForBloodySimilarKeys = bl;
    }

    @Override
    public String getName() {
        return "duplicate key check";
    }
}

