/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.engine.visitors;

import org.dyndns.fichtner.rsccheck.engine.AbstractRscBundleVisitor;
import org.dyndns.fichtner.rsccheck.engine.RscBundleContent;
import org.dyndns.fichtner.rsccheck.engine.RscBundleReader;

public class CheckUnicodesVisitor
extends AbstractRscBundleVisitor {
    private String allowedChars;

    public boolean visitBundleKeyValue(RscBundleReader rscBundleReader, RscBundleContent rscBundleContent, String string, RscBundleContent.Entry entry) {
        char[] cArray = entry.getValue().toCharArray();
        for (int i2 = 0; i2 < cArray.length - 1; ++i2) {
            char c2 = cArray[i2];
            if (c2 != '\\' || cArray[i2 + 1] != 'u') continue;
            if (i2 + 6 > cArray.length) {
                this.addError(this, "Malformed unicode encoding <" + new String(cArray, i2, Math.min(6, cArray.length - i2)) + ">", rscBundleReader, entry);
                continue;
            }
            int n2 = this.translateUnicode(cArray, i2 + 2);
            if (n2 == -1) {
                this.addError(this, "Malformed unicode encoding <" + new String(cArray, i2, Math.min(6, cArray.length - i2)) + ">", rscBundleReader, entry);
            }
            String string2 = String.valueOf((char)n2);
            if (this.allowedChars == null || this.allowedChars.indexOf(string2) >= 0) continue;
            this.addError(this, "Unicode " + new String(cArray, i2, Math.min(6, cArray.length - i2)) + " (" + string2 + ") not allowed", rscBundleReader, entry);
        }
        return super.visitBundleKeyValue(rscBundleReader, rscBundleContent, string, entry);
    }

    private int translateUnicode(char[] cArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            char c2 = cArray[n2 + i2];
            if ("0123456789".indexOf(c2) >= 0) {
                n3 = (n3 << 4) + c2 - 48;
                continue;
            }
            if ("abcdefABCDEF".indexOf(c2) >= 0) {
                n3 = (n3 << 4) + 10 + Character.toLowerCase(c2) - 97;
                continue;
            }
            return -1;
        }
        return n3;
    }

    public void setAllowedChars(String string) {
        this.allowedChars = string;
    }

    public String getName() {
        return "unicode check";
    }
}

