/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.dyndns.fichtner.rsccheck.engine.Visitor;
import org.dyndns.fichtner.rsccheck.engine.VisitorFactory;
import org.dyndns.fichtner.rsccheck.engine.visitors.AllowedCharKeyVisitor;
import org.dyndns.fichtner.rsccheck.engine.visitors.CheckUnicodesVisitor;
import org.dyndns.fichtner.rsccheck.engine.visitors.CrossBundleCheckVisitor;
import org.dyndns.fichtner.rsccheck.engine.visitors.DuplicateKeyVisitor;
import org.dyndns.fichtner.rsccheck.engine.visitors.EmptyKeyVisitor;
import org.dyndns.fichtner.rsccheck.engine.visitors.EmptyValueVisitor;
import org.dyndns.fichtner.rsccheck.engine.visitors.InvalidCharInValueVistor;
import org.dyndns.fichtner.rsccheck.engine.visitors.KeyRegexpVisitor;
import org.dyndns.fichtner.rsccheck.engine.visitors.LineEndWithVisitor;
import org.dyndns.fichtner.rsccheck.engine.visitors.PlaceholderVisitor;
import org.dyndns.fichtner.rsccheck.engine.visitors.UnusedKeyVisitor;
import org.dyndns.fichtner.rsccheck.engine.visitors.UpperLowerVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticVisitorFactory
implements VisitorFactory {
    private static final Map<String, Visitor> ALL = StaticVisitorFactory.createMap();

    @Override
    public Object getByName(String string) {
        return ALL.get(string);
    }

    private static Map<String, Visitor> createMap() {
        HashMap<String, Visitor> hashMap = new HashMap<String, Visitor>();
        StaticVisitorFactory.mapAdd(hashMap, new AllowedCharKeyVisitor());
        StaticVisitorFactory.mapAdd(hashMap, new CheckUnicodesVisitor());
        StaticVisitorFactory.mapAdd(hashMap, new CrossBundleCheckVisitor());
        StaticVisitorFactory.mapAdd(hashMap, new DuplicateKeyVisitor());
        StaticVisitorFactory.mapAdd(hashMap, new EmptyValueVisitor());
        StaticVisitorFactory.mapAdd(hashMap, new EmptyKeyVisitor());
        StaticVisitorFactory.mapAdd(hashMap, new InvalidCharInValueVistor());
        StaticVisitorFactory.mapAdd(hashMap, new KeyRegexpVisitor());
        StaticVisitorFactory.mapAdd(hashMap, new LineEndWithVisitor());
        StaticVisitorFactory.mapAdd(hashMap, new PlaceholderVisitor());
        StaticVisitorFactory.mapAdd(hashMap, new UpperLowerVisitor());
        StaticVisitorFactory.mapAdd(hashMap, new UnusedKeyVisitor());
        return hashMap;
    }

    private static Object mapAdd(Map<String, Visitor> map, Visitor visitor) {
        return map.put(visitor.getName(), visitor);
    }

    @Override
    public Collection<Visitor> getVisitors() {
        return ALL.values();
    }

    @Override
    public Collection<Visitor> getDefaultVisitors() {
        ArrayList<Visitor> arrayList = new ArrayList<Visitor>();
        for (Visitor visitor : this.getVisitorsWithoutConfig()) {
            if (visitor.getClass() == UpperLowerVisitor.class) continue;
            arrayList.add(visitor);
        }
        return arrayList;
    }

    @Override
    public Collection<Visitor> getVisitorsWithoutConfig() {
        ArrayList<Visitor> arrayList = new ArrayList<Visitor>(ALL.size());
        for (Visitor visitor : ALL.values()) {
            if (!visitor.runnableWithoutConfig()) continue;
            arrayList.add(visitor);
        }
        return arrayList;
    }
}

