/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.ant.types;

import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.dyndns.fichtner.rsccheck.ant.Context;
import org.dyndns.fichtner.rsccheck.ant.types.Check;
import org.dyndns.fichtner.rsccheck.ant.types.CheckArgument;
import org.dyndns.fichtner.rsccheck.ant.types.CheckArguments;
import org.dyndns.fichtner.rsccheck.engine.Visitor;
import org.dyndns.fichtner.rsccheck.engine.VisitorFactory;
import org.dyndns.fichtner.rsccheck.util.BeanInfoAttributeSetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckHolder {
    private final Mode mode;
    private final Check check;

    public CheckHolder(Mode mode, Check check) {
        this.mode = mode;
        this.check = check;
    }

    public boolean isInclude() {
        return this.mode == Mode.INCLUDE;
    }

    public boolean isExclude() {
        return this.mode == Mode.EXCLUDE;
    }

    public Check getCheck() {
        return this.check;
    }

    public String toString() {
        return this.getClass().getName() + " " + (Object)((Object)this.mode) + " " + this.check;
    }

    public void getVisitors(List<Visitor> list) {
        VisitorFactory visitorFactory = Context.getVisitorFactory();
        boolean bl = this.check.isAllPlacegolder();
        if (bl) {
            for (Visitor visitor : visitorFactory.getDefaultVisitors()) {
                this.handle(list, visitor);
            }
        } else {
            String string = this.check.getName().getName();
            Visitor visitor = (Visitor)visitorFactory.getByName(string);
            if (visitor == null) {
                throw new BuildException("Unknown visitor " + string + " (available " + Arrays.toString(new Check.CheckName().getValues()) + ")");
            }
            this.handle(list, visitor);
        }
    }

    private void handle(List<Visitor> list, Visitor visitor) {
        if (this.isExclude()) {
            this.handleRemove(list, visitor);
        } else {
            this.handleAdd(list, visitor);
        }
    }

    private void handleRemove(List<Visitor> list, Visitor visitor) {
        list.remove(visitor);
    }

    private void handleAdd(List<Visitor> list, Visitor visitor) {
        if (this.check.getArguments().isEmpty() && !visitor.runnableWithoutConfig()) {
            throw new BuildException((Object)((Object)this.check.getName()) + " cannot be run unconfigured");
        }
        this.configureVisitor(visitor, this.check);
        list.add(visitor);
    }

    private void configureVisitor(Visitor visitor, Check check) {
        BeanInfoAttributeSetter beanInfoAttributeSetter = new BeanInfoAttributeSetter();
        for (CheckArguments checkArguments : check.getArguments()) {
            for (CheckArgument checkArgument : checkArguments.getAll()) {
                beanInfoAttributeSetter.setAttribute(visitor, checkArgument.getName(), checkArgument.getValue());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        INCLUDE,
        EXCLUDE;

    }
}

