/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.fichtner.rsccheck.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.dyndns.fichtner.rsccheck.ant.types.Check;
import org.dyndns.fichtner.rsccheck.ant.types.CheckHolder;
import org.dyndns.fichtner.rsccheck.ant.types.Checks;
import org.dyndns.fichtner.rsccheck.engine.Context;
import org.dyndns.fichtner.rsccheck.engine.ErrorEntry;
import org.dyndns.fichtner.rsccheck.engine.RscBundleCheck;
import org.dyndns.fichtner.rsccheck.engine.RscBundleReader;
import org.dyndns.fichtner.rsccheck.engine.RscBundleReaderFile;
import org.dyndns.fichtner.rsccheck.engine.StaticVisitorFactory;
import org.dyndns.fichtner.rsccheck.engine.Visitor;
import org.dyndns.fichtner.rsccheck.engine.VisitorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RscBundleCheckTask
extends Task {
    private boolean failOnError = true;
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private final List<Checks> checks = new ArrayList<Checks>();
    private boolean sortResult = true;
    private boolean verbose;

    private void error(String string) {
        if (this.failOnError) {
            throw new BuildException(string);
        }
        this.log(string, 1);
    }

    public void execute() throws BuildException {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        if (this.filesets.isEmpty()) {
            throw new BuildException("Specify at least one resourcebundle");
        }
        Context context = new Context();
        List<RscBundleReader> list = this.createReaders();
        if (list.isEmpty()) {
            throw new BuildException("No resourcebundle does match the pattern");
        }
        context.rscBundleReaders = list;
        context.visitors = this.createVisitors();
        this.log("Enabled checks: " + context.visitors, 2);
        RscBundleCheck rscBundleCheck = new RscBundleCheck(context);
        try {
            List<ErrorEntry> list2 = this.sort(rscBundleCheck.execute());
            for (ErrorEntry errorEntry : list2) {
                this.log(errorEntry.toString(), 0);
            }
            for (ErrorEntry errorEntry : list2) {
                this.error(errorEntry.toString());
            }
        }
        catch (Exception exception) {
            this.error(exception.getMessage());
        }
    }

    private List<ErrorEntry> sort(List<ErrorEntry> list) {
        if (!this.sortResult) {
            return list;
        }
        ArrayList<ErrorEntry> arrayList = new ArrayList<ErrorEntry>(list);
        Collections.sort(arrayList, new Comparator<ErrorEntry>(){

            @Override
            public int compare(ErrorEntry errorEntry, ErrorEntry errorEntry2) {
                return errorEntry.getEntry() == null ? (errorEntry2.getEntry() == null ? 0 : -1) : errorEntry.getEntry().getLineOfKey() - (errorEntry2.getEntry() == null ? 0 : errorEntry2.getEntry().getLineOfKey());
            }
        });
        return arrayList;
    }

    private List<RscBundleReader> createReaders() {
        ArrayList<RscBundleReader> arrayList = new ArrayList<RscBundleReader>();
        for (int i2 = 0; i2 < this.filesets.size(); ++i2) {
            FileSet fileSet = this.filesets.get(i2);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            File file = fileSet.getDir(this.getProject());
            for (String string : directoryScanner.getIncludedFiles()) {
                File file2 = new File(file, string);
                this.log("Including " + file2, 2);
                arrayList.add(this.createBundleReader(file2));
            }
        }
        return arrayList;
    }

    private Collection<Visitor> createVisitors() {
        Object object;
        StaticVisitorFactory staticVisitorFactory = new StaticVisitorFactory();
        if (this.checks.isEmpty()) {
            object = new Checks();
            for (Visitor object2 : staticVisitorFactory.getDefaultVisitors()) {
                Check check = new Check();
                check.setName(new Check.CheckName(object2.getName()));
                ((Checks)object).addInclude(check);
            }
            this.checks.add((Checks)object);
        }
        object = new ArrayList();
        for (Checks checks : this.checks) {
            object.addAll(this.extractVisitorsFromSet(checks, staticVisitorFactory));
        }
        return object;
    }

    private Collection<Visitor> extractVisitorsFromSet(Checks checks, VisitorFactory visitorFactory) {
        ArrayList<Visitor> arrayList = new ArrayList<Visitor>();
        for (CheckHolder checkHolder : checks.getData()) {
            checkHolder.getVisitors(arrayList);
        }
        return arrayList;
    }

    private RscBundleReaderFile createBundleReader(File file) {
        try {
            return new RscBundleReaderFile(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException((Throwable)fileNotFoundException);
        }
    }

    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void addChecks(Checks checks) {
        this.checks.add(checks);
    }

    public void setSortResult(boolean bl) {
        this.sortResult = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }
}

