/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.rules.Handle;
import javax.rules.InvalidHandleException;
import javax.rules.InvalidRuleSessionException;
import javax.rules.ObjectFilter;
import javax.rules.RuleExecutionSetNotFoundException;
import javax.rules.StatefulRuleSession;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.NoSuchFactObjectException;
import org.drools.jsr94.rules.AbstractRuleSessionImpl;
import org.drools.jsr94.rules.admin.RuleExecutionSetImpl;
import org.drools.jsr94.rules.admin.RuleExecutionSetRepository;

public class StatefulRuleSessionImpl
extends AbstractRuleSessionImpl
implements StatefulRuleSession {
    private static final long serialVersionUID = 1L;

    StatefulRuleSessionImpl(String string, Map map, RuleExecutionSetRepository ruleExecutionSetRepository) throws RuleExecutionSetNotFoundException {
        super(ruleExecutionSetRepository);
        this.setProperties(map);
        RuleExecutionSetImpl ruleExecutionSetImpl = (RuleExecutionSetImpl)ruleExecutionSetRepository.getRuleExecutionSet(string);
        if (ruleExecutionSetImpl == null) {
            throw new RuleExecutionSetNotFoundException("no execution set bound to: " + string);
        }
        this.setRuleExecutionSet(ruleExecutionSetImpl);
        this.initWorkingMemory();
    }

    public boolean containsObject(Handle handle) {
        if (handle instanceof FactHandle) {
            return this.getWorkingMemory().getObject((FactHandle)handle) != null;
        }
        return false;
    }

    public Handle addObject(Object object) throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        try {
            return (Handle)this.getWorkingMemory().assertObject(object);
        }
        catch (FactException factException) {
            throw new InvalidRuleSessionException("cannot assert object", (Exception)((Object)factException));
        }
    }

    public List addObjects(List list) throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        ArrayList<Handle> arrayList = new ArrayList<Handle>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.addObject(iterator.next()));
        }
        return arrayList;
    }

    public void updateObject(Handle handle, Object object) throws InvalidRuleSessionException, InvalidHandleException {
        this.checkRuleSessionValidity();
        if (handle instanceof FactHandle) {
            try {
                this.getWorkingMemory().modifyObject((FactHandle)handle, object);
            }
            catch (FactException factException) {
                throw new InvalidRuleSessionException("cannot update object", (Exception)((Object)factException));
            }
        } else {
            throw new InvalidHandleException("invalid handle");
        }
    }

    public void removeObject(Handle handle) throws InvalidRuleSessionException, InvalidHandleException {
        this.checkRuleSessionValidity();
        if (handle instanceof FactHandle) {
            try {
                this.getWorkingMemory().retractObject((FactHandle)handle);
            }
            catch (FactException factException) {
                throw new InvalidRuleSessionException("cannot remove object", (Exception)((Object)factException));
            }
        } else {
            throw new InvalidHandleException("invalid handle");
        }
    }

    public List getObjects() throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        return this.getObjects(this.getRuleExecutionSet().getObjectFilter());
    }

    public List getObjects(ObjectFilter objectFilter) throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getWorkingMemory().getObjects());
        this.applyFilter(arrayList, objectFilter);
        return arrayList;
    }

    public void executeRules() throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        this.getWorkingMemory().fireAllRules();
    }

    public Object getObject(Handle handle) throws InvalidRuleSessionException, InvalidHandleException {
        this.checkRuleSessionValidity();
        if (handle instanceof FactHandle) {
            try {
                return this.getWorkingMemory().getObject((FactHandle)handle);
            }
            catch (NoSuchFactObjectException noSuchFactObjectException) {
                throw new InvalidHandleException("invalid handle", (Exception)((Object)noSuchFactObjectException));
            }
        }
        throw new InvalidHandleException("invalid handle");
    }

    public List getHandles() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.getWorkingMemory().getFactHandles().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Handle)) continue;
            linkedList.add(e);
        }
        return linkedList;
    }
}

