/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import thredds.catalog.query.Station;
import ucar.nc2.dt.StationRadarCollection;
import ucar.nc2.dt.TypedDatasetImpl;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.Product;

public abstract class StationRadarCollectionImpl
extends TypedDatasetImpl
implements StationRadarCollection {
    private StationRadarCollection radarCollection;
    protected HashMap stations;
    protected HashMap relTimesList;
    protected HashMap absTimesList;
    protected DateUnit timeUnit;
    private LatLonRect rect;

    public StationRadarCollectionImpl() {
    }

    public StationRadarCollectionImpl(StationRadarCollection radarDataset) {
        this.radarCollection = radarDataset;
    }

    public LatLonRect getBoundingBox() {
        if (this.rect == null) {
            List stations = null;
            try {
                stations = this.radarCollection.getStations();
            }
            catch (IOException e) {
                return null;
            }
            if (stations.size() == 0) {
                return null;
            }
            Station s = (Station)stations.get(0);
            LatLonPointImpl llpt = new LatLonPointImpl();
            llpt.set(s.getLocation().getLatitude(), s.getLocation().getLongitude());
            this.rect = new LatLonRect(llpt, 0.001, 0.001);
            for (int i = 1; i < stations.size(); ++i) {
                s = (Station)stations.get(i);
                llpt.set(s.getLocation().getLatitude(), s.getLocation().getLongitude());
                this.rect.extend(llpt);
            }
        }
        return this.rect;
    }

    public List getStations(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        LatLonPointImpl latlonPt = new LatLonPointImpl();
        ArrayList<Station> result = new ArrayList<Station>();
        List stationC = this.radarCollection.getStations();
        for (int i = 0; i < stationC.size(); ++i) {
            Station s = (Station)stationC.get(i);
            latlonPt.set(s.getLocation().getLatitude(), s.getLocation().getLongitude());
            if (boundingBox.contains(latlonPt)) {
                result.add(s);
            }
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return result;
    }

    public boolean checkStationProduct(String stationName, Product product) {
        return false;
    }

    public Station getStation(String name) throws IOException {
        if (this.stations == null) {
            List stationC = null;
            try {
                stationC = this.radarCollection.getStations();
            }
            catch (IOException e) {
                return null;
            }
            this.stations = new HashMap(2 * this.stations.size());
            for (int i = 0; i < stationC.size(); ++i) {
                Station s = (Station)stationC.get(i);
                this.stations.put(s.getName(), s);
            }
        }
        return (Station)this.stations.get(name);
    }

    public List getStations() throws IOException {
        return this.radarCollection.getStations();
    }

    public List getStations(CancelTask cancel) throws IOException {
        if (cancel != null && cancel.isCancel()) {
            return null;
        }
        return this.getStations();
    }

    public List getStations(LatLonRect boundingBox) throws IOException {
        LatLonPointImpl latlonPt = new LatLonPointImpl();
        ArrayList<Station> result = new ArrayList<Station>();
        List stationC = this.radarCollection.getStations();
        for (int i = 0; i < stationC.size(); ++i) {
            Station s = (Station)stationC.get(i);
            latlonPt.set(s.getLocation().getLatitude(), s.getLocation().getLongitude());
            if (!boundingBox.contains(latlonPt)) continue;
            result.add(s);
        }
        return result;
    }
}

