/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import java.util.StringTokenizer;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.vertical.OceanS;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;

public class VOceanS
extends AbstractCoordTransBuilder {
    private String s = "";
    private String eta = "";
    private String depth = "";
    private String a = "";
    private String b = "";
    private String depth_c = "";

    public String getTransformName() {
        return "ocean_s_coordinate";
    }

    public TransformType getTransformType() {
        return TransformType.Vertical;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        String formula_terms = this.getFormula(ds, ctv);
        if (null == formula_terms) {
            return null;
        }
        StringTokenizer stoke = new StringTokenizer(formula_terms);
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (toke.equalsIgnoreCase("s:")) {
                this.s = stoke.nextToken();
                continue;
            }
            if (toke.equalsIgnoreCase("eta:")) {
                this.eta = stoke.nextToken();
                continue;
            }
            if (toke.equalsIgnoreCase("depth:")) {
                this.depth = stoke.nextToken();
                continue;
            }
            if (toke.equalsIgnoreCase("a:")) {
                this.a = stoke.nextToken();
                continue;
            }
            if (toke.equalsIgnoreCase("b:")) {
                this.b = stoke.nextToken();
                continue;
            }
            if (!toke.equalsIgnoreCase("depth_c:")) continue;
            this.depth_c = stoke.nextToken();
        }
        VerticalCT rs = new VerticalCT("OceanS_Transform_" + ctv.getName(), this.getTransformName(), VerticalCT.Type.OceanS, this);
        rs.addParameter(new Parameter("standard_name", this.getTransformName()));
        rs.addParameter(new Parameter("formula_terms", formula_terms));
        rs.addParameter(new Parameter("height_formula", "height(x,y,z) = eta(x,y)*(1+s(z)) + depth_c*s(z) + (depth(x,y)-depth_c)*C(z)"));
        rs.addParameter(new Parameter("C_formula", "C(z) = (1-b)*sinh(a*s(z))/sinh(a) + b*(tanh(a*(s(z)+0.5))/(2*tanh(0.5*a))-0.5)"));
        if (!this.addParameter(rs, "Eta_variableName", ds, this.eta)) {
            return null;
        }
        if (!this.addParameter(rs, "S_variableName", ds, this.s)) {
            return null;
        }
        if (!this.addParameter(rs, "Depth_variableName", ds, this.depth)) {
            return null;
        }
        if (!this.addParameter(rs, "Depth_c_variableName", ds, this.depth_c)) {
            return null;
        }
        if (!this.addParameter(rs, "A_variableName", ds, this.a)) {
            return null;
        }
        if (!this.addParameter(rs, "B_variableName", ds, this.b)) {
            return null;
        }
        return rs;
    }

    public String toString() {
        return "OceanS: s:" + this.s + " eta:" + this.eta + " depth:" + this.depth + " a:" + this.a + " b:" + this.b + " depth_c:" + this.depth_c;
    }

    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return new OceanS(ds, timeDim, vCT);
    }
}

