/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.util.DebugFlags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWriter {
    private static Logger log = LoggerFactory.getLogger(FileWriter.class);
    private static boolean debug = false;
    private static boolean debugWrite = false;
    private static boolean debugExtend;
    private static long maxSize;
    private NetcdfFileWriteable ncfile;
    private HashMap<String, Dimension> dimHash = new HashMap();
    private List<Variable> varList = new ArrayList<Variable>();
    private Structure recordVar = null;

    public static void setDebugFlags(DebugFlags debugFlags) {
        debug = debugFlags.isSet("ncfileWriter/debug");
        debugExtend = debugFlags.isSet("ncfileWriter/debugExtend");
    }

    public static NetcdfFile writeToFile(NetcdfFile fileIn, String fileOutName) throws IOException {
        return FileWriter.writeToFile(fileIn, fileOutName, false, 0);
    }

    public static NetcdfFile writeToFile(NetcdfFile fileIn, String fileOutName, boolean fill) throws IOException {
        return FileWriter.writeToFile(fileIn, fileOutName, fill, 0);
    }

    public static NetcdfFile writeToFile(NetcdfFile fileIn, String fileOutName, boolean fill, int delay) throws IOException {
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew(fileOutName, fill);
        if (debug) {
            System.out.println("FileWriter write " + fileIn.getLocation() + " to " + fileOutName);
            System.out.println("File In = " + fileIn);
        }
        List<Attribute> glist = fileIn.getGlobalAttributes();
        for (Attribute att : glist) {
            if (att.isArray()) {
                ncfile.addGlobalAttribute(att.getName(), att.getValues());
            } else if (att.isString()) {
                ncfile.addGlobalAttribute(att.getName(), att.getStringValue());
            } else {
                ncfile.addGlobalAttribute(att.getName(), att.getNumericValue());
            }
            if (!debug) continue;
            System.out.println("add gatt= " + att);
        }
        HashMap<String, Dimension> dimHash = new HashMap<String, Dimension>();
        for (Dimension oldD : fileIn.getDimensions()) {
            Dimension newD = ncfile.addDimension(oldD.getName(), oldD.isUnlimited() ? 0 : oldD.getLength(), oldD.isShared(), oldD.isUnlimited(), oldD.isVariableLength());
            dimHash.put(newD.getName(), newD);
            if (!debug) continue;
            System.out.println("add dim= " + newD);
        }
        List<Variable> varlist = fileIn.getVariables();
        for (Variable oldVar : varlist) {
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            List<Dimension> dimvList = oldVar.getDimensions();
            for (Dimension oldD : dimvList) {
                dims.add((Dimension)dimHash.get(oldD.getName()));
            }
            DataType newType = oldVar.getDataType();
            if (oldVar.getDataType() == DataType.STRING) {
                Array data = oldVar.read();
                IndexIterator ii = data.getIndexIterator();
                int max_len = 0;
                while (ii.hasNext()) {
                    String s = (String)ii.getObjectNext();
                    max_len = Math.max(max_len, s.length());
                }
                Dimension newD = ncfile.addDimension(oldVar.getName() + "_strlen", max_len);
                dims.add(newD);
                newType = DataType.CHAR;
            }
            ncfile.addVariable(oldVar.getName(), newType, dims);
            if (debug) {
                System.out.println("add var= " + oldVar.getName());
            }
            List<Attribute> attList = oldVar.getAttributes();
            for (Attribute att : attList) {
                if (att.isArray()) {
                    ncfile.addVariableAttribute(oldVar.getName(), att.getName(), att.getValues());
                    continue;
                }
                if (att.isString()) {
                    ncfile.addVariableAttribute(oldVar.getName(), att.getName(), att.getStringValue());
                    continue;
                }
                ncfile.addVariableAttribute(oldVar.getName(), att.getName(), att.getNumericValue());
            }
        }
        ncfile.create();
        if (debug) {
            System.out.println("File Out= " + ncfile.toString());
        }
        if (fileIn.hasUnlimitedDimension()) {
            fileIn.sendIospMessage("AddRecordStructure");
            ncfile.sendIospMessage("AddRecordStructure");
        }
        boolean useRecordDimension = FileWriter.hasRecordStructure(fileIn) && FileWriter.hasRecordStructure(ncfile);
        Structure recordVar = useRecordDimension ? (Structure)fileIn.findVariable("record") : null;
        double total = FileWriter.copyVarData(ncfile, varlist, recordVar, delay);
        ncfile.flush();
        if (debug) {
            System.out.println("FileWriter done total bytes = " + total);
        }
        fileIn.sendIospMessage("RemoveRecordStructure");
        return ncfile;
    }

    private static boolean hasRecordStructure(NetcdfFile file2) {
        Variable v = file2.findVariable("record");
        return v != null && v.getDataType() == DataType.STRUCTURE;
    }

    private static double copyVarData(NetcdfFileWriteable ncfile, List<Variable> varlist, Structure recordVar, long delay) throws IOException {
        boolean useRecordDimension = recordVar != null;
        double total = 0.0;
        for (Variable oldVar : varlist) {
            if (useRecordDimension && oldVar.isUnlimited() || oldVar == recordVar) continue;
            if (debug) {
                System.out.println("write var= " + oldVar.getName() + " size = " + oldVar.getSize() + " type=" + oldVar.getDataType());
            }
            long size = oldVar.getSize() * (long)oldVar.getElementSize();
            total += (double)size;
            int nelems = (int)(size / maxSize);
            if (nelems <= 1) {
                FileWriter.copyAll(ncfile, oldVar);
                continue;
            }
            FileWriter.copySome(ncfile, oldVar, nelems);
        }
        if (useRecordDimension) {
            int[] origin = new int[]{0};
            int[] size = new int[]{1};
            int nrecs = (int)recordVar.getSize();
            int sdataSize = recordVar.getElementSize();
            double totalRecordBytes = 0.0;
            for (int count = 0; count < nrecs; ++count) {
                block10: {
                    origin[0] = count;
                    try {
                        Array recordData = recordVar.read(origin, size);
                        ncfile.write("record", origin, recordData);
                        if (!debug || count != 0) break block10;
                        System.out.println("write record size = " + sdataSize);
                    }
                    catch (InvalidRangeException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                totalRecordBytes += (double)sdataSize;
                if (delay <= 0L) continue;
                ncfile.flush();
                try {
                    Thread.sleep(delay);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            total += totalRecordBytes;
            totalRecordBytes /= 1000000.0;
            if (debug) {
                System.out.println("write record var; total = " + totalRecordBytes + " Mbytes # recs=" + nrecs);
            }
        }
        return total;
    }

    private static void copyAll(NetcdfFileWriteable ncfile, Variable oldVar) throws IOException {
        Array data = oldVar.read();
        try {
            if (oldVar.getDataType() == DataType.STRING) {
                data = FileWriter.convertToChar(ncfile.findVariable(oldVar.getName()), data);
            }
            if (data.getSize() > 0L) {
                ncfile.write(oldVar.getName(), data);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage() + " for Variable " + oldVar.getName());
        }
    }

    private static void copySome(NetcdfFileWriteable ncfile, Variable oldVar, int nelems) throws IOException {
        int[] shape = oldVar.getShape();
        int[] origin = new int[oldVar.getRank()];
        int size = shape[0];
        for (int i = 0; i < size; i += nelems) {
            origin[0] = i;
            int left = size - i;
            shape[0] = Math.min(nelems, left);
            try {
                Array data = oldVar.read(origin, shape);
                if (oldVar.getDataType() == DataType.STRING) {
                    data = FileWriter.convertToChar(ncfile.findVariable(oldVar.getName()), data);
                }
                if (data.getSize() <= 0L) continue;
                ncfile.write(oldVar.getName(), origin, data);
                if (!debugWrite) continue;
                System.out.println("write " + data.getSize() + " bytes");
                continue;
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
    }

    private static Array convertToChar(Variable newVar, Array oldData) {
        ArrayChar newData = (ArrayChar)Array.factory(DataType.CHAR, newVar.shape);
        Index ima = newData.getIndex();
        IndexIterator ii = oldData.getIndexIterator();
        while (ii.hasNext()) {
            String s = (String)ii.getObjectNext();
            int[] c = ii.getCurrentCounter();
            for (int i = 0; i < c.length; ++i) {
                ima.setDim(i, c[i]);
            }
            newData.setString(ima, s);
        }
        return newData;
    }

    public FileWriter(String fileOutName, boolean fill) {
        this.ncfile = NetcdfFileWriteable.createNew(fileOutName, fill);
    }

    public NetcdfFileWriteable getNetcdf() {
        return this.ncfile;
    }

    public void writeGlobalAttribute(Attribute att) {
        if (att.isArray()) {
            this.ncfile.addGlobalAttribute(att.getName(), att.getValues());
        } else if (att.isString()) {
            this.ncfile.addGlobalAttribute(att.getName(), att.getStringValue());
        } else {
            this.ncfile.addGlobalAttribute(att.getName(), att.getNumericValue());
        }
    }

    public void writeAttribute(String varName, Attribute att) {
        if (att.isArray()) {
            this.ncfile.addVariableAttribute(varName, att.getName(), att.getValues());
        } else if (att.isString()) {
            this.ncfile.addVariableAttribute(varName, att.getName(), att.getStringValue());
        } else {
            this.ncfile.addVariableAttribute(varName, att.getName(), att.getNumericValue());
        }
    }

    public Dimension writeDimension(Dimension dim) {
        Dimension newDim = this.ncfile.addDimension(dim.getName(), dim.isUnlimited() ? 0 : dim.getLength(), dim.isShared(), dim.isUnlimited(), dim.isVariableLength());
        this.dimHash.put(newDim.getName(), newDim);
        if (debug) {
            System.out.println("write dim= " + newDim);
        }
        return newDim;
    }

    public void writeVariable(Variable oldVar) {
        Dimension[] dims = new Dimension[oldVar.getRank()];
        List<Dimension> dimvList = oldVar.getDimensions();
        for (int j = 0; j < dimvList.size(); ++j) {
            Dimension oldD = dimvList.get(j);
            Dimension newD = this.dimHash.get(oldD.getName());
            if (null == newD) {
                newD = this.writeDimension(oldD);
                this.dimHash.put(newD.getName(), newD);
            }
            dims[j] = newD;
        }
        if (oldVar.getDataType() == DataType.STRING) {
            try {
                int max_strlen = 0;
                ArrayObject data = (ArrayObject)oldVar.read();
                IndexIterator ii = data.getIndexIterator();
                while (ii.hasNext()) {
                    String s = (String)ii.next();
                    max_strlen = Math.max(max_strlen, s.length());
                }
                this.ncfile.addStringVariable(oldVar.getName(), Arrays.asList(dims), max_strlen);
            }
            catch (IOException ioe) {
                log.error("Error reading String variable " + oldVar, (Throwable)ioe);
                return;
            }
        } else {
            this.ncfile.addVariable(oldVar.getName(), oldVar.getDataType(), dims);
        }
        this.varList.add(oldVar);
        if (debug) {
            System.out.println("write var= " + oldVar);
        }
        List<Attribute> attList = oldVar.getAttributes();
        for (Attribute anAttList : attList) {
            this.writeAttribute(oldVar.getName(), anAttList);
        }
    }

    public void writeVariables(List<Variable> varList) {
        for (Variable v : varList) {
            this.writeVariable(v);
        }
    }

    public void setRecordVariable(Structure recordVar) {
        this.recordVar = recordVar;
    }

    public void finish() throws IOException {
        this.ncfile.create();
        double total = FileWriter.copyVarData(this.ncfile, this.varList, this.recordVar, 0L);
        this.ncfile.close();
        if (debug) {
            System.out.println("FileWriter finish total bytes = " + total);
        }
    }

    private static void usage() {
        System.out.println("usage: ucar.nc2.FileWriter -in <fileIn> -out <fileOut> [-delay <millisecs>]");
    }

    public static void main(String[] arg) throws IOException {
        if (arg.length < 4) {
            FileWriter.usage();
            System.exit(0);
        }
        String datasetIn = null;
        String datasetOut = null;
        int delay = 0;
        for (int i = 0; i < arg.length; ++i) {
            String s = arg[i];
            if (s.equalsIgnoreCase("-in")) {
                datasetIn = arg[i + 1];
            }
            if (s.equalsIgnoreCase("-out")) {
                datasetOut = arg[i + 1];
            }
            if (!s.equalsIgnoreCase("-delay")) continue;
            delay = Integer.parseInt(arg[i + 1]);
        }
        if (datasetIn == null || datasetOut == null) {
            FileWriter.usage();
            System.exit(0);
        }
        debugExtend = true;
        NetcdfFile ncfileIn = NetcdfFile.open(datasetIn, null);
        NetcdfFile ncfileOut = FileWriter.writeToFile(ncfileIn, datasetOut, false, delay);
        ncfileIn.close();
        ncfileOut.close();
        System.out.println("NetcdfFile written = " + ncfileOut);
    }

    static {
        maxSize = 1000000L;
    }
}

