/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.DataType;
import ucar.ma2.Index;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureMembers {
    protected String name;
    protected Map<String, Member> memberHash = new HashMap<String, Member>();
    protected List<Member> members = new ArrayList<Member>();
    protected int structureSize = -1;

    public StructureMembers(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addMember(Member m) {
        this.memberHash.put(m.getName(), m);
        this.members.add(m);
    }

    public Member addMember(String name, String desc, String units, DataType dtype, int[] shape) {
        Member m = new Member(name, desc, units, dtype, shape);
        this.addMember(m);
        return m;
    }

    public int getStructureSize() {
        if (this.structureSize < 0) {
            this.calcStructureSize();
        }
        return this.structureSize;
    }

    public void calcStructureSize() {
        this.structureSize = 0;
        for (Member member : this.members) {
            this.structureSize += member.getTotalSize();
        }
    }

    public void setStructureSize(int structureSize) {
        this.structureSize = structureSize;
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public List<String> getMemberNames() {
        ArrayList<String> memberNames = new ArrayList<String>();
        for (Member m : this.members) {
            memberNames.add(m.getName());
        }
        return memberNames;
    }

    public Member getMember(int index) {
        return this.members.get(index);
    }

    public Member findMember(String memberName) {
        if (memberName == null) {
            return null;
        }
        return this.memberHash.get(memberName);
    }

    public static class Member {
        private String name;
        private String desc;
        private String units;
        private DataType dtype;
        private int size = 1;
        private int[] shape;
        private StructureMembers members;
        private Object dataObject;
        private Object dataObject2;
        private int dataParam;

        public Member(String name, String desc, String units, DataType dtype, int[] shape) {
            this.name = name;
            this.desc = desc;
            this.units = units;
            this.dtype = dtype;
            this.shape = shape;
            this.size = (int)Index.computeSize(shape);
        }

        public void setStructureMembers(StructureMembers members) {
            this.members = members;
        }

        public StructureMembers getStructureMembers() {
            return this.members;
        }

        public void setShape(int[] shape) {
            this.shape = shape;
            this.size = (int)Index.computeSize(shape);
        }

        public String getName() {
            return this.name;
        }

        public String getUnitsString() {
            return this.units;
        }

        public String getDescription() {
            return this.desc;
        }

        public DataType getDataType() {
            return this.dtype;
        }

        public int[] getShape() {
            return this.shape;
        }

        public int getSize() {
            return this.size;
        }

        public int getTotalSize() {
            return this.size * this.getDataType().getSize();
        }

        public boolean isScalar() {
            return this.size == 1;
        }

        public int getDataParam() {
            return this.dataParam;
        }

        public void setDataParam(int dataParam) {
            this.dataParam = dataParam;
        }

        public Object getDataObject() {
            return this.dataObject;
        }

        public void setDataObject(Object o) {
            this.dataObject = o;
        }

        public Object getDataObject2() {
            return this.dataObject2;
        }

        public void setDataObject2(Object o) {
            this.dataObject2 = o;
        }
    }
}

