/*
 * Decompiled with CFR 0.152.
 */
package thredds.dqc;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.dqc.Description;
import thredds.dqc.QueryAction;
import thredds.dqc.SelectFromRange;

public class Dqc {
    private static Logger log = LoggerFactory.getLogger(Dqc.class);
    protected String name = null;
    protected Namespace ns = null;
    protected String version = null;
    protected QueryAction query;
    protected List selectors = new ArrayList();
    private static String rootElementName = "queryCapability";
    private static String version_0_3 = "0.3";
    private static String rootElementNamespaceURI_0_3 = "http://www.unidata.ucar.edu/schemas/thredds/queryCapability.0.3.xsd";

    protected Dqc() {
    }

    public static Dqc createDqcForJplQuikSCAT() throws Exception {
        Dqc dqc = new Dqc();
        dqc.name = "NASA JPL QuikSCAT Global Level-2B Data";
        dqc.version = "0.3";
        dqc.ns = Namespace.getNamespace((String)rootElementNamespaceURI_0_3);
        dqc.query = new QueryAction("http://dods.jpl.nasa.gov/dqcServlet/quikscat", "template", "catalog");
        SelectFromRange sfr = new SelectFromRange();
        sfr.setTitle("Select Date Range");
        sfr.setMultiple(false);
        sfr.setRequired(false);
        sfr.setAllowedRange(0.0, 5.0);
        sfr.setUnits("seconds since 1999-01-01");
        sfr.setTemplate("min=(minDate)&max=(maxDate)");
        sfr.setModulo(false);
        dqc.selectors.add(sfr);
        sfr = new SelectFromRange();
        sfr.setTitle("Northerly Equatorial Crossing (longitude)");
        sfr.description = new Description("The longitude at which the satellite crosses the equator from the\nsouthern into the northern hemisphere.");
        sfr.setMultiple(true);
        sfr.setRequired(false);
        sfr.setAllowedRange(0.0, 360.0);
        sfr.setUnits("degree_east");
        sfr.setTemplate("minCross=(minCross)&maxCross=(maxCross)");
        sfr.setModulo(true);
        dqc.selectors.add(sfr);
        return dqc;
    }

    public static Dqc createInstance(InputStream xmlIs) throws Exception {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder(true);
            doc = builder.build(xmlIs);
        }
        catch (JDOMException e) {
            String tmp = "createInstance(): exception thrown while parsing XML document: " + e.getMessage();
            log.debug(tmp);
            throw new Exception(tmp);
        }
        Dqc dqc = new Dqc();
        Element root = doc.getRootElement();
        if (!root.getName().equals(rootElementName)) {
            String tmp = "createInstance(): name of root element <" + root.getName() + "> is not \"" + rootElementName + "\"";
            log.debug(tmp);
            throw new Exception(tmp);
        }
        dqc.version = root.getAttributeValue("version");
        dqc.ns = root.getNamespace();
        if (dqc.version.equals(version_0_3) && dqc.ns.getURI().equals(rootElementNamespaceURI_0_3)) {
            return Dqc.createInstance_0_3(dqc, root);
        }
        String tmp = "createInstance(): version of DQC document <" + dqc.version + "><" + dqc.ns.getURI() + "> is not supported.";
        log.debug(tmp);
        throw new Exception(tmp);
    }

    private static Dqc createInstance_0_3(Dqc dqc, Element root) throws Exception {
        Attribute tmpAtt = null;
        dqc.name = root.getAttributeValue("name");
        root.getChild("query", dqc.ns);
        dqc.query = new QueryAction(root.getAttributeValue("base"), root.getAttributeValue("construct"), root.getAttributeValue("returns"));
        List list = root.getChildren("selectFromRange", dqc.ns);
        for (int i = 0; i < list.size(); ++i) {
            Element selectFromRangeElement = (Element)list.get(i);
            SelectFromRange curSfr = new SelectFromRange();
            curSfr.setId(selectFromRangeElement.getAttributeValue("id"));
            curSfr.setTitle(selectFromRangeElement.getAttributeValue("title"));
            tmpAtt = selectFromRangeElement.getAttribute("required");
            if (tmpAtt != null) {
                curSfr.setRequired(tmpAtt.getBooleanValue());
            }
            if ((tmpAtt = selectFromRangeElement.getAttribute("multiple")) != null) {
                curSfr.setMultiple(tmpAtt.getBooleanValue());
            }
            curSfr.setAllowedRange(selectFromRangeElement.getAttribute("min").getDoubleValue(), selectFromRangeElement.getAttribute("max").getDoubleValue());
            curSfr.setUnits(selectFromRangeElement.getAttributeValue("units"));
            tmpAtt = selectFromRangeElement.getAttribute("modulo");
            if (tmpAtt != null) {
                curSfr.setModulo(tmpAtt.getBooleanValue());
            }
            curSfr.setTemplate(selectFromRangeElement.getAttributeValue("template"));
            dqc.selectors.add(curSfr);
        }
        return dqc;
    }
}

