/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Arc;
import ome.xml.model.Detector;
import ome.xml.model.Dichroic;
import ome.xml.model.Filament;
import ome.xml.model.Filter;
import ome.xml.model.FilterSet;
import ome.xml.model.Image;
import ome.xml.model.Laser;
import ome.xml.model.LightEmittingDiode;
import ome.xml.model.LightSource;
import ome.xml.model.Microscope;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Objective;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instrument
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Instrument.class);
    private String id;
    private Microscope microscope;
    private List<LightSource> lightSources = new ArrayList<LightSource>();
    private List<Detector> detectors = new ArrayList<Detector>();
    private List<Objective> objectives = new ArrayList<Objective>();
    private List<FilterSet> filterSets = new ArrayList<FilterSet>();
    private List<Filter> filters = new ArrayList<Filter>();
    private List<Dichroic> dichroics = new ArrayList<Dichroic>();
    private List<Image> images = new ArrayList<Image>();

    public Instrument() {
    }

    public Instrument(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Microscope_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Instrument".equals(tagName)) {
            LOGGER.debug("Expecting node name of Instrument got {}", (Object)tagName);
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Instrument missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if ((Microscope_nodeList = Instrument.getChildrenByTagName(element, "Microscope")).size() > 1) {
            throw new RuntimeException(String.format("Microscope node list size %d != 1", Microscope_nodeList.size()));
        }
        if (Microscope_nodeList.size() != 0) {
            this.setMicroscope(new Microscope(Microscope_nodeList.get(0), model));
        }
        List<Element> LightSource_nodeList = Instrument.getChildrenByTagName(element, "LightSource");
        for (Element LightSource_element : LightSource_nodeList) {
            List<Element> Laser_nodeList = Instrument.getChildrenByTagName(LightSource_element, "Laser");
            for (Element Laser_element : Laser_nodeList) {
                Laser o = new Laser(LightSource_element, model);
                o.update(Laser_element, model);
                this.addLightSource(o);
            }
            List<Element> Filament_nodeList = Instrument.getChildrenByTagName(LightSource_element, "Filament");
            for (Element Filament_element : Filament_nodeList) {
                Filament o = new Filament(LightSource_element, model);
                o.update(Filament_element, model);
                this.addLightSource(o);
            }
            List<Element> Arc_nodeList = Instrument.getChildrenByTagName(LightSource_element, "Arc");
            for (Element Arc_element : Arc_nodeList) {
                Arc o = new Arc(LightSource_element, model);
                o.update(Arc_element, model);
                this.addLightSource(o);
            }
            List<Element> LightEmittingDiode_nodeList = Instrument.getChildrenByTagName(LightSource_element, "LightEmittingDiode");
            for (Element LightEmittingDiode_element : LightEmittingDiode_nodeList) {
                LightEmittingDiode o = new LightEmittingDiode(LightSource_element, model);
                o.update(LightEmittingDiode_element, model);
                this.addLightSource(o);
            }
        }
        List<Element> Detector_nodeList = Instrument.getChildrenByTagName(element, "Detector");
        for (Element Detector_element : Detector_nodeList) {
            this.addDetector(new Detector(Detector_element, model));
        }
        List<Element> Objective_nodeList = Instrument.getChildrenByTagName(element, "Objective");
        for (Element Objective_element : Objective_nodeList) {
            this.addObjective(new Objective(Objective_element, model));
        }
        List<Element> FilterSet_nodeList = Instrument.getChildrenByTagName(element, "FilterSet");
        for (Element FilterSet_element : FilterSet_nodeList) {
            this.addFilterSet(new FilterSet(FilterSet_element, model));
        }
        List<Element> Filter_nodeList = Instrument.getChildrenByTagName(element, "Filter");
        for (Element Filter_element : Filter_nodeList) {
            this.addFilter(new Filter(Filter_element, model));
        }
        List<Element> Dichroic_nodeList = Instrument.getChildrenByTagName(element, "Dichroic");
        for (Element Dichroic_element : Dichroic_nodeList) {
            this.addDichroic(new Dichroic(Dichroic_element, model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Microscope getMicroscope() {
        return this.microscope;
    }

    public void setMicroscope(Microscope microscope) {
        this.microscope = microscope;
    }

    public int sizeOfLightSourceList() {
        return this.lightSources.size();
    }

    public List<LightSource> copyLightSourceList() {
        return new ArrayList<LightSource>(this.lightSources);
    }

    public LightSource getLightSource(int index) {
        return this.lightSources.get(index);
    }

    public LightSource setLightSource(int index, LightSource lightSource) {
        lightSource.setInstrument(this);
        return this.lightSources.set(index, lightSource);
    }

    public void addLightSource(LightSource lightSource) {
        lightSource.setInstrument(this);
        this.lightSources.add(lightSource);
    }

    public void removeLightSource(LightSource lightSource) {
        this.lightSources.remove(lightSource);
    }

    public int sizeOfDetectorList() {
        return this.detectors.size();
    }

    public List<Detector> copyDetectorList() {
        return new ArrayList<Detector>(this.detectors);
    }

    public Detector getDetector(int index) {
        return this.detectors.get(index);
    }

    public Detector setDetector(int index, Detector detector) {
        detector.setInstrument(this);
        return this.detectors.set(index, detector);
    }

    public void addDetector(Detector detector) {
        detector.setInstrument(this);
        this.detectors.add(detector);
    }

    public void removeDetector(Detector detector) {
        this.detectors.remove(detector);
    }

    public int sizeOfObjectiveList() {
        return this.objectives.size();
    }

    public List<Objective> copyObjectiveList() {
        return new ArrayList<Objective>(this.objectives);
    }

    public Objective getObjective(int index) {
        return this.objectives.get(index);
    }

    public Objective setObjective(int index, Objective objective) {
        objective.setInstrument(this);
        return this.objectives.set(index, objective);
    }

    public void addObjective(Objective objective) {
        objective.setInstrument(this);
        this.objectives.add(objective);
    }

    public void removeObjective(Objective objective) {
        this.objectives.remove(objective);
    }

    public int sizeOfFilterSetList() {
        return this.filterSets.size();
    }

    public List<FilterSet> copyFilterSetList() {
        return new ArrayList<FilterSet>(this.filterSets);
    }

    public FilterSet getFilterSet(int index) {
        return this.filterSets.get(index);
    }

    public FilterSet setFilterSet(int index, FilterSet filterSet) {
        filterSet.setInstrument(this);
        return this.filterSets.set(index, filterSet);
    }

    public void addFilterSet(FilterSet filterSet) {
        filterSet.setInstrument(this);
        this.filterSets.add(filterSet);
    }

    public void removeFilterSet(FilterSet filterSet) {
        this.filterSets.remove(filterSet);
    }

    public int sizeOfFilterList() {
        return this.filters.size();
    }

    public List<Filter> copyFilterList() {
        return new ArrayList<Filter>(this.filters);
    }

    public Filter getFilter(int index) {
        return this.filters.get(index);
    }

    public Filter setFilter(int index, Filter filter) {
        filter.setInstrument(this);
        return this.filters.set(index, filter);
    }

    public void addFilter(Filter filter) {
        filter.setInstrument(this);
        this.filters.add(filter);
    }

    public void removeFilter(Filter filter) {
        this.filters.remove(filter);
    }

    public int sizeOfDichroicList() {
        return this.dichroics.size();
    }

    public List<Dichroic> copyDichroicList() {
        return new ArrayList<Dichroic>(this.dichroics);
    }

    public Dichroic getDichroic(int index) {
        return this.dichroics.get(index);
    }

    public Dichroic setDichroic(int index, Dichroic dichroic) {
        dichroic.setInstrument(this);
        return this.dichroics.set(index, dichroic);
    }

    public void addDichroic(Dichroic dichroic) {
        dichroic.setInstrument(this);
        this.dichroics.add(dichroic);
    }

    public void removeDichroic(Dichroic dichroic) {
        this.dichroics.remove(dichroic);
    }

    public int sizeOfLinkedImageList() {
        return this.images.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.images);
    }

    public Image getLinkedImage(int index) {
        return this.images.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.images.set(index, o);
    }

    public boolean linkImage(Image o) {
        if (!this.images.contains(o)) {
            return this.images.add(o);
        }
        return false;
    }

    public boolean unlinkImage(Image o) {
        return this.images.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Instrument_element) {
        if (Instrument_element == null) {
            Instrument_element = document.createElementNS(NAMESPACE, "Instrument");
        }
        if (this.id != null) {
            Instrument_element.setAttribute("ID", this.id.toString());
        }
        if (this.microscope != null) {
            Instrument_element.appendChild(this.microscope.asXMLElement(document));
        }
        if (this.lightSources != null) {
            for (LightSource lightSources_value : this.lightSources) {
                Instrument_element.appendChild(lightSources_value.asXMLElement(document));
            }
        }
        if (this.detectors != null) {
            for (Detector detectors_value : this.detectors) {
                Instrument_element.appendChild(detectors_value.asXMLElement(document));
            }
        }
        if (this.objectives != null) {
            for (Objective objectives_value : this.objectives) {
                Instrument_element.appendChild(objectives_value.asXMLElement(document));
            }
        }
        if (this.filterSets != null) {
            for (FilterSet filterSets_value : this.filterSets) {
                Instrument_element.appendChild(filterSets_value.asXMLElement(document));
            }
        }
        if (this.filters != null) {
            for (Filter filters_value : this.filters) {
                Instrument_element.appendChild(filters_value.asXMLElement(document));
            }
        }
        if (this.dichroics != null) {
            for (Dichroic dichroics_value : this.dichroics) {
                Instrument_element.appendChild(dichroics_value.asXMLElement(document));
            }
        }
        if (this.images != null) {
            // empty if block
        }
        return super.asXMLElement(document, Instrument_element);
    }
}

