/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.Detector;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Settings;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DetectorSettings
extends Settings {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(DetectorSettings.class);
    private Binning binning;
    private Double readOutRate;
    private Double gain;
    private Double offset;
    private String id;
    private Double voltage;
    private Detector detector;

    public DetectorSettings() {
    }

    public DetectorSettings(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"DetectorSettings".equals(tagName)) {
            LOGGER.debug("Expecting node name of DetectorSettings got {}", (Object)tagName);
        }
        if (element.hasAttribute("Binning")) {
            this.setBinning(Binning.fromString(element.getAttribute("Binning")));
        }
        if (element.hasAttribute("ReadOutRate")) {
            this.setReadOutRate(Double.valueOf(element.getAttribute("ReadOutRate")));
        }
        if (element.hasAttribute("Gain")) {
            this.setGain(Double.valueOf(element.getAttribute("Gain")));
        }
        if (element.hasAttribute("Offset")) {
            this.setOffset(Double.valueOf(element.getAttribute("Offset")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("DetectorSettings missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Voltage")) {
            this.setVoltage(Double.valueOf(element.getAttribute("Voltage")));
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public Binning getBinning() {
        return this.binning;
    }

    public void setBinning(Binning binning) {
        this.binning = binning;
    }

    public Double getReadOutRate() {
        return this.readOutRate;
    }

    public void setReadOutRate(Double readOutRate) {
        this.readOutRate = readOutRate;
    }

    public Double getGain() {
        return this.gain;
    }

    public void setGain(Double gain) {
        this.gain = gain;
    }

    public Double getOffset() {
        return this.offset;
    }

    public void setOffset(Double offset) {
        this.offset = offset;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Double getVoltage() {
        return this.voltage;
    }

    public void setVoltage(Double voltage) {
        this.voltage = voltage;
    }

    public Detector getDetector() {
        return this.detector;
    }

    public void setDetector(Detector detector) {
        this.detector = detector;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element DetectorSettings_element) {
        if (DetectorSettings_element == null) {
            DetectorSettings_element = document.createElementNS(NAMESPACE, "DetectorSettings");
        }
        if (this.binning != null) {
            DetectorSettings_element.setAttribute("Binning", this.binning.toString());
        }
        if (this.readOutRate != null) {
            DetectorSettings_element.setAttribute("ReadOutRate", this.readOutRate.toString());
        }
        if (this.gain != null) {
            DetectorSettings_element.setAttribute("Gain", this.gain.toString());
        }
        if (this.offset != null) {
            DetectorSettings_element.setAttribute("Offset", this.offset.toString());
        }
        if (this.id != null) {
            DetectorSettings_element.setAttribute("ID", this.id.toString());
        }
        if (this.voltage != null) {
            DetectorSettings_element.setAttribute("Voltage", this.voltage.toString());
        }
        if (this.detector != null) {
            // empty if block
        }
        return super.asXMLElement(document, DetectorSettings_element);
    }
}

