/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.awt.image.IndexColorModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import loci.common.DataTools;
import loci.common.DebugTools;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelFiller;
import loci.formats.ChannelMerger;
import loci.formats.ChannelSeparator;
import loci.formats.FilePattern;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageTools;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.MinMaxCalculator;
import loci.formats.MissingLibraryException;
import loci.formats.UpgradeChecker;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.TiffWriter;
import loci.formats.services.OMEXMLService;
import loci.formats.tiff.IFD;
import ome.xml.model.Image;
import ome.xml.model.OME;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageConverter.class);
    private static final String NO_UPGRADE_CHECK = "-no-upgrade";
    private String in = null;
    private String out = null;
    private String map = null;
    private String compression = null;
    private boolean stitch = false;
    private boolean separate = false;
    private boolean merge = false;
    private boolean fill = false;
    private boolean bigtiff = false;
    private boolean group = true;
    private boolean printVersion = false;
    private boolean autoscale = false;
    private Boolean overwrite = null;
    private int series = -1;
    private int firstPlane = 0;
    private int lastPlane = Integer.MAX_VALUE;
    private int channel = -1;
    private int zSection = -1;
    private int timepoint = -1;
    private int xCoordinate = 0;
    private int yCoordinate = 0;
    private int width = 0;
    private int height = 0;
    private IFormatReader reader;
    private MinMaxCalculator minMax;

    private ImageConverter() {
    }

    public boolean testConvert(IFormatWriter writer, String[] args) throws FormatException, IOException {
        IFormatWriter w;
        DebugTools.enableLogging("INFO");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-") && args.length > 1) {
                    if (args[i].equals("-debug")) {
                        DebugTools.enableLogging("DEBUG");
                        continue;
                    }
                    if (args[i].equals("-stitch")) {
                        this.stitch = true;
                        continue;
                    }
                    if (args[i].equals("-separate")) {
                        this.separate = true;
                        continue;
                    }
                    if (args[i].equals("-merge")) {
                        this.merge = true;
                        continue;
                    }
                    if (args[i].equals("-expand")) {
                        this.fill = true;
                        continue;
                    }
                    if (args[i].equals("-bigtiff")) {
                        this.bigtiff = true;
                        continue;
                    }
                    if (args[i].equals("-map")) {
                        this.map = args[++i];
                        continue;
                    }
                    if (args[i].equals("-compression")) {
                        this.compression = args[++i];
                        continue;
                    }
                    if (args[i].equals("-nogroup")) {
                        this.group = false;
                        continue;
                    }
                    if (args[i].equals("-autoscale")) {
                        this.autoscale = true;
                        continue;
                    }
                    if (args[i].equals("-overwrite")) {
                        this.overwrite = true;
                        continue;
                    }
                    if (args[i].equals("-nooverwrite")) {
                        this.overwrite = false;
                        continue;
                    }
                    if (args[i].equals("-channel")) {
                        this.channel = Integer.parseInt(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-z")) {
                        this.zSection = Integer.parseInt(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-timepoint")) {
                        this.timepoint = Integer.parseInt(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-series")) {
                        try {
                            this.series = Integer.parseInt(args[++i]);
                        }
                        catch (NumberFormatException exc) {}
                        continue;
                    }
                    if (args[i].equals("-range")) {
                        try {
                            this.firstPlane = Integer.parseInt(args[++i]);
                            this.lastPlane = Integer.parseInt(args[++i]) + 1;
                        }
                        catch (NumberFormatException exc) {}
                        continue;
                    }
                    if (args[i].equals("-crop")) {
                        String[] tokens = args[++i].split(",");
                        this.xCoordinate = Integer.parseInt(tokens[0]);
                        this.yCoordinate = Integer.parseInt(tokens[1]);
                        this.width = Integer.parseInt(tokens[2]);
                        this.height = Integer.parseInt(tokens[3]);
                        continue;
                    }
                    if (args[i].equals(NO_UPGRADE_CHECK)) continue;
                    LOGGER.error("Found unknown command flag: {}; exiting.", (Object)args[i]);
                    return false;
                }
                if (args[i].equals("-version")) {
                    this.printVersion = true;
                    continue;
                }
                if (this.in == null) {
                    this.in = args[i];
                    continue;
                }
                if (this.out == null) {
                    this.out = args[i];
                    continue;
                }
                LOGGER.error("Found unknown argument: {}; exiting.", (Object)args[i]);
                LOGGER.error("You should specify exactly one input file and exactly one output file.");
                return false;
            }
        }
        if (this.printVersion) {
            LOGGER.info("Version: {}", (Object)"4.4.6");
            LOGGER.info("VCS revision: {}", (Object)"3f142f7");
            LOGGER.info("Build date: {}", (Object)"7 February 2013");
            return true;
        }
        if (this.in == null || this.out == null) {
            String[] s = new String[]{"To convert a file between formats, run:", "  bfconvert [-debug] [-stitch] [-separate] [-merge] [-expand]", "    [-bigtiff] [-compression codec] [-series series] [-map id]", "    [-range start end] [-crop x,y,w,h] [-channel channel] [-z Z]", "    [-timepoint timepoint] [-nogroup] [-autoscale] [-version]", "    [-no-upgrade] in_file out_file", "", "    -version: print the library version and exit", " -no-upgrade: do not perform the upgrade check", "      -debug: turn on debugging output", "     -stitch: stitch input files with similar names", "   -separate: split RGB images into separate channels", "      -merge: combine separate channels into RGB image", "     -expand: expand indexed color to RGB", "    -bigtiff: force BigTIFF files to be written", "-compression: specify the codec to use when saving images", "     -series: specify which image series to convert", "        -map: specify file on disk to which name should be mapped", "      -range: specify range of planes to convert (inclusive)", "    -nogroup: force multi-file datasets to be read as individual              files", "  -autoscale: automatically adjust brightness and contrast before", "              converting; this may mean that the original pixel", "              values are not preserved", "  -overwrite: always overwrite the output file, if it already exists", "-nooverwrite: never overwrite the output file, if it already exists", "       -crop: crop images before converting; argument is 'x,y,w,h'", "    -channel: only convert the specified channel (indexed from 0)", "          -z: only convert the specified Z section (indexed from 0)", "  -timepoint: only convert the specified timepoint (indexed from 0)", "", "If any of the following patterns are present in out_file, they will", "be replaced with the indicated metadata value from the input file.", "", "   Pattern:\tMetadata value:", "   ---------------------------", "   %s\t\tseries index", "   %n\t\tseries name", "   %c\t\tchannel index", "   %w\t\tchannel name", "   %z\t\tZ index", "   %t\t\tT index", "   %A\t\tacquisition timestamp", "", "If any of these patterns are present, then the images to be saved", "will be split into multiple files.  For example, if the input file", "contains 5 Z sections and 3 timepoints, and out_file is", "", "  converted_Z%z_T%t.tiff", "", "then 15 files will be created, with the names", "", "  converted_Z0_T0.tiff", "  converted_Z0_T1.tiff", "  converted_Z0_T2.tiff", "  converted_Z1_T0.tiff", "  ...", "  converted_Z4_T2.tiff", "", "Each file would have a single image plane."};
            for (int i = 0; i < s.length; ++i) {
                LOGGER.info(s[i]);
            }
            return false;
        }
        if (new Location(this.out).exists()) {
            if (this.overwrite == null) {
                LOGGER.warn("Output file {} exists.", (Object)this.out);
                LOGGER.warn("Do you want to overwrite it? ([y]/n)");
                BufferedReader r = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
                String choice = r.readLine().trim().toLowerCase();
                this.overwrite = !choice.startsWith("n");
            }
            if (!this.overwrite.booleanValue()) {
                LOGGER.warn("Exiting; next time, please specify an output file that does not exist.");
                return false;
            }
            new Location(this.out).delete();
        }
        if (this.map != null) {
            Location.mapId(this.in, this.map);
        }
        long start = System.currentTimeMillis();
        LOGGER.info(this.in);
        this.reader = new ImageReader();
        if (this.stitch) {
            this.reader = new FileStitcher(this.reader);
            Location f = new Location(this.in);
            String pat = null;
            pat = !f.exists() ? this.in : FilePattern.findPattern(f);
            if (pat != null) {
                this.in = pat;
            }
        }
        if (this.separate) {
            this.reader = new ChannelSeparator(this.reader);
        }
        if (this.merge) {
            this.reader = new ChannelMerger(this.reader);
        }
        if (this.fill) {
            this.reader = new ChannelFiller(this.reader);
        }
        this.minMax = null;
        if (this.autoscale) {
            this.reader = new MinMaxCalculator(this.reader);
            this.minMax = (MinMaxCalculator)this.reader;
        }
        this.reader.setGroupFiles(this.group);
        this.reader.setMetadataFiltered(true);
        this.reader.setOriginalMetadataPopulated(true);
        OMEXMLService service = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            service = factory.getInstance(OMEXMLService.class);
            this.reader.setMetadataStore(service.createOMEXMLMetadata());
        }
        catch (DependencyException de) {
            throw new MissingLibraryException("ome-xml.jar is required to read OME-TIFF files.  Please download it from http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html", de);
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        this.reader.setId(this.in);
        MetadataStore store = this.reader.getMetadataStore();
        MetadataTools.populatePixels(store, this.reader, false, false);
        boolean dimensionsSet = true;
        if (this.width == 0 || this.height == 0) {
            this.width = this.reader.getSizeX();
            this.height = this.reader.getSizeY();
            dimensionsSet = false;
        }
        if (store instanceof MetadataRetrieve) {
            if (this.series >= 0) {
                try {
                    String xml = service.getOMEXML(service.asRetrieve(store));
                    OME root = (OME)store.getRoot();
                    Image exportImage = root.getImage(this.series);
                    OMEXMLMetadata meta = service.createOMEXMLMetadata(xml);
                    OME newRoot = (OME)meta.getRoot();
                    while (newRoot.sizeOfImageList() > 0) {
                        newRoot.removeImage(newRoot.getImage(0));
                    }
                    newRoot.addImage(exportImage);
                    meta.setRoot(newRoot);
                    meta.setPixelsSizeX(new PositiveInteger(this.width), 0);
                    meta.setPixelsSizeY(new PositiveInteger(this.height), 0);
                    if (this.autoscale) {
                        store.setPixelsType(PixelType.UINT8, 0);
                    }
                    if (this.channel >= 0) {
                        meta.setPixelsSizeC(new PositiveInteger(1), 0);
                    }
                    if (this.zSection >= 0) {
                        meta.setPixelsSizeZ(new PositiveInteger(1), 0);
                    }
                    if (this.timepoint >= 0) {
                        meta.setPixelsSizeT(new PositiveInteger(1), 0);
                    }
                    writer.setMetadataRetrieve(meta);
                }
                catch (ServiceException e) {
                    throw new FormatException(e);
                }
            } else {
                for (int i = 0; i < this.reader.getSeriesCount(); ++i) {
                    if (this.width != this.reader.getSizeX() || this.height != this.reader.getSizeY()) {
                        store.setPixelsSizeX(new PositiveInteger(this.width), 0);
                        store.setPixelsSizeY(new PositiveInteger(this.height), 0);
                    }
                    if (this.autoscale) {
                        store.setPixelsType(PixelType.UINT8, i);
                    }
                    if (this.channel >= 0) {
                        store.setPixelsSizeC(new PositiveInteger(1), 0);
                    }
                    if (this.zSection >= 0) {
                        store.setPixelsSizeZ(new PositiveInteger(1), 0);
                    }
                    if (this.timepoint < 0) continue;
                    store.setPixelsSizeT(new PositiveInteger(1), 0);
                }
                writer.setMetadataRetrieve((MetadataRetrieve)((Object)store));
            }
        }
        writer.setWriteSequentially(true);
        if (writer instanceof TiffWriter) {
            ((TiffWriter)writer).setBigTiff(this.bigtiff);
        } else if (writer instanceof ImageWriter && (w = ((ImageWriter)writer).getWriter(this.out)) instanceof TiffWriter) {
            ((TiffWriter)w).setBigTiff(this.bigtiff);
        }
        String format = writer.getFormat();
        LOGGER.info("[{}] -> {} [{}]", new Object[]{this.reader.getFormat(), this.out, format});
        long mid = System.currentTimeMillis();
        int total = 0;
        int num = writer.canDoStacks() ? this.reader.getSeriesCount() : 1;
        long read = 0L;
        long write = 0L;
        int first = this.series == -1 ? 0 : this.series;
        int last = this.series == -1 ? num : this.series + 1;
        long timeLastLogged = System.currentTimeMillis();
        for (int q = first; q < last; ++q) {
            this.reader.setSeries(q);
            if (!dimensionsSet) {
                this.width = this.reader.getSizeX();
                this.height = this.reader.getSizeY();
            }
            int writerSeries = this.series == -1 ? q : 0;
            writer.setSeries(writerSeries);
            writer.setInterleaved(this.reader.isInterleaved() && !this.autoscale);
            writer.setValidBitsPerPixel(this.reader.getBitsPerPixel());
            int numImages = writer.canDoStacks() ? this.reader.getImageCount() : 1;
            int startPlane = Math.max(0, this.firstPlane);
            int endPlane = Math.min(numImages, this.lastPlane);
            numImages = endPlane - startPlane;
            if (this.channel >= 0) {
                numImages /= this.reader.getEffectiveSizeC();
            }
            if (this.zSection >= 0) {
                numImages /= this.reader.getSizeZ();
            }
            if (this.timepoint >= 0) {
                numImages /= this.reader.getSizeT();
            }
            total += numImages;
            int count = 0;
            for (int i = startPlane; i < endPlane; ++i) {
                int[] coords = this.reader.getZCTCoords(i);
                if (this.zSection >= 0 && coords[0] != this.zSection || this.channel >= 0 && coords[1] != this.channel || this.timepoint >= 0 && coords[2] != this.timepoint) continue;
                writer.setId(FormatTools.getFilename(q, i, this.reader, this.out));
                if (this.compression != null) {
                    writer.setCompression(this.compression);
                }
                long s = System.currentTimeMillis();
                long m = this.convertPlane(writer, i, startPlane);
                long e = System.currentTimeMillis();
                read += m - s;
                write += e - m;
                if (count == numImages - 1 || (e - timeLastLogged) / 1000L > 0L) {
                    int current = count - startPlane + 1;
                    int percent = 100 * current / numImages;
                    StringBuilder sb = new StringBuilder();
                    sb.append("\t");
                    int numSeries = last - first;
                    if (numSeries > 1) {
                        sb.append("Series ");
                        sb.append(q);
                        sb.append(": converted ");
                    } else {
                        sb.append("Converted ");
                    }
                    LOGGER.info(sb.toString() + "{}/{} planes ({}%)", new Object[]{current, numImages, percent});
                    timeLastLogged = e;
                }
                ++count;
            }
        }
        writer.close();
        long end = System.currentTimeMillis();
        LOGGER.info("[done]");
        float sec = (float)(end - start) / 1000.0f;
        long initial = mid - start;
        float readAvg = (float)read / (float)total;
        float writeAvg = (float)write / (float)total;
        LOGGER.info("{}s elapsed ({}+{}ms per plane, {}ms overhead)", new Object[]{Float.valueOf(sec), Float.valueOf(readAvg), Float.valueOf(writeAvg), initial});
        return true;
    }

    private long convertPlane(IFormatWriter writer, int index, int startPlane) throws FormatException, IOException {
        if (DataTools.safeMultiply64(this.width, this.height) >= DataTools.safeMultiply64(4096L, 4096L) && (writer instanceof TiffWriter || writer instanceof ImageWriter && ((ImageWriter)writer).getWriter(this.out) instanceof TiffWriter)) {
            return this.convertTilePlane(writer, index, startPlane);
        }
        byte[] buf = this.reader.openBytes(index, this.xCoordinate, this.yCoordinate, this.width, this.height);
        this.autoscalePlane(buf, index);
        this.applyLUT(writer);
        long m = System.currentTimeMillis();
        writer.saveBytes(index - startPlane, buf);
        return m;
    }

    private long convertTilePlane(IFormatWriter writer, int index, int startPlane) throws FormatException, IOException {
        int w = this.reader.getOptimalTileWidth();
        int h = this.reader.getOptimalTileHeight();
        int nXTiles = this.width / w;
        int nYTiles = this.height / h;
        if (nXTiles * w != this.width) {
            ++nXTiles;
        }
        if (nYTiles * h != this.height) {
            ++nYTiles;
        }
        IFD ifd = new IFD();
        ifd.put(322, w);
        ifd.put(323, h);
        Long m = null;
        for (int y = 0; y < nYTiles; ++y) {
            for (int x = 0; x < nXTiles; ++x) {
                IFormatWriter baseWriter;
                int tileX = this.xCoordinate + x * w;
                int tileY = this.yCoordinate + y * h;
                int tileWidth = x < nXTiles - 1 ? w : this.width % w;
                int tileHeight = y < nYTiles - 1 ? h : this.height % h;
                byte[] buf = this.reader.openBytes(index, tileX, tileY, tileWidth, tileHeight);
                this.autoscalePlane(buf, index);
                this.applyLUT(writer);
                if (m == null) {
                    m = System.currentTimeMillis();
                }
                if (writer instanceof TiffWriter) {
                    ((TiffWriter)writer).saveBytes(index - startPlane, buf, ifd, tileX, tileY, tileWidth, tileHeight);
                    continue;
                }
                if (!(writer instanceof ImageWriter) || !((baseWriter = ((ImageWriter)writer).getWriter(this.out)) instanceof TiffWriter)) continue;
                ((TiffWriter)baseWriter).saveBytes(index - startPlane, buf, ifd, tileX, tileY, tileWidth, tileHeight);
            }
        }
        return m;
    }

    private void autoscalePlane(byte[] buf, int index) throws FormatException, IOException {
        if (this.autoscale) {
            Double min = null;
            Double max = null;
            Double[] planeMin = this.minMax.getPlaneMinimum(index);
            Double[] planeMax = this.minMax.getPlaneMaximum(index);
            if (planeMin != null && planeMax != null) {
                min = planeMin[0];
                max = planeMax[0];
                for (int j = 1; j < planeMin.length; ++j) {
                    if (planeMin[j] < min) {
                        min = planeMin[j];
                    }
                    if (!(planeMax[j] < max)) continue;
                    max = planeMax[j];
                }
            }
            int pixelType = this.reader.getPixelType();
            int bpp = FormatTools.getBytesPerPixel(pixelType);
            boolean floatingPoint = FormatTools.isFloatingPoint(pixelType);
            Object pix = DataTools.makeDataArray(buf, bpp, floatingPoint, this.reader.isLittleEndian());
            byte[][] b = ImageTools.make24Bits(pix, this.width, this.height, this.reader.isInterleaved(), false, min, max);
            int channelCount = this.reader.getRGBChannelCount();
            int copyComponents = Math.min(channelCount, b.length);
            buf = new byte[channelCount * b[0].length];
            for (int j = 0; j < copyComponents; ++j) {
                System.arraycopy(b[j], 0, buf, b[0].length * j, b[0].length);
            }
        }
    }

    private void applyLUT(IFormatWriter writer) throws FormatException, IOException {
        byte[][] lut = this.reader.get8BitLookupTable();
        if (lut != null) {
            IndexColorModel model = new IndexColorModel(8, lut[0].length, lut[0], lut[1], lut[2]);
            writer.setColorModel(model);
        }
    }

    public static void main(String[] args) throws FormatException, IOException {
        ImageConverter converter;
        UpgradeChecker checker;
        boolean canUpgrade;
        if (DataTools.indexOf(args, NO_UPGRADE_CHECK) == -1 && (canUpgrade = (checker = new UpgradeChecker()).newVersionAvailable("Bio-Formats utilities"))) {
            LOGGER.info("*** A new stable version is available. ***");
            LOGGER.info("*** Install the new version using:     ***");
            LOGGER.info("***   'upgradechecker -install'        ***");
        }
        if (!(converter = new ImageConverter()).testConvert(new ImageWriter(), args)) {
            System.exit(1);
        }
        System.exit(0);
    }
}

