/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import loci.common.services.AbstractService;
import loci.common.services.ServiceException;
import loci.common.xml.XMLTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataConverter;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.ome.OMEXMLMetadataImpl;
import loci.formats.services.OMEXMLService;
import ome.xml.model.BinData;
import ome.xml.model.Channel;
import ome.xml.model.Image;
import ome.xml.model.MetadataOnly;
import ome.xml.model.OME;
import ome.xml.model.OMEModelImpl;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Pixels;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.XMLAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMEXMLServiceImpl
extends AbstractService
implements OMEXMLService {
    public static final String NO_OME_XML_MSG = "ome-xml.jar is required to read OME-TIFF files.  Please download it from http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html";
    private static final Logger LOGGER = LoggerFactory.getLogger(OMEXMLService.class);
    private static final String ORIGINAL_METADATA_NS = "openmicroscopy.org/OriginalMetadata";
    private static final String XSLT_PATH = "/loci/formats/meta/";
    private static final String XSLT_REORDER = "/loci/formats/meta/reorder-2008-09.xsl";
    private static final String XSLT_2003FC = "/loci/formats/meta/2003-FC-to-2008-09.xsl";
    private static final String XSLT_2006LO = "/loci/formats/meta/2006-LO-to-2008-09.xsl";
    private static final String XSLT_200706 = "/loci/formats/meta/2007-06-to-2008-09.xsl";
    private static final String XSLT_200802 = "/loci/formats/meta/2008-02-to-2008-09.xsl";
    private static final String XSLT_200809 = "/loci/formats/meta/2008-09-to-2009-09.xsl";
    private static final String XSLT_200909 = "/loci/formats/meta/2009-09-to-2010-04.xsl";
    private static final String XSLT_201004 = "/loci/formats/meta/2010-04-to-2010-06.xsl";
    private static final String XSLT_201006 = "/loci/formats/meta/2010-06-to-2011-06.xsl";
    private static final String XSLT_201106 = "/loci/formats/meta/2011-06-to-2012-06.xsl";
    private static Templates reorderXSLT;
    private static Templates update2003FC;
    private static Templates update2006LO;
    private static Templates update200706;
    private static Templates update200802;
    private static Templates update200809;
    private static Templates update200909;
    private static Templates update201004;
    private static Templates update201006;
    private static Templates update201106;
    private static final String SCHEMA_PATH = "http://www.openmicroscopy.org/Schemas/OME/";

    public OMEXMLServiceImpl() {
        this.checkClassDependency(OMEModelObject.class);
    }

    @Override
    public String getLatestVersion() {
        return "2012-06";
    }

    @Override
    public String transformToLatestVersion(String xml) throws ServiceException {
        String version = this.getOMEXMLVersion(xml);
        if (version.equals(this.getLatestVersion())) {
            return xml;
        }
        LOGGER.debug("Attempting to update XML with version: {}", (Object)version);
        LOGGER.trace("Initial dump: {}", (Object)xml);
        String transformed = null;
        try {
            if (version.equals("2003-FC")) {
                xml = this.verifyOMENamespace(xml);
                LOGGER.debug("Running UPDATE_2003FC stylesheet.");
                if (update2003FC == null) {
                    update2003FC = XMLTools.getStylesheet(XSLT_2003FC, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(xml, update2003FC);
            } else if (version.equals("2006-LO")) {
                xml = this.verifyOMENamespace(xml);
                LOGGER.debug("Running UPDATE_2006LO stylesheet.");
                if (update2006LO == null) {
                    update2006LO = XMLTools.getStylesheet(XSLT_2006LO, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(xml, update2006LO);
            } else if (version.equals("2007-06")) {
                xml = this.verifyOMENamespace(xml);
                LOGGER.debug("Running UPDATE_200706 stylesheet.");
                if (update200706 == null) {
                    update200706 = XMLTools.getStylesheet(XSLT_200706, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(xml, update200706);
            } else if (version.equals("2008-02")) {
                xml = this.verifyOMENamespace(xml);
                LOGGER.debug("Running UPDATE_200802 stylesheet.");
                if (update200802 == null) {
                    update200802 = XMLTools.getStylesheet(XSLT_200802, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(xml, update200802);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2008-09");
            LOGGER.trace("At least 2008-09 dump: {}", (Object)transformed);
            if (!(version.equals("2009-09") || version.equals("2010-04") || version.equals("2010-06") || version.equals("2011-06") || version.equals("2012-06"))) {
                transformed = this.verifyOMENamespace(transformed);
                LOGGER.debug("Running UPDATE_200809 stylesheet.");
                if (update200809 == null) {
                    update200809 = XMLTools.getStylesheet(XSLT_200809, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(transformed, update200809);
            }
            LOGGER.debug("XML updated to at least 2009-09");
            LOGGER.trace("At least 2009-09 dump: {}", (Object)transformed);
            if (!(version.equals("2010-04") || version.equals("2010-06") || version.equals("2011-06") || version.equals("2012-06"))) {
                transformed = this.verifyOMENamespace(transformed);
                LOGGER.debug("Running UPDATE_200909 stylesheet.");
                if (update200909 == null) {
                    update200909 = XMLTools.getStylesheet(XSLT_200909, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(transformed, update200909);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2010-04");
            LOGGER.trace("At least 2010-04 dump: {}", (Object)transformed);
            if (!(version.equals("2010-06") || version.equals("2011-06") || version.equals("2012-06"))) {
                transformed = this.verifyOMENamespace(transformed);
                LOGGER.debug("Running UPDATE_201004 stylesheet.");
                if (update201004 == null) {
                    update201004 = XMLTools.getStylesheet(XSLT_201004, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(transformed, update201004);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2010-06");
            if (!version.equals("2011-06") && !version.equals("2012-06")) {
                transformed = this.verifyOMENamespace(transformed);
                LOGGER.debug("Running UPDATE_201006 stylesheet.");
                if (update201006 == null) {
                    update201006 = XMLTools.getStylesheet(XSLT_201006, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(transformed, update201006);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2011-06");
            if (!version.equals("2012-06")) {
                transformed = this.verifyOMENamespace(transformed);
                LOGGER.debug("Running UPDATE_201106 stylesheet.");
                if (update201106 == null) {
                    update201106 = XMLTools.getStylesheet(XSLT_201106, OMEXMLServiceImpl.class);
                }
                transformed = XMLTools.transformXML(transformed, update201106);
            } else {
                transformed = xml;
            }
            LOGGER.debug("XML updated to at least 2012-06");
            transformed = transformed.replaceAll("<ns.*?:", "<");
            transformed = transformed.replaceAll("xmlns:ns.*?=", "xmlns:OME=");
            transformed = transformed.replaceAll("</ns.*?:", "</");
            LOGGER.trace("Transformed XML dump: {}", (Object)transformed);
            return transformed;
        }
        catch (IOException e) {
            LOGGER.warn("Could not transform version " + version + " OME-XML.");
            return null;
        }
    }

    @Override
    public OMEXMLMetadata createOMEXMLMetadata() throws ServiceException {
        return this.createOMEXMLMetadata(null);
    }

    @Override
    public OMEXMLMetadata createOMEXMLMetadata(String xml) throws ServiceException {
        return this.createOMEXMLMetadata(xml, null);
    }

    @Override
    public OMEXMLMetadata createOMEXMLMetadata(String xml, String version) throws ServiceException {
        if (xml != null) {
            xml = XMLTools.sanitizeXML(xml);
        }
        OMEModelObject ome = xml == null ? null : this.createRoot(this.transformToLatestVersion(xml));
        OMEXMLMetadataImpl meta = new OMEXMLMetadataImpl();
        if (ome != null) {
            meta.setRoot(ome);
        }
        return meta;
    }

    @Override
    public Object createOMEXMLRoot(String xml) throws ServiceException {
        return this.createRoot(this.transformToLatestVersion(xml));
    }

    @Override
    public boolean isOMEXMLMetadata(Object o) {
        return o instanceof OMEXMLMetadata;
    }

    @Override
    public boolean isOMEXMLRoot(Object o) {
        return o instanceof OMEModelObject;
    }

    private OMEModelObject createRoot(String xml) throws ServiceException {
        try {
            OMEModelImpl model = new OMEModelImpl();
            OME ome = new OME(XMLTools.parseDOM(xml).getDocumentElement(), model);
            model.resolveReferences();
            return ome;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public String getOMEXMLVersion(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof OMEXMLMetadata || o instanceof OMEModelObject) {
            return "2012-06";
        }
        if (o instanceof String) {
            String xml = (String)o;
            try {
                Element e = XMLTools.parseDOM(xml).getDocumentElement();
                String namespace = e.getAttribute("xmlns");
                if (namespace == null || namespace.equals("")) {
                    namespace = e.getAttribute("xmlns:ome");
                }
                if (namespace == null || namespace.equals("")) {
                    namespace = e.getAttribute("xmlns:OME");
                }
                return namespace.endsWith("ome.xsd") ? "2003-FC" : namespace.substring(namespace.lastIndexOf("/") + 1);
            }
            catch (ParserConfigurationException pce) {
            }
            catch (SAXException se) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public OMEXMLMetadata getOMEMetadata(MetadataRetrieve src) throws ServiceException {
        if (src instanceof OMEXMLMetadata) {
            return (OMEXMLMetadata)src;
        }
        OMEXMLMetadata omexmlMeta = this.createOMEXMLMetadata();
        this.convertMetadata(src, (MetadataStore)omexmlMeta);
        return omexmlMeta;
    }

    @Override
    public String getOMEXML(MetadataRetrieve src) throws ServiceException {
        OMEXMLMetadata omexmlMeta = this.getOMEMetadata(src);
        String xml = omexmlMeta.dumpXML();
        Document doc = null;
        Exception exception = null;
        try {
            doc = XMLTools.parseDOM(xml);
        }
        catch (ParserConfigurationException exc) {
            exception = exc;
        }
        catch (SAXException exc) {
            exception = exc;
        }
        catch (IOException exc) {
            exception = exc;
        }
        if (exception != null) {
            LOGGER.info("Malformed OME-XML", (Throwable)exception);
            return null;
        }
        Element root = doc.getDocumentElement();
        root.setAttribute("xmlns", SCHEMA_PATH + this.getLatestVersion());
        try {
            xml = XMLTools.getXML(doc);
        }
        catch (TransformerConfigurationException exc) {
            exception = exc;
        }
        catch (TransformerException exc) {
            exception = exc;
        }
        if (exception != null) {
            LOGGER.info("Internal XML conversion error", (Throwable)exception);
            return null;
        }
        return xml;
    }

    @Override
    public boolean validateOMEXML(String xml) {
        return this.validateOMEXML(xml, false);
    }

    @Override
    public boolean validateOMEXML(String xml, boolean pixelsHack) {
        if (pixelsHack) {
            Document doc = null;
            Exception exception = null;
            try {
                doc = XMLTools.parseDOM(xml);
            }
            catch (ParserConfigurationException exc) {
                exception = exc;
            }
            catch (SAXException exc) {
                exception = exc;
            }
            catch (IOException exc) {
                exception = exc;
            }
            if (exception != null) {
                LOGGER.info("Malformed OME-XML", (Throwable)exception);
                return false;
            }
            NodeList list = doc.getElementsByTagName("Pixels");
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                NodeList children = node.getChildNodes();
                boolean needsTiffData = true;
                for (int j = 0; j < children.getLength(); ++j) {
                    Node child = children.item(j);
                    String name = child.getLocalName();
                    if (!"TiffData".equals(name) && !"BinData".equals(name)) continue;
                    needsTiffData = false;
                    break;
                }
                if (!needsTiffData) continue;
                Element tiffData = doc.createElement("TiffData");
                node.insertBefore(tiffData, node.getFirstChild());
            }
            try {
                xml = XMLTools.getXML(doc);
            }
            catch (TransformerConfigurationException exc) {
                exception = exc;
            }
            catch (TransformerException exc) {
                exception = exc;
            }
            if (exception != null) {
                LOGGER.info("Internal XML conversion error", (Throwable)exception);
                return false;
            }
        }
        return XMLTools.validateXML(xml, "OME-XML");
    }

    @Override
    public Hashtable getOriginalMetadata(OMEXMLMetadata omexmlMeta) {
        OME root = (OME)omexmlMeta.getRoot();
        StructuredAnnotations annotations = root.getStructuredAnnotations();
        if (annotations == null) {
            return null;
        }
        Hashtable<String, String> metadata = new Hashtable<String, String>();
        for (int i = 0; i < annotations.sizeOfXMLAnnotationList(); ++i) {
            XMLAnnotation annotation = annotations.getXMLAnnotation(i);
            String xml = annotation.getValue();
            try {
                int meta;
                Document annotationRoot = XMLTools.parseDOM(xml);
                NodeList metadataNodes = annotationRoot.getElementsByTagName("OriginalMetadata");
                for (meta = 0; meta < metadataNodes.getLength(); ++meta) {
                    Element metadataNode = (Element)metadataNodes.item(meta);
                    NodeList keys = metadataNode.getElementsByTagName("Key");
                    NodeList values = metadataNode.getElementsByTagName("Value");
                    for (int q = 0; q < keys.getLength(); ++q) {
                        Node key = keys.item(q);
                        Node value = values.item(q);
                        metadata.put(key.getTextContent(), value.getTextContent());
                    }
                }
                if (metadataNodes.getLength() != 0) continue;
                metadataNodes = annotationRoot.getDocumentElement().getChildNodes();
                for (meta = 0; meta < metadataNodes.getLength(); ++meta) {
                    Element node = (Element)metadataNodes.item(meta);
                    String name = node.getNodeName();
                    NamedNodeMap attrs = node.getAttributes();
                    Node value = attrs.getNamedItem("Value");
                    if (value == null) continue;
                    metadata.put(name, value.getNodeValue());
                }
                continue;
            }
            catch (ParserConfigurationException e) {
                LOGGER.debug("Failed to parse OriginalMetadata", (Throwable)e);
                continue;
            }
            catch (SAXException e) {
                LOGGER.debug("Failed to parse OriginalMetadata", (Throwable)e);
                continue;
            }
            catch (IOException e) {
                LOGGER.debug("Failed to parse OriginalMetadata", (Throwable)e);
            }
        }
        return metadata;
    }

    @Override
    public void populateOriginalMetadata(OMEXMLMetadata omexmlMeta, Hashtable<String, Object> metadata) {
        ((OMEXMLMetadataImpl)omexmlMeta).resolveReferences();
        OME root = (OME)omexmlMeta.getRoot();
        StructuredAnnotations annotations = root.getStructuredAnnotations();
        if (annotations == null) {
            annotations = new StructuredAnnotations();
        }
        int annotationIndex = annotations.sizeOfXMLAnnotationList();
        for (String key : metadata.keySet()) {
            OriginalMetadataAnnotation annotation = new OriginalMetadataAnnotation();
            annotation.setID(MetadataTools.createLSID("Annotation", annotationIndex++));
            annotation.setKey(key);
            annotation.setValue(metadata.get(key).toString());
            annotations.addXMLAnnotation(annotation);
        }
        root.setStructuredAnnotations(annotations);
        omexmlMeta.setRoot(root);
    }

    @Override
    public void populateOriginalMetadata(OMEXMLMetadata omexmlMeta, String key, String value) {
        ((OMEXMLMetadataImpl)omexmlMeta).resolveReferences();
        OME root = (OME)omexmlMeta.getRoot();
        StructuredAnnotations annotations = root.getStructuredAnnotations();
        if (annotations == null) {
            annotations = new StructuredAnnotations();
        }
        int annotationIndex = annotations.sizeOfXMLAnnotationList();
        OriginalMetadataAnnotation annotation = new OriginalMetadataAnnotation();
        annotation.setID(MetadataTools.createLSID("Annotation", annotationIndex));
        annotation.setKey(key);
        annotation.setValue(value);
        annotations.addXMLAnnotation(annotation);
        root.setStructuredAnnotations(annotations);
        omexmlMeta.setRoot(root);
    }

    @Override
    public void convertMetadata(String xml, MetadataStore dest) throws ServiceException {
        String storeVersion;
        OMEModelObject ome = this.createRoot(this.transformToLatestVersion(xml));
        String rootVersion = this.getOMEXMLVersion(ome);
        if (rootVersion.equals(storeVersion = this.getOMEXMLVersion(dest))) {
            if (!(dest instanceof OMEXMLMetadata)) {
                throw new IllegalArgumentException("Expecting OMEXMLMetadata instance.");
            }
            dest.setRoot(ome);
        } else {
            OMEXMLMetadata src = this.createOMEXMLMetadata(xml);
            this.convertMetadata(src, dest);
        }
    }

    @Override
    public void convertMetadata(MetadataRetrieve src, MetadataStore dest) {
        MetadataConverter.convertMetadata(src, dest);
    }

    @Override
    public void removeBinData(OMEXMLMetadata omexmlMeta) {
        ((OMEXMLMetadataImpl)omexmlMeta).resolveReferences();
        OME root = (OME)omexmlMeta.getRoot();
        List<Image> images = root.copyImageList();
        for (Image img : images) {
            Pixels pix = img.getPixels();
            List<BinData> binData = pix.copyBinDataList();
            for (BinData bin : binData) {
                pix.removeBinData(bin);
            }
        }
        omexmlMeta.setRoot(root);
    }

    @Override
    public void removeChannels(OMEXMLMetadata omexmlMeta, int image, int sizeC) {
        ((OMEXMLMetadataImpl)omexmlMeta).resolveReferences();
        OME root = (OME)omexmlMeta.getRoot();
        Pixels img = root.getImage(image).getPixels();
        List<Channel> channels = img.copyChannelList();
        for (int c = 0; c < channels.size(); ++c) {
            Channel channel = channels.get(c);
            if (channel.getID() != null && c < sizeC) continue;
            img.removeChannel(channel);
        }
        omexmlMeta.setRoot(root);
    }

    @Override
    public void addMetadataOnly(OMEXMLMetadata omexmlMeta, int image) {
        ((OMEXMLMetadataImpl)omexmlMeta).resolveReferences();
        MetadataOnly meta = new MetadataOnly();
        OME root = (OME)omexmlMeta.getRoot();
        Pixels pix = root.getImage(image).getPixels();
        pix.setMetadataOnly(meta);
        omexmlMeta.setRoot(root);
    }

    @Override
    public boolean isEqual(OMEXMLMetadata src1, OMEXMLMetadata src2) {
        ((OMEXMLMetadataImpl)src1).resolveReferences();
        ((OMEXMLMetadataImpl)src2).resolveReferences();
        OME omeRoot1 = (OME)src1.getRoot();
        OME omeRoot2 = (OME)src2.getRoot();
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        Document doc1 = builder.newDocument();
        Document doc2 = builder.newDocument();
        Element root1 = omeRoot1.asXMLElement(doc1);
        Element root2 = omeRoot2.asXMLElement(doc2);
        return this.equals(root1, root2);
    }

    @Override
    public MetadataStore asStore(MetadataRetrieve meta) {
        return meta instanceof MetadataStore ? (MetadataStore)((Object)meta) : null;
    }

    @Override
    public MetadataRetrieve asRetrieve(MetadataStore meta) {
        return meta instanceof MetadataRetrieve ? (MetadataRetrieve)((Object)meta) : null;
    }

    private String verifyOMENamespace(String xml) {
        try {
            Document doc = XMLTools.parseDOM(xml);
            Element e = doc.getDocumentElement();
            String omeNamespace = e.getAttribute("xmlns:ome");
            if (omeNamespace == null || omeNamespace.equals("")) {
                e.setAttribute("xmlns:ome", e.getAttribute("xmlns"));
            }
            return XMLTools.getXML(doc);
        }
        catch (ParserConfigurationException pce) {
        }
        catch (TransformerConfigurationException tce) {
        }
        catch (TransformerException te) {
        }
        catch (SAXException se) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public boolean equals(Node e1, Node e2) {
        String localName2;
        NodeList children1 = e1.getChildNodes();
        NodeList children2 = e2.getChildNodes();
        String localName1 = e1.getLocalName();
        if (localName1 == null) {
            localName1 = "";
        }
        if ((localName2 = e2.getLocalName()) == null) {
            localName2 = "";
        }
        if (!localName1.equals(localName2)) {
            return false;
        }
        if (localName1.equals("StructuredAnnotations")) {
            return true;
        }
        NamedNodeMap attributes1 = e1.getAttributes();
        NamedNodeMap attributes2 = e2.getAttributes();
        if (attributes1 == null || attributes2 == null) {
            if (attributes1 == null && attributes2 != null || attributes1 != null && attributes2 == null) {
                return false;
            }
        } else {
            if (attributes1.getLength() != attributes2.getLength()) {
                return false;
            }
            int nAttributes = attributes1.getLength();
            for (int i = 0; i < nAttributes; ++i) {
                Node n2;
                Node n1 = attributes1.item(i);
                String localName = n1.getNodeName();
                if (localName != null && !localName.equals("ID")) {
                    n2 = attributes2.getNamedItem(localName);
                    if (n2 == null) {
                        return false;
                    }
                    if (this.equals(n1, n2)) continue;
                    return false;
                }
                if (!"ID".equals(localName) || !localName1.endsWith("Settings")) continue;
                n2 = attributes2.getNamedItem(localName);
                Node realRoot1 = this.findRootNode(e1);
                Node realRoot2 = this.findRootNode(e2);
                String refName = localName1.replaceAll("Settings", "");
                Node ref1 = this.findChildWithID(realRoot1, refName, n1.getNodeValue());
                Node ref2 = this.findChildWithID(realRoot2, refName, n2.getNodeValue());
                if (ref1 == null && ref2 == null) {
                    return true;
                }
                if (!(ref1 == null && ref2 != null || ref1 != null && ref2 == null) && this.equals(ref1, ref2)) continue;
                return false;
            }
        }
        if (children1.getLength() != children2.getLength()) {
            return false;
        }
        String node1 = e1.getNodeValue();
        String node2 = e2.getNodeValue();
        if (node1 == null && node2 != null) {
            return false;
        }
        if (node1 != null && !node1.equals(node2) && !localName1.equals("")) {
            return false;
        }
        for (int i = 0; i < children1.getLength(); ++i) {
            if (this.equals(children1.item(i), children2.item(i))) continue;
            return false;
        }
        return true;
    }

    private Node findRootNode(Node child) {
        if (child.getParentNode() != null) {
            return this.findRootNode(child.getParentNode());
        }
        return child;
    }

    private Node findChildWithID(Node root, String name, String id) {
        Node idNode;
        NamedNodeMap attributes = root.getAttributes();
        if (attributes != null && (idNode = attributes.getNamedItem("ID")) != null && id.equals(idNode.getNodeValue()) && name.equals(root.getNodeName())) {
            return root;
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node result = this.findChildWithID(children.item(i), name, id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    class OriginalMetadataAnnotation
    extends XMLAnnotation {
        private String key;
        private String value;

        OriginalMetadataAnnotation() {
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        protected Element asXMLElement(Document document, Element element) {
            if (element == null) {
                element = document.createElementNS("http://www.openmicroscopy.org/Schemas/SA/2012-06", "XMLAnnotation");
            }
            Element keyElement = document.createElementNS(OMEXMLServiceImpl.ORIGINAL_METADATA_NS, "Key");
            Element valueElement = document.createElementNS(OMEXMLServiceImpl.ORIGINAL_METADATA_NS, "Value");
            keyElement.setTextContent(this.key);
            valueElement.setTextContent(this.value);
            Element originalMetadata = document.createElementNS(OMEXMLServiceImpl.ORIGINAL_METADATA_NS, "OriginalMetadata");
            originalMetadata.appendChild(keyElement);
            originalMetadata.appendChild(valueElement);
            Element annotationValue = document.createElementNS("http://www.openmicroscopy.org/Schemas/SA/2012-06", "Value");
            annotationValue.appendChild(originalMetadata);
            element.appendChild(annotationValue);
            return super.asXMLElement(document, element);
        }
    }
}

