/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.in.BaseZeissReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.services.POIService;

public class ZeissZVIReader
extends BaseZeissReader {
    public static final int ZVI_MAGIC_BYTES = -791735840;
    private static final long ROI_SIGNATURE = 2449947852680921101L;
    protected POIService poi;
    protected String[] files;

    public ZeissZVIReader() {
        super("Zeiss Vision Image (ZVI)", "zvi");
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 65536;
        if (!FormatTools.validStream(stream, 65536, false)) {
            return false;
        }
        int magic = stream.readInt();
        return magic == -791735840;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int yy;
        byte[] t;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.lastPlane = no;
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int pixel = bytes * this.getRGBChannelCount();
        CodecOptions options = new CodecOptions();
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isInterleaved();
        int index = no;
        if (this.getSeriesCount() > 1) {
            index += this.getSeries() * this.getImageCount();
        }
        if (index >= this.imageFiles.length) {
            return buf;
        }
        RandomAccessInputStream s = this.poi.getDocumentStream(this.imageFiles[index]);
        s.seek(this.offsets[index]);
        int len = w * pixel;
        int row = this.getSizeX() * pixel;
        if (this.isJPEG) {
            t = new JPEGCodec().decompress(s, options);
            for (yy = 0; yy < h; ++yy) {
                System.arraycopy(t, (yy + y) * row + x * pixel, buf, yy * len, len);
            }
        } else if (this.isZlib) {
            t = new ZlibCodec().decompress(s, options);
            for (yy = 0; yy < h; ++yy) {
                int src = (yy + y) * row + x * pixel;
                int dest = yy * len;
                if (src + len <= t.length && dest + len <= buf.length) {
                    System.arraycopy(t, src, buf, dest, len);
                    continue;
                }
                break;
            }
        } else {
            this.readPlane(s, x, y, w, h, buf);
        }
        s.close();
        if (this.isRGB() && !this.isJPEG) {
            byte[] bb = new byte[bytes];
            for (int i = 0; i < buf.length; i += this.bpp) {
                System.arraycopy(buf, i + 2 * bytes, bb, 0, bytes);
                System.arraycopy(buf, i, buf, i + 2 * bytes, bytes);
                System.arraycopy(bb, 0, buf, i, bytes);
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.poi != null) {
            this.poi.close();
        }
        this.poi = null;
        this.files = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        super.initFileMain(id);
    }

    protected void initVars(String id) throws FormatException, IOException {
        super.initVars(id);
        try {
            ServiceFactory factory = new ServiceFactory();
            this.poi = factory.getInstance(POIService.class);
        }
        catch (DependencyException de) {
            throw new FormatException("POI library not found", de);
        }
        this.poi.initialize(Location.getMappedId(id));
        this.countImages();
    }

    protected void fillMetadataPass1(MetadataStore store) throws FormatException, IOException {
        super.fillMetadataPass1(store);
        for (String name : this.files) {
            int imageNum;
            String relPath = name.substring(name.lastIndexOf(File.separator) + 1);
            if (!relPath.toUpperCase().equals("CONTENTS")) continue;
            String dirName = name.substring(0, name.lastIndexOf(File.separator));
            if (dirName.indexOf(File.separator) != -1) {
                dirName = dirName.substring(dirName.lastIndexOf(File.separator) + 1);
            }
            if (name.indexOf("Scaling") == -1 && dirName.equals("Tags")) {
                imageNum = this.getImageNumber(name, -1);
                if (imageNum == -1) {
                    this.parseTags(imageNum, name, new DummyMetadata());
                    continue;
                }
                this.tagsToParse.add(name);
                continue;
            }
            if (dirName.equals("Shapes") && name.indexOf("Item") != -1) {
                imageNum = this.getImageNumber(name, -1);
                if (imageNum == -1) continue;
                try {
                    this.parseROIs(imageNum, name, store);
                }
                catch (IOException e) {
                    LOGGER.debug("Could not parse all ROIs.", (Throwable)e);
                }
                continue;
            }
            if (!dirName.equals("Image") && dirName.toUpperCase().indexOf("ITEM") == -1 || (imageNum = this.getImageNumber(dirName, this.getImageCount() == 1 ? 0 : -1)) == -1) continue;
            RandomAccessInputStream s = this.poi.getDocumentStream(name);
            s.order(true);
            if (s.length() <= 1024L) {
                s.close();
                continue;
            }
            for (int q = 0; q < 11; ++q) {
                this.getNextTag(s);
            }
            s.skipBytes(2);
            int len = s.readInt() - 20;
            s.skipBytes(8);
            int zidx = s.readInt();
            int cidx = s.readInt();
            int tidx = s.readInt();
            this.zIndices.add(zidx);
            this.timepointIndices.add(tidx);
            this.channelIndices.add(cidx);
            s.skipBytes(len);
            for (int q = 0; q < 5; ++q) {
                this.getNextTag(s);
            }
            s.skipBytes(4);
            this.core[0].sizeX = s.readInt();
            this.core[0].sizeY = s.readInt();
            s.skipBytes(4);
            if (this.bpp == 0) {
                this.bpp = s.readInt();
            } else {
                s.skipBytes(4);
            }
            s.skipBytes(4);
            int valid = s.readInt();
            String check = s.readString(4).trim();
            this.isZlib = (valid == 0 || valid == 1) && check.equals("WZL");
            this.isJPEG = (valid == 0 || valid == 1) && !this.isZlib;
            this.offsets[imageNum] = (int)s.getFilePointer() - 4;
            if (this.isZlib) {
                int n = imageNum;
                this.offsets[n] = this.offsets[n] + 8;
            }
            this.coordinates[imageNum][0] = zidx;
            this.coordinates[imageNum][1] = cidx;
            this.coordinates[imageNum][2] = tidx;
            this.imageFiles[imageNum] = name;
            s.close();
        }
    }

    protected void fillMetadataPass3(MetadataStore store) throws FormatException, IOException {
        super.fillMetadataPass3(store);
        if (this.core.length > 1) {
            Object[] t = this.tiles.keySet().toArray(new Integer[this.tiles.size()]);
            Arrays.sort(t);
            Vector<Integer> tmpOffsets = new Vector<Integer>();
            Vector<String> tmpFiles = new Vector<String>();
            int index = 0;
            for (Object key : t) {
                int nTiles = (Integer)this.tiles.get(key);
                if (nTiles < this.getImageCount()) {
                    this.tiles.remove(key);
                } else {
                    for (int p = 0; p < nTiles; ++p) {
                        tmpOffsets.add(new Integer(this.offsets[index + p]));
                        tmpFiles.add(this.imageFiles[index + p]);
                    }
                }
                index += nTiles;
            }
            this.offsets = new int[tmpOffsets.size()];
            for (int i = 0; i < this.offsets.length; ++i) {
                this.offsets[i] = (Integer)tmpOffsets.get(i);
            }
            this.imageFiles = tmpFiles.toArray(new String[tmpFiles.size()]);
        }
    }

    protected void fillMetadataPass5(MetadataStore store) throws FormatException, IOException {
        super.fillMetadataPass5(store);
        for (String name : this.tagsToParse) {
            int imageNum = this.getImageNumber(name, -1);
            this.parseTags(imageNum, name, store);
        }
    }

    protected void countImages() {
        this.files = this.poi.getDocumentList().toArray(new String[0]);
        Arrays.sort(this.files, new Comparator(){

            public int compare(Object o1, Object o2) {
                int n1 = ZeissZVIReader.this.getImageNumber((String)o1, -1);
                int n2 = ZeissZVIReader.this.getImageNumber((String)o2, -1);
                return new Integer(n1).compareTo(new Integer(n2));
            }
        });
        this.core[0].imageCount = 0;
        for (String file2 : this.files) {
            int imageNumber;
            String uname = file2.toUpperCase();
            if (!(uname = uname.substring(uname.indexOf(File.separator) + 1)).endsWith("CONTENTS") || !uname.startsWith("IMAGE") && uname.indexOf("ITEM") == -1 || this.poi.getFileSize(file2) <= 1024 || (imageNumber = this.getImageNumber(file2, 0)) < this.getImageCount()) continue;
            ++this.core[0].imageCount;
        }
        super.countImages();
    }

    private int getImageNumber(String dirName, int defaultNumber) {
        if (dirName.toUpperCase().indexOf("ITEM") != -1) {
            int open = dirName.indexOf("(");
            int close = dirName.indexOf(")");
            if (open < 0 || close < 0 || close < open) {
                return defaultNumber;
            }
            return Integer.parseInt(dirName.substring(open + 1, close));
        }
        return defaultNumber;
    }

    private String getNextTag(RandomAccessInputStream s) throws IOException {
        short type = s.readShort();
        switch (type) {
            case 0: 
            case 1: {
                return "";
            }
            case 2: {
                return String.valueOf(s.readShort());
            }
            case 3: 
            case 22: 
            case 23: {
                return String.valueOf(s.readInt());
            }
            case 4: {
                return String.valueOf(s.readFloat());
            }
            case 5: {
                return String.valueOf(s.readDouble());
            }
            case 7: 
            case 20: 
            case 21: {
                return String.valueOf(s.readLong());
            }
            case 8: 
            case 69: {
                int len = s.readInt();
                return s.readString(len);
            }
            case 9: 
            case 13: {
                s.skipBytes(16);
                return "";
            }
            case 63: 
            case 65: {
                int len = s.readInt();
                s.skipBytes(len);
                return "";
            }
            case 66: {
                short len = s.readShort();
                return s.readString(len);
            }
        }
        long old = s.getFilePointer();
        while (s.readShort() != 3 && s.getFilePointer() + 2L < s.length()) {
        }
        long fp = s.getFilePointer() - 2L;
        s.seek(old - 2L);
        return s.readString((int)(fp - old + 2L));
    }

    private void parseTags(int image, String file2, MetadataStore store) throws FormatException, IOException {
        ArrayList<BaseZeissReader.Tag> tags = new ArrayList<BaseZeissReader.Tag>();
        RandomAccessInputStream s = this.poi.getDocumentStream(file2);
        s.order(true);
        s.seek(8L);
        int count = s.readInt();
        for (int i = 0; i < count && s.getFilePointer() + 2L < s.length(); ++i) {
            String value = DataTools.stripString(this.getNextTag(s));
            s.skipBytes(2);
            int tagID = s.readInt();
            s.skipBytes(6);
            tags.add(new BaseZeissReader.Tag(tagID, value, BaseZeissReader.Context.MAIN));
        }
        this.parseMainTags(image, store, tags);
        s.close();
    }

    private void parseROIs(int imageNum, String name, MetadataStore store) throws IOException {
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        if (level == MetadataLevel.MINIMUM || level == MetadataLevel.NO_OVERLAYS) {
            return;
        }
        RandomAccessInputStream s = this.poi.getDocumentStream(name);
        s.order(true);
        Vector<Long> roiOffsets = new Vector<Long>();
        s.seek(0L);
        while (s.getFilePointer() < s.length() - 8L) {
            long signature = s.readLong() & 0xFFFFFFFFFFFFFFFFL;
            while (signature != 2449947852680921101L && s.getFilePointer() < s.length()) {
                s.seek(s.getFilePointer() - 6L);
                signature = s.readLong() & 0xFFFFFFFFFFFFFFFFL;
            }
            if (s.getFilePointer() >= s.length()) continue;
            roiOffsets.add(new Long(s.getFilePointer()));
        }
        BaseZeissReader.Layer nlayer = new BaseZeissReader.Layer();
        for (int shape = 0; shape < roiOffsets.size(); ++shape) {
            BaseZeissReader.Shape nshape = new BaseZeissReader.Shape();
            s.seek((Long)roiOffsets.get(shape) + 18L);
            int length = s.readInt();
            s.skipBytes(length + 10);
            nshape.type = BaseZeissReader.FeatureType.get(s.readInt());
            s.skipBytes(8);
            nshape.x1 = s.readInt();
            nshape.y1 = s.readInt();
            nshape.x2 = s.readInt();
            nshape.y2 = s.readInt();
            nshape.width = nshape.x2 - nshape.x1;
            nshape.height = nshape.y2 - nshape.y1;
            long nextOffset = shape < roiOffsets.size() - 1 ? ((Long)roiOffsets.get(shape + 1)).longValue() : s.length();
            long nameBlock = s.getFilePointer();
            long fontBlock = s.getFilePointer();
            long lastBlock = s.getFilePointer();
            while (s.getFilePointer() < nextOffset - 1L) {
                while (s.readShort() != 8 && s.getFilePointer() < nextOffset) {
                }
                if (s.getFilePointer() >= nextOffset || s.getFilePointer() - lastBlock > 64L && lastBlock != fontBlock) break;
                nameBlock = fontBlock;
                fontBlock = lastBlock;
                lastBlock = s.getFilePointer();
            }
            s.seek(nameBlock);
            int strlen = s.readInt();
            if ((long)strlen + s.getFilePointer() > s.length()) continue;
            nshape.name = DataTools.stripString(s.readString(strlen));
            s.seek(fontBlock);
            int fontLength = s.readInt();
            nshape.fontName = DataTools.stripString(s.readString(fontLength));
            s.skipBytes(2);
            int typeLength = s.readInt();
            s.skipBytes(typeLength);
            s.skipBytes(10);
            nshape.pointCount = s.readInt();
            nshape.points = new double[nshape.pointCount * 2];
            s.skipBytes(6);
            for (int p = 0; p < nshape.pointCount; ++p) {
                nshape.points[p * 2] = s.readDouble();
                nshape.points[p * 2 + 1] = s.readDouble();
            }
            nlayer.shapes.add(nshape);
        }
        this.layers.add(nlayer);
        s.close();
    }
}

