/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class SeikoReader
extends FormatReader {
    private static final int HEADER_SIZE = 2944;

    public SeikoReader() {
        super("Seiko", new String[]{"xqd", "xqf"});
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(2944L);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.core[0].littleEndian = true;
        this.in.order(this.isLittleEndian());
        String comment = null;
        double xSize = 0.0;
        double ySize = 0.0;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.in.seek(40L);
            comment = this.in.readCString();
            this.in.seek(156L);
            xSize = this.in.readFloat();
            this.in.skipBytes(4);
            ySize = this.in.readFloat();
            this.addGlobalMeta("Comment", comment);
        }
        this.in.seek(1402L);
        this.core[0].sizeX = this.in.readShort();
        this.core[0].sizeY = this.in.readShort();
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].pixelType = 3;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(comment, 0);
            if (xSize > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(xSize), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", (Object)xSize);
            }
            if (ySize > 0.0) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(ySize), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", (Object)ySize);
            }
        }
    }
}

