/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.Timestamp;

public class OxfordInstrumentsReader
extends FormatReader {
    public static final String OXFORD_MAGIC_STRING = "Oxford Instruments";
    private long headerSize = 0L;

    public OxfordInstrumentsReader() {
        super(OXFORD_MAGIC_STRING, "top");
        this.suffixNecessary = false;
        this.domains = new String[]{"Scanning Probe Microscopy (SPM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = OXFORD_MAGIC_STRING.length();
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        return stream.readString(blockLen).equals(OXFORD_MAGIC_STRING);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.headerSize);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.core[0].littleEndian = true;
        this.in.order(this.isLittleEndian());
        this.in.seek(48L);
        String comment = this.in.readString(32);
        String dateTime = this.readDate();
        this.in.skipBytes(8);
        double xSize = -this.in.readFloat() + this.in.readFloat();
        this.in.skipBytes(20);
        double ySize = -this.in.readFloat() + this.in.readFloat();
        this.in.skipBytes(24);
        double zMin = this.in.readFloat();
        double zMax = this.in.readFloat();
        this.in.skipBytes(864);
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        this.in.skipBytes(28);
        if (this.getSizeX() == 0 && this.getSizeY() == 0) {
            this.core[0].sizeX = this.in.readInt();
            this.core[0].sizeY = this.in.readInt();
            this.in.skipBytes(196);
        } else {
            this.in.skipBytes(204);
        }
        this.core[0].pixelType = 3;
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].rgb = false;
        this.core[0].indexed = false;
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].interleaved = false;
        if ((long)FormatTools.getPlaneSize(this) + this.in.getFilePointer() > this.in.length()) {
            this.core[0].sizeY = 1;
        }
        int lutSize = this.in.readInt();
        this.in.skipBytes(lutSize);
        this.headerSize = this.in.getFilePointer();
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.in.skipBytes(FormatTools.getPlaneSize(this));
            int nMetadataStrings = this.in.readInt();
            for (int i = 0; i < nMetadataStrings; ++i) {
                int length = this.in.readInt();
                String s = this.in.readString(length);
                if (s.indexOf(":") == -1) continue;
                String key = s.substring(0, s.indexOf(":")).trim();
                String value = s.substring(s.indexOf(":") + 1).trim();
                if (value.equals("-")) continue;
                this.addGlobalMeta(key, value);
            }
            this.addGlobalMeta("Description", comment);
            this.addGlobalMeta("Acquisition date", dateTime);
            this.addGlobalMeta("X size (um)", xSize);
            this.addGlobalMeta("Y size (um)", ySize);
            this.addGlobalMeta("Z minimum (um)", zMin);
            this.addGlobalMeta("Z maximum (um)", zMax);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageDescription(comment, 0);
        if (dateTime != null) {
            store.setImageAcquisitionDate(new Timestamp(dateTime), 0);
        }
        double physicalSizeX = xSize / (double)this.getSizeX();
        double physicalSizeY = ySize / (double)this.getSizeY();
        if (physicalSizeX > 0.0) {
            store.setPixelsPhysicalSizeX(new PositiveFloat(physicalSizeX), 0);
        } else {
            LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", (Object)physicalSizeX);
        }
        if (physicalSizeY > 0.0) {
            store.setPixelsPhysicalSizeY(new PositiveFloat(physicalSizeY), 0);
        } else {
            LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", (Object)physicalSizeY);
        }
    }

    private String readDate() throws IOException {
        StringBuffer dateTime = new StringBuffer();
        dateTime.append(String.valueOf(this.in.readInt()));
        dateTime.append("-");
        int month = this.in.readInt();
        dateTime.append(String.format("%02d", month));
        dateTime.append("-");
        int day = this.in.readInt();
        dateTime.append(String.format("%02d", day));
        dateTime.append("T");
        int hour = this.in.readInt();
        dateTime.append(String.format("%02d", hour));
        dateTime.append(":");
        int minute = this.in.readInt();
        dateTime.append(String.format("%02d", minute));
        dateTime.append(":");
        this.in.skipBytes(4);
        float scanTime = (float)this.in.readInt() / 100.0f;
        dateTime.append(String.format("%02d", (int)scanTime));
        this.addGlobalMeta("Scan time (s)", scanTime);
        return dateTime.toString();
    }
}

