/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;
import loci.common.CBZip2InputStream;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.codec.Base64Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class OMEXMLReader
extends FormatReader {
    private static boolean noOME = false;
    private Vector<BinData> binData;
    private Vector<Long> binDataOffsets;
    private Vector<String> compression;
    private String omexml;
    private boolean hasSPW = false;

    public OMEXMLReader() {
        super("OME-XML", "ome");
        this.domains = FormatTools.NON_GRAPHICS_DOMAINS;
        this.suffixNecessary = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 64;
        String xml = stream.readString(64);
        return xml.startsWith("<?xml") && xml.indexOf("<OME") >= 0;
    }

    public String[] getDomains() {
        String[] stringArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.hasSPW) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "High-Content Screening (HCS)";
        } else {
            stringArray = FormatTools.NON_SPECIAL_DOMAINS;
        }
        return stringArray;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int index = no;
        for (int i = 0; i < this.series; ++i) {
            index += this.core[i].imageCount;
        }
        if (index >= this.binDataOffsets.size()) {
            index = this.binDataOffsets.size() - 1;
        }
        long offset = this.binDataOffsets.get(index);
        String compress = this.compression.get(index);
        this.in.seek(offset);
        int depth = FormatTools.getBytesPerPixel(this.getPixelType());
        int planeSize = this.getSizeX() * this.getSizeY() * depth;
        CodecOptions options = new CodecOptions();
        options.width = this.getSizeX();
        options.height = this.getSizeY();
        options.bitsPerSample = depth * 8;
        options.channels = this.getRGBChannelCount();
        options.maxBytes = planeSize;
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isInterleaved();
        byte[] pixels = new Base64Codec().decompress(this.in, options);
        if (pixels.length == 0) {
            LOGGER.debug("No pixel data for plane #{}", (Object)no);
            return buf;
        }
        if (compress.equals("bzip2")) {
            byte[] tempPixels = pixels;
            pixels = new byte[tempPixels.length - 2];
            System.arraycopy(tempPixels, 2, pixels, 0, pixels.length);
            ByteArrayInputStream bais = new ByteArrayInputStream(pixels);
            CBZip2InputStream bzip = new CBZip2InputStream(bais);
            pixels = new byte[planeSize];
            bzip.read(pixels, 0, pixels.length);
            tempPixels = null;
            bais.close();
            bais = null;
            bzip = null;
        } else if (compress.equals("zlib")) {
            pixels = new ZlibCodec().decompress(pixels, options);
        } else if (compress.equals("J2K")) {
            pixels = new JPEG2000Codec().decompress(pixels, options);
        } else if (compress.equals("JPEG")) {
            pixels = new JPEGCodec().decompress(pixels, options);
        }
        for (int row = 0; row < h; ++row) {
            int off = (row + y) * this.getSizeX() * depth + x * depth;
            System.arraycopy(pixels, off, buf, row * w * depth, w * depth);
        }
        pixels = null;
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.compression = null;
            this.binDataOffsets = null;
            this.binData = null;
            this.omexml = null;
            this.hasSPW = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        OMEXMLMetadata omexmlMeta;
        OMEXMLService service;
        if (noOME) {
            throw new MissingLibraryException("ome-xml.jar is required to read OME-TIFF files.  Please download it from http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html");
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.binData = new Vector();
        this.binDataOffsets = new Vector();
        this.compression = new Vector();
        OMEXMLHandler handler = new OMEXMLHandler();
        try {
            RandomAccessInputStream s = new RandomAccessInputStream(id);
            XMLTools.parseXML(s, (DefaultHandler)handler);
            s.close();
        }
        catch (IOException e) {
            throw new FormatException("Malformed OME-XML", e);
        }
        int lineNumber = 1;
        for (BinData bin : this.binData) {
            int line = bin.getRow();
            int col = bin.getColumn();
            while (lineNumber < line) {
                this.in.readLine();
                ++lineNumber;
            }
            this.binDataOffsets.add(this.in.getFilePointer() + (long)col - 1L);
        }
        if (this.binDataOffsets.size() == 0) {
            throw new FormatException("Pixel data not found");
        }
        LOGGER.info("Populating metadata");
        try {
            ServiceFactory factory = new ServiceFactory();
            service = factory.getInstance(OMEXMLService.class);
            omexmlMeta = service.createOMEXMLMetadata(this.omexml);
        }
        catch (DependencyException de) {
            throw new MissingLibraryException("ome-xml.jar is required to read OME-TIFF files.  Please download it from http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html", de);
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        this.hasSPW = omexmlMeta.getPlateCount() > 0;
        this.addGlobalMeta("Is SPW file", this.hasSPW);
        int numDatasets = omexmlMeta.getImageCount();
        this.core = new CoreMetadata[numDatasets];
        int oldSeries = this.getSeries();
        for (int i = 0; i < numDatasets; ++i) {
            this.setSeries(i);
            this.core[i] = new CoreMetadata();
            Integer w = (Integer)omexmlMeta.getPixelsSizeX(i).getValue();
            Integer h = (Integer)omexmlMeta.getPixelsSizeY(i).getValue();
            Integer t = (Integer)omexmlMeta.getPixelsSizeT(i).getValue();
            Integer z = (Integer)omexmlMeta.getPixelsSizeZ(i).getValue();
            Integer c = (Integer)omexmlMeta.getPixelsSizeC(i).getValue();
            if (w == null || h == null || t == null || z == null | c == null) {
                throw new FormatException("Image dimensions not found");
            }
            Boolean endian = omexmlMeta.getPixelsBinDataBigEndian(i, 0);
            String pixType = omexmlMeta.getPixelsType(i).toString();
            this.core[i].dimensionOrder = omexmlMeta.getPixelsDimensionOrder(i).toString();
            this.core[i].sizeX = w;
            this.core[i].sizeY = h;
            this.core[i].sizeT = t;
            this.core[i].sizeZ = z;
            this.core[i].sizeC = c;
            this.core[i].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            this.core[i].littleEndian = endian == null ? false : endian == false;
            this.core[i].rgb = false;
            this.core[i].interleaved = false;
            this.core[i].indexed = false;
            this.core[i].falseColor = true;
            this.core[i].pixelType = FormatTools.pixelTypeFromString(pixType);
            this.core[i].orderCertain = true;
        }
        this.setSeries(oldSeries);
        MetadataStore store = this.getMetadataStore();
        MetadataTools.populatePixels(store, this);
        service.convertMetadata(omexmlMeta, store);
    }

    static {
        try {
            Class.forName("ome.xml.OMEXMLNode");
        }
        catch (Throwable t) {
            noOME = true;
            LOGGER.debug("ome-xml.jar is required to read OME-TIFF files.  Please download it from http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html", t);
        }
    }

    class BinData {
        private int row;
        private int column;

        public BinData(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }
    }

    class OMEXMLHandler
    extends BaseHandler {
        private StringBuffer xmlBuffer = new StringBuffer();
        private String currentQName;
        private Locator locator;

        public void characters(char[] ch, int start, int length) {
            if (this.currentQName.indexOf("BinData") < 0) {
                this.xmlBuffer.append(new String(ch, start, length));
            }
        }

        public void endElement(String uri, String localName, String qName) {
            this.xmlBuffer.append("</");
            this.xmlBuffer.append(qName);
            this.xmlBuffer.append(">");
        }

        public void startElement(String ur, String localName, String qName, Attributes attributes) {
            this.currentQName = qName;
            if (qName.indexOf("BinData") == -1) {
                this.xmlBuffer.append("<");
                this.xmlBuffer.append(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String key = XMLTools.escapeXML(attributes.getQName(i));
                    String value = XMLTools.escapeXML(attributes.getValue(i));
                    if (key.equals("BigEndian")) {
                        String endian = value.toLowerCase();
                        if (!endian.equals("true") && !endian.equals("false")) {
                            if (endian.startsWith("t")) {
                                endian = "true";
                            } else if (endian.startsWith("f")) {
                                endian = "false";
                            }
                        }
                        value = endian;
                    }
                    this.xmlBuffer.append(" ");
                    this.xmlBuffer.append(key);
                    this.xmlBuffer.append("=\"");
                    this.xmlBuffer.append(value);
                    this.xmlBuffer.append("\"");
                }
                this.xmlBuffer.append(">");
            } else {
                OMEXMLReader.this.binData.add(new BinData(this.locator.getLineNumber(), this.locator.getColumnNumber()));
                String compress = attributes.getValue("Compression");
                OMEXMLReader.this.compression.add(compress == null ? "" : compress);
                this.xmlBuffer.append("<");
                this.xmlBuffer.append(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String key = XMLTools.escapeXML(attributes.getQName(i));
                    String value = XMLTools.escapeXML(attributes.getValue(i));
                    if (key.equals("Length")) {
                        value = "0";
                    }
                    this.xmlBuffer.append(" ");
                    this.xmlBuffer.append(key);
                    this.xmlBuffer.append("=\"");
                    this.xmlBuffer.append(value);
                    this.xmlBuffer.append("\"");
                }
                this.xmlBuffer.append(">");
            }
        }

        public void endDocument() {
            OMEXMLReader.this.omexml = this.xmlBuffer.toString();
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }
}

