/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.codec.JPEGTileDecoder;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.Timestamp;

public class NDPIReader
extends BaseTiffReader {
    private static final int MAX_SIZE = 8192;
    private static final int THUMB_TAG_1 = 65426;
    private static final int THUMB_TAG_2 = 65439;
    private static final int METADATA_TAG = 65449;
    private JPEGTileDecoder decoder;
    private int initializedSeries = -1;
    private int initializedPlane = -1;
    private int sizeZ = 1;
    private int pyramidHeight = 1;

    public NDPIReader() {
        super("Hamamatsu NDPI", new String[]{"ndpi"});
        this.domains = new String[]{"Histology"};
        this.suffixNecessary = true;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (x == 0 && y == 0 && w == 1 && h == 1) {
            return buf;
        }
        if (this.getSizeX() <= 8192 && this.getSizeY() <= 8192) {
            int ifdIndex = this.getIFDIndex(this.getCoreIndex(), no);
            this.in = new RandomAccessInputStream(this.currentId);
            this.tiffParser = new TiffParser(this.in);
            this.tiffParser.setUse64BitOffsets(true);
            this.tiffParser.setYCbCrCorrection(false);
            return this.tiffParser.getSamples((IFD)this.ifds.get(ifdIndex), buf, x, y, w, h);
        }
        if (this.initializedSeries != this.getCoreIndex() || this.initializedPlane != no) {
            if (x == 0 && y == 0 && w == this.getOptimalTileWidth() && h == this.getOptimalTileHeight()) {
                this.setupService(0, 0, no);
            } else {
                this.setupService(y, h, no);
            }
            this.initializedSeries = this.getCoreIndex();
            this.initializedPlane = no;
        } else if (this.decoder.getScanline(y) == null) {
            this.setupService(y, h, no);
        }
        int c = this.getRGBChannelCount();
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int row = w * c * bytes;
        for (int yy = y; yy < y + h; ++yy) {
            byte[] scanline = this.decoder.getScanline(yy);
            if (scanline == null) continue;
            int copy = Math.min(row, buf.length - (yy - y) * row - 1);
            if (copy < 0) break;
            System.arraycopy(scanline, x * c * bytes, buf, (yy - y) * row, copy);
        }
        return buf;
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int currentSeries = this.getSeries();
        if (this.getCoreIndex() >= this.pyramidHeight) {
            return super.openThumbBytes(no);
        }
        int thumbX = this.getThumbSizeX();
        int thumbY = this.getThumbSizeY();
        int rgbCount = this.getRGBChannelCount();
        if (this.hasFlattenedResolutions()) {
            this.setSeries(this.pyramidHeight - 1);
        } else {
            this.setResolution(this.pyramidHeight - 1);
        }
        byte[] thumb = null;
        if (thumbX == this.getThumbSizeX() && thumbY == this.getThumbSizeY() && rgbCount == this.getRGBChannelCount()) {
            thumb = FormatTools.openThumbBytes(this, no);
            this.setSeries(currentSeries);
            this.setResolution(0);
        } else {
            for (int s = this.getSeriesCount() - 1; s >= 0; --s) {
                this.setSeries(s);
                if (thumbX != this.getThumbSizeX() || thumbY != this.getThumbSizeY() || s == currentSeries || rgbCount != this.getRGBChannelCount()) continue;
                thumb = FormatTools.openThumbBytes(this, no);
                break;
            }
            this.setSeries(currentSeries);
            if (thumb == null) {
                thumb = FormatTools.openThumbBytes(this, no);
            }
        }
        return thumb;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.decoder != null) {
                this.decoder.close();
            }
            this.decoder = null;
            this.initializedSeries = -1;
            this.initializedPlane = -1;
            this.sizeZ = 1;
            this.pyramidHeight = 1;
        }
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int maxHeight = 0x100000 / (this.getSizeX() * this.getRGBChannelCount() * bpp);
        return Math.min(maxHeight, this.getSizeY());
    }

    protected void initFile(String id) throws FormatException, IOException {
        RandomAccessInputStream s = new RandomAccessInputStream(id);
        this.use64Bit = (double)s.length() >= Math.pow(2.0, 32.0);
        s.close();
        super.initFile(id);
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        int s;
        int i;
        super.initStandardMetadata();
        this.decoder = new JPEGTileDecoder();
        this.ifds = this.tiffParser.getIFDs();
        RandomAccessInputStream stream = new RandomAccessInputStream(this.currentId);
        for (i = 0; i < this.ifds.size(); ++i) {
            long[] stripOffsets = ((IFD)this.ifds.get(i)).getStripOffsets();
            boolean neededAdjustment = false;
            for (int j = 0; j < stripOffsets.length; ++j) {
                long newOffset = stripOffsets[j] + 0x100000000L;
                if (newOffset >= stream.length()) continue;
                stripOffsets[j] = newOffset;
                neededAdjustment = true;
            }
            if (!neededAdjustment) continue;
            ((IFD)this.ifds.get(i)).putIFDValue(273, stripOffsets);
        }
        stream.close();
        for (i = 1; i < this.ifds.size(); ++i) {
            IFD ifd = (IFD)this.ifds.get(i);
            if (ifd.getImageWidth() == ((IFD)this.ifds.get(0)).getImageWidth() && ifd.getImageLength() == ((IFD)this.ifds.get(0)).getImageLength()) {
                ++this.sizeZ;
                continue;
            }
            if (this.sizeZ != 1) continue;
            ++this.pyramidHeight;
        }
        int seriesCount = this.pyramidHeight + (this.ifds.size() - this.pyramidHeight * this.sizeZ);
        this.core = new CoreMetadata[seriesCount];
        for (int i2 = 0; i2 < this.ifds.size(); ++i2) {
            IFD ifd = (IFD)this.ifds.get(i2);
            ifd.remove(65426);
            ifd.remove(65439);
            this.ifds.set(i2, ifd);
            this.tiffParser.fillInIFD((IFD)this.ifds.get(i2));
            int[] bpp = ((IFD)this.ifds.get(i2)).getBitsPerSample();
            for (int q = 0; q < bpp.length; ++q) {
                if (bpp[q] >= 8) continue;
                bpp[q] = 8;
            }
            ((IFD)this.ifds.get(i2)).putIFDValue(258, bpp);
        }
        for (s = 0; s < this.core.length; ++s) {
            this.core[s] = new CoreMetadata();
            if (s != 0 || this.hasFlattenedResolutions()) continue;
            this.core[s].resolutionCount = this.pyramidHeight;
        }
        for (s = 0; s < this.core.length; ++s) {
            IFD ifd = (IFD)this.ifds.get(this.getIFDIndex(s, 0));
            PhotoInterp p = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            this.core[s].rgb = samples > 1 || p == PhotoInterp.RGB;
            this.core[s].sizeX = (int)ifd.getImageWidth();
            this.core[s].sizeY = (int)ifd.getImageLength();
            this.core[s].sizeZ = s < this.pyramidHeight ? this.sizeZ : 1;
            this.core[s].sizeT = 1;
            this.core[s].sizeC = this.core[s].rgb ? samples : 1;
            this.core[s].littleEndian = ifd.isLittleEndian();
            this.core[s].indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            this.core[s].imageCount = this.core[s].sizeZ * this.core[s].sizeT;
            this.core[s].pixelType = ifd.getPixelType();
            this.core[s].metadataComplete = true;
            this.core[s].interleaved = this.core[s].sizeX > 8192 || this.core[s].sizeY > 8192;
            this.core[s].falseColor = false;
            this.core[s].dimensionOrder = "XYCZT";
            this.core[s].thumbnail = s != 0;
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
            if (i <= 0) continue;
            int ifdIndex = this.getIFDIndex(i, 0);
            String creationDate = ((IFD)this.ifds.get(ifdIndex)).getIFDTextValue(306);
            if ((creationDate = DateTools.formatDate(creationDate, DATE_FORMATS)) != null) {
                store.setImageAcquisitionDate(new Timestamp(creationDate), i);
            }
            double xResolution = ((IFD)this.ifds.get(ifdIndex)).getXResolution();
            double yResolution = ((IFD)this.ifds.get(ifdIndex)).getYResolution();
            if (xResolution > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(xResolution), i);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", (Object)xResolution);
            }
            if (yResolution > 0.0) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(yResolution), i);
                continue;
            }
            LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", (Object)yResolution);
        }
    }

    private void setupService(int y, int h, int z) throws FormatException, IOException {
        this.decoder.close();
        IFD ifd = (IFD)this.ifds.get(this.getIFDIndex(this.getCoreIndex(), z));
        long offset = ifd.getStripOffsets()[0];
        int byteCount = (int)ifd.getStripByteCounts()[0];
        if (this.in != null) {
            this.in.close();
        }
        this.in = new RandomAccessInputStream(this.currentId);
        this.in.seek(offset);
        this.in.setLength(offset + (long)byteCount);
        this.decoder.initialize(this.in, y, h, this.getSizeX());
    }

    private int getIFDIndex(int seriesIndex, int zIndex) {
        if (seriesIndex < this.pyramidHeight) {
            return zIndex * this.pyramidHeight + seriesIndex;
        }
        return this.sizeZ * this.pyramidHeight + (seriesIndex - this.pyramidHeight);
    }
}

