/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.math.BigInteger;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class MRCReader
extends FormatReader {
    private static final String[] TYPES = new String[]{"mono", "tilt", "tilts", "lina", "lins"};
    private static final String[] MRC_SUFFIXES = new String[]{"mrc", "st", "ali", "map", "rec"};
    private static final int HEADER_SIZE = 1024;
    private static final int ENDIANNESS_OFFSET = 212;
    private int extHeaderSize = 0;

    public MRCReader() {
        super("Medical Research Council", MRC_SUFFIXES);
        this.domains = new String[]{"Medical Imaging", "Light Microscopy"};
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return FormatTools.validStream(stream, 1024, false);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        long planeSize = FormatTools.getPlaneSize(this);
        long offset = (long)(1024 + this.extHeaderSize) + (long)no * planeSize;
        if (offset + planeSize <= this.in.length() && offset >= 0L) {
            this.in.seek(offset);
            this.readPlane(this.in, x, this.getSizeY() - h - y, w, h, buf);
            byte[] tmp = new byte[w * FormatTools.getBytesPerPixel(this.getPixelType())];
            for (int row = 0; row < h / 2; ++row) {
                int src = row * tmp.length;
                int dest = (h - row - 1) * tmp.length;
                System.arraycopy(buf, src, tmp, 0, tmp.length);
                System.arraycopy(buf, dest, buf, src, tmp.length);
                System.arraycopy(tmp, 0, buf, dest, tmp.length);
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.extHeaderSize = 0;
        }
    }

    public void initFile(String id) throws FormatException, IOException {
        double pixelTypeMax;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        LOGGER.info("Reading header");
        this.in.seek(212L);
        this.core[0].littleEndian = this.in.read() == 68;
        this.in.seek(0L);
        this.in.order(this.isLittleEndian());
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        this.core[0].sizeZ = this.in.readInt();
        BigInteger v = BigInteger.valueOf(this.getSizeX());
        v = v.multiply(BigInteger.valueOf(this.getSizeY()));
        v = v.multiply(BigInteger.valueOf(this.getSizeZ()));
        if (this.getSizeX() < 0 || this.getSizeY() < 0 || this.getSizeZ() < 0 || v.compareTo(BigInteger.valueOf(this.in.length())) > 0) {
            LOGGER.debug("Detected endianness is wrong, swapping");
            this.core[0].littleEndian = !this.isLittleEndian();
            this.in.seek(0L);
            this.in.order(this.isLittleEndian());
            this.core[0].sizeX = this.in.readInt();
            this.core[0].sizeY = this.in.readInt();
            this.core[0].sizeZ = this.in.readInt();
        }
        this.core[0].sizeC = 1;
        int mode = this.in.readInt();
        switch (mode) {
            case 0: {
                this.core[0].pixelType = 1;
                break;
            }
            case 1: {
                this.core[0].pixelType = 2;
                break;
            }
            case 6: {
                this.core[0].pixelType = 3;
                break;
            }
            case 2: {
                this.core[0].pixelType = 6;
                break;
            }
            case 3: {
                this.core[0].pixelType = 5;
                break;
            }
            case 4: {
                this.core[0].pixelType = 7;
                break;
            }
            case 16: {
                this.core[0].sizeC = 3;
                this.core[0].pixelType = 3;
            }
        }
        this.in.skipBytes(12);
        double xSize = 0.0;
        double ySize = 0.0;
        double zSize = 0.0;
        if (level != MetadataLevel.MINIMUM) {
            int mx = this.in.readInt();
            int my = this.in.readInt();
            int mz = this.in.readInt();
            xSize = (double)(this.in.readFloat() / (float)mx) / 10000.0;
            ySize = (double)(this.in.readFloat() / (float)my) / 10000.0;
            zSize = (double)(this.in.readFloat() / (float)mz) / 10000.0;
            this.addGlobalMeta("Pixel size (X)", xSize);
            this.addGlobalMeta("Pixel size (Y)", ySize);
            this.addGlobalMeta("Pixel size (Z)", zSize);
            this.addGlobalMeta("Alpha angle", this.in.readFloat());
            this.addGlobalMeta("Beta angle", this.in.readFloat());
            this.addGlobalMeta("Gamma angle", this.in.readFloat());
            this.in.skipBytes(12);
        } else {
            this.in.skipBytes(48);
        }
        double minValue = this.in.readFloat();
        double maxValue = this.in.readFloat();
        this.addGlobalMeta("Minimum pixel value", minValue);
        this.addGlobalMeta("Maximum pixel value", maxValue);
        this.addGlobalMeta("Mean pixel value", this.in.readFloat());
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        double range = Math.pow(2.0, bytes * 8) - 1.0;
        double pixelTypeMin = 0.0;
        boolean signed = FormatTools.isSigned(this.getPixelType());
        if (signed) {
            pixelTypeMin -= range / 2.0;
        }
        if ((pixelTypeMax = pixelTypeMin + range) < maxValue || pixelTypeMin > minValue && signed) {
            switch (this.getPixelType()) {
                case 0: {
                    this.core[0].pixelType = 1;
                    break;
                }
                case 2: {
                    this.core[0].pixelType = 3;
                    break;
                }
                case 4: {
                    this.core[0].pixelType = 5;
                }
            }
        }
        this.in.skipBytes(4);
        this.extHeaderSize = this.in.readInt();
        if (level != MetadataLevel.MINIMUM) {
            int i;
            this.in.skipBytes(64);
            short idtype = this.in.readShort();
            String type = "unknown";
            if (idtype >= 0 && idtype < TYPES.length) {
                type = TYPES[idtype];
            }
            this.addGlobalMeta("Series type", type);
            this.addGlobalMeta("Lens", this.in.readShort());
            this.addGlobalMeta("ND1", this.in.readShort());
            this.addGlobalMeta("ND2", this.in.readShort());
            this.addGlobalMeta("VD1", this.in.readShort());
            this.addGlobalMeta("VD2", this.in.readShort());
            for (i = 0; i < 6; ++i) {
                this.addGlobalMeta("Angle " + (i + 1), this.in.readFloat());
            }
            this.in.skipBytes(24);
            this.addGlobalMeta("Number of useful labels", this.in.readInt());
            for (i = 0; i < 10; ++i) {
                this.addGlobalMeta("Label " + (i + 1), this.in.readString(80));
            }
        }
        LOGGER.info("Populating metadata");
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYZTC";
        this.core[0].imageCount = this.getSizeZ();
        this.core[0].rgb = false;
        this.core[0].interleaved = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (level != MetadataLevel.MINIMUM) {
            if (xSize - 1.0E-6 > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(xSize), 0);
            } else {
                LOGGER.warn("xSize {} not a positive float skipping", (Object)xSize);
            }
            if (ySize - 1.0E-6 > 0.0) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(ySize), 0);
            } else {
                LOGGER.warn("ySize {} not a positive float skipping", (Object)ySize);
            }
            if (zSize - 1.0E-6 > 0.0) {
                store.setPixelsPhysicalSizeZ(new PositiveFloat(zSize), 0);
            } else {
                LOGGER.warn("zSize {} not a positive float skipping", (Object)zSize);
            }
        }
    }
}

