/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.Timestamp;

public class LiFlimReader
extends FormatReader {
    public static final String INFO_TABLE = "FLIMIMAGE: INFO";
    public static final String LAYOUT_TABLE = "FLIMIMAGE: LAYOUT";
    public static final String BACKGROUND_TABLE = "FLIMIMAGE: BACKGROUND";
    public static final String VERSION_KEY = "version";
    public static final String COMPRESSION_KEY = "compression";
    public static final String DATATYPE_KEY = "datatype";
    public static final String C_KEY = "channels";
    public static final String X_KEY = "x";
    public static final String Y_KEY = "y";
    public static final String Z_KEY = "z";
    public static final String P_KEY = "phases";
    public static final String F_KEY = "frequencies";
    public static final String T_KEY = "timestamps";
    public static final String TIMESTAMP_KEY = "FLIMIMAGE: TIMESTAMPS - t";
    public static final String[] KNOWN_VERSIONS = new String[]{"1.0"};
    public static final String COMPRESSION_NONE = "0";
    public static final String COMPRESSION_GZIP = "1";
    public static final String DATATYPE_UINT8 = "UINT8";
    public static final String DATATYPE_INT8 = "INT8";
    public static final String DATATYPE_UINT16 = "UINT16";
    public static final String DATATYPE_INT16 = "INT16";
    public static final String DATATYPE_UINT32 = "UINT32";
    public static final String DATATYPE_INT32 = "INT32";
    public static final String DATATYPE_REAL32 = "REAL32";
    public static final String DATATYPE_REAL64 = "REAL64";
    private long dataOffset;
    private IniList ini;
    private String version;
    private String compression;
    private String datatype;
    private String channels;
    private String xLen;
    private String yLen;
    private String zLen;
    private String phases;
    private String frequencies;
    private String timestamps;
    private String backgroundDatatype;
    private String backgroundX;
    private String backgroundY;
    private String backgroundC;
    private String backgroundZ;
    private String backgroundT;
    private String backgroundP;
    private String backgroundF;
    private int numRegions = 0;
    private Hashtable<Integer, ROI> rois;
    private Hashtable<Integer, String> stampValues;
    private Double exposureTime;
    private boolean gzip;
    private DataInputStream gz;
    private int gzPos;
    private int gzSeries;
    private int seriesCount;
    private int backgroundSeriesCount;

    public LiFlimReader() {
        super("LI-FLIM", "fli");
        this.domains = new String[]{"Fluorescence-Lifetime Imaging"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int bytesPerPlane = FormatTools.getPlaneSize(this);
        if (this.gzip) {
            this.prepareGZipStream(no);
            byte[] bytes = new byte[bytesPerPlane];
            try {
                this.gz.readFully(bytes);
            }
            catch (EOFException e) {
                LOGGER.debug("Could not read full plane", (Throwable)e);
            }
            RandomAccessInputStream s = new RandomAccessInputStream(bytes);
            this.readPlane(s, x, y, w, h, buf);
            s.close();
        } else {
            this.in.seek(this.dataOffset + (long)(bytesPerPlane * no));
            int thisSeries = this.getSeries();
            for (int i = 0; i < thisSeries; ++i) {
                this.setSeries(i);
                this.in.skipBytes(this.getImageCount() * FormatTools.getPlaneSize(this));
            }
            this.setSeries(thisSeries);
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.dataOffset = 0L;
            this.ini = null;
            this.gzip = false;
            if (this.gz != null) {
                this.gz.close();
            }
            this.gz = null;
            this.gzPos = 0;
            this.gzSeries = 0;
            this.version = null;
            this.compression = null;
            this.datatype = null;
            this.channels = null;
            this.xLen = null;
            this.yLen = null;
            this.zLen = null;
            this.phases = null;
            this.frequencies = null;
            this.timestamps = null;
            this.backgroundDatatype = null;
            this.backgroundX = null;
            this.backgroundY = null;
            this.backgroundC = null;
            this.backgroundZ = null;
            this.backgroundT = null;
            this.backgroundP = null;
            this.backgroundF = null;
            this.numRegions = 0;
            this.rois = null;
            this.stampValues = null;
            this.exposureTime = null;
            this.seriesCount = 0;
            this.backgroundSeriesCount = 0;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        LOGGER.info("Parsing header");
        this.in = new RandomAccessInputStream(id);
        this.parseHeader();
        LOGGER.info("Parsing metadata");
        this.initOriginalMetadata();
        this.initCoreMetadata();
        this.initOMEMetadata();
    }

    private void parseHeader() throws IOException {
        String headerData = this.in.findString("{END}");
        this.dataOffset = this.in.getFilePointer();
        IniParser parser = new IniParser();
        this.ini = parser.parseINI(new BufferedReader(new StringReader(headerData)));
    }

    private void initOriginalMetadata() {
        this.rois = new Hashtable();
        this.stampValues = new Hashtable();
        IniTable layoutTable = this.ini.getTable(LAYOUT_TABLE);
        this.datatype = (String)layoutTable.get(DATATYPE_KEY);
        this.channels = (String)layoutTable.get(C_KEY);
        this.xLen = (String)layoutTable.get(X_KEY);
        this.yLen = (String)layoutTable.get(Y_KEY);
        this.zLen = (String)layoutTable.get(Z_KEY);
        this.phases = (String)layoutTable.get(P_KEY);
        this.frequencies = (String)layoutTable.get(F_KEY);
        this.timestamps = (String)layoutTable.get(T_KEY);
        IniTable backgroundTable = this.ini.getTable(BACKGROUND_TABLE);
        if (backgroundTable != null) {
            this.backgroundDatatype = (String)backgroundTable.get(DATATYPE_KEY);
            this.backgroundC = (String)backgroundTable.get(C_KEY);
            this.backgroundX = (String)backgroundTable.get(X_KEY);
            this.backgroundY = (String)backgroundTable.get(Y_KEY);
            this.backgroundZ = (String)backgroundTable.get(Z_KEY);
            this.backgroundT = (String)backgroundTable.get(T_KEY);
            this.backgroundP = (String)backgroundTable.get(P_KEY);
            this.backgroundF = (String)backgroundTable.get(F_KEY);
        }
        IniTable infoTable = this.ini.getTable(INFO_TABLE);
        this.version = (String)infoTable.get(VERSION_KEY);
        this.compression = (String)infoTable.get(COMPRESSION_KEY);
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        if (level != MetadataLevel.MINIMUM) {
            for (IniTable table : this.ini) {
                String name = (String)table.get("header");
                for (String key : table.keySet()) {
                    if (key.equals("header")) continue;
                    String value = (String)table.get(key);
                    String metaKey = name + " - " + key;
                    this.addGlobalMeta(metaKey, value);
                    if (metaKey.startsWith(TIMESTAMP_KEY)) {
                        Integer index = new Integer(metaKey.replaceAll(TIMESTAMP_KEY, ""));
                        this.stampValues.put(index, value);
                        continue;
                    }
                    if (metaKey.equals("ROI: INFO - numregions")) {
                        this.numRegions = Integer.parseInt(value);
                        continue;
                    }
                    if (metaKey.startsWith("ROI: ROI") && level != MetadataLevel.NO_OVERLAYS) {
                        int end;
                        int start = metaKey.lastIndexOf("ROI") + 3;
                        Integer index = new Integer(metaKey.substring(start, end = metaKey.indexOf(" ", start)));
                        ROI roi = this.rois.get(index);
                        if (roi == null) {
                            roi = new ROI();
                        }
                        if (metaKey.endsWith("name")) {
                            roi.name = value;
                        } else if (metaKey.indexOf(" - p") >= 0) {
                            String p = metaKey.substring(metaKey.indexOf(" - p") + 4);
                            roi.points.put(new Integer(p), value.replaceAll(" ", ","));
                        }
                        this.rois.put(index, roi);
                        continue;
                    }
                    if (!metaKey.endsWith("ExposureTime")) continue;
                    int space = value.indexOf(" ");
                    double expTime = Double.parseDouble(value.substring(0, space));
                    String units = value.substring(space + 1).toLowerCase();
                    if (units.equals("ms")) {
                        expTime /= 1000.0;
                    }
                    this.exposureTime = new Double(expTime);
                }
            }
        }
    }

    private void initCoreMetadata() throws FormatException {
        int i;
        if (DataTools.indexOf(KNOWN_VERSIONS, this.version) < 0) {
            LOGGER.warn("Unknown LI-FLIM version: {}", (Object)this.version);
        }
        if (COMPRESSION_NONE.equals(this.compression)) {
            this.gzip = false;
        } else if (COMPRESSION_GZIP.equals(this.compression)) {
            this.gzip = true;
        } else {
            throw new UnsupportedCompressionException("Unknown compression type: " + this.compression);
        }
        int sizeP = Integer.parseInt(this.phases);
        int sizeF = Integer.parseInt(this.frequencies);
        int p = this.backgroundP == null ? 1 : Integer.parseInt(this.backgroundP);
        int f = this.backgroundF == null ? 1 : Integer.parseInt(this.backgroundF);
        this.seriesCount = sizeP * sizeF;
        this.backgroundSeriesCount = p * f;
        if (this.backgroundDatatype != null) {
            this.core = new CoreMetadata[this.seriesCount + this.backgroundSeriesCount];
        } else if (this.seriesCount > 1) {
            this.core = new CoreMetadata[this.seriesCount];
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            this.core[i] = new CoreMetadata();
        }
        for (i = 0; i < this.seriesCount; ++i) {
            this.core[i].sizeX = Integer.parseInt(this.xLen);
            this.core[i].sizeY = Integer.parseInt(this.yLen);
            this.core[i].sizeZ = Integer.parseInt(this.zLen);
            this.core[i].sizeC = Integer.parseInt(this.channels);
            this.core[i].sizeT = Integer.parseInt(this.timestamps);
            this.core[i].imageCount = this.getSizeZ() * this.getSizeT();
            this.core[i].rgb = this.getSizeC() > 1;
            this.core[i].indexed = false;
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].pixelType = this.getPixelTypeFromString(this.datatype);
            this.core[i].littleEndian = true;
            this.core[i].interleaved = true;
            this.core[i].falseColor = false;
        }
        for (i = this.seriesCount; i < this.core.length; ++i) {
            this.core[i].sizeX = Integer.parseInt(this.backgroundX);
            this.core[i].sizeY = Integer.parseInt(this.backgroundY);
            this.core[i].sizeZ = Integer.parseInt(this.backgroundZ);
            this.core[i].sizeC = Integer.parseInt(this.backgroundC);
            this.core[i].sizeT = Integer.parseInt(this.backgroundT);
            this.core[i].imageCount = this.core[i].sizeZ * this.core[i].sizeT;
            this.core[i].rgb = this.core[i].sizeC > 1;
            this.core[i].indexed = false;
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].pixelType = this.getPixelTypeFromString(this.backgroundDatatype);
            this.core[i].littleEndian = true;
            this.core[i].interleaved = true;
            this.core[i].falseColor = false;
        }
    }

    private void initOMEMetadata() {
        int times = this.timestamps == null ? 0 : Integer.parseInt(this.timestamps);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, times > 0);
        String path = new Location(this.getCurrentFile()).getName();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            if (i < this.seriesCount) {
                store.setImageName(path + " Primary Image #" + (i + 1), i);
                continue;
            }
            store.setImageName(path + " Background Image #" + (i - this.seriesCount + 1), i);
        }
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        long firstStamp = 0L;
        for (int t = 0; t < times && this.stampValues.get(t) != null; ++t) {
            Double deltaT;
            String[] stampWords = this.stampValues.get(t).split(" ");
            long stampHi = Long.parseLong(stampWords[0]);
            long stampLo = Long.parseLong(stampWords[1]);
            long stamp = DateTools.getMillisFromTicks(stampHi, stampLo);
            if (t == 0) {
                String date = DateTools.convertDate(stamp, 1);
                if (date != null) {
                    store.setImageAcquisitionDate(new Timestamp(date), 0);
                }
                firstStamp = stamp;
                deltaT = new Double(0.0);
            } else {
                long ms = stamp - firstStamp;
                deltaT = new Double((double)ms / 1000.0);
            }
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                for (int z = 0; z < this.getSizeZ(); ++z) {
                    int index = this.getIndex(z, c, t);
                    store.setPlaneDeltaT(deltaT, 0, index);
                    store.setPlaneExposureTime(this.exposureTime, 0, index);
                }
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.NO_OVERLAYS) {
            return;
        }
        Object[] roiIndices = this.rois.keySet().toArray(new Integer[this.rois.size()]);
        Arrays.sort(roiIndices);
        for (int roi = 0; roi < roiIndices.length; ++roi) {
            ROI r = this.rois.get(roiIndices[roi]);
            String polylineID = MetadataTools.createLSID("Shape", roi, 0);
            store.setPolygonID(polylineID, roi, 0);
            store.setPolygonPoints(r.pointsToString(), roi, 0);
            String roiID = MetadataTools.createLSID("ROI", roi);
            store.setROIID(roiID, roi);
            for (int s = 0; s < this.getSeriesCount(); ++s) {
                store.setImageROIRef(roiID, s, roi);
            }
        }
    }

    private int getPixelTypeFromString(String type) throws FormatException {
        if (DATATYPE_UINT8.equals(type)) {
            return 1;
        }
        if (DATATYPE_INT8.equals(type)) {
            return 0;
        }
        if (DATATYPE_UINT16.equals(type)) {
            return 3;
        }
        if (DATATYPE_INT16.equals(type)) {
            return 2;
        }
        if (DATATYPE_UINT32.equals(type)) {
            return 5;
        }
        if (DATATYPE_INT32.equals(type)) {
            return 4;
        }
        if (DATATYPE_REAL32.equals(type)) {
            return 6;
        }
        if (DATATYPE_REAL64.equals(type)) {
            return 7;
        }
        throw new FormatException("Unknown data type: " + type);
    }

    private void prepareGZipStream(int no) throws IOException {
        int bytesPerPlane = FormatTools.getPlaneSize(this);
        if (this.gz == null || no < this.gzPos && this.getSeries() == this.gzSeries || this.gzSeries > this.getSeries()) {
            if (this.gz != null) {
                this.gz.close();
            }
            String path = Location.getMappedId(this.currentId);
            FileInputStream fis = new FileInputStream(path);
            this.skip(fis, this.dataOffset);
            this.gz = new DataInputStream(new GZIPInputStream(fis));
            this.gzPos = 0;
            this.gzSeries = 0;
        }
        if (this.getSeries() >= 1 && this.gzSeries < this.getSeries()) {
            int originalSeries = this.getSeries();
            for (int i = this.gzSeries; i < originalSeries; ++i) {
                this.setSeries(i);
                int nPlanes = this.getImageCount() - this.gzPos;
                int nBytes = FormatTools.getPlaneSize(this) * nPlanes;
                this.skip(this.gz, nBytes);
                this.gzPos = 0;
            }
            this.setSeries(originalSeries);
            this.gzSeries = this.getSeries();
        }
        this.skip(this.gz, bytesPerPlane * (no - this.gzPos));
        this.gzPos = no + 1;
    }

    private void skip(InputStream is, long num) throws IOException {
        long skip;
        for (long skipLeft = num; skipLeft > 0L; skipLeft -= skip) {
            skip = is.skip(skipLeft);
            if (skip > 0L) continue;
            throw new IOException("Cannot skip bytes");
        }
    }

    private class ROI {
        public String name;
        public Hashtable<Integer, String> points = new Hashtable();

        private ROI() {
        }

        public String pointsToString() {
            StringBuilder s = new StringBuilder();
            Object[] pointIndices = this.points.keySet().toArray(new Integer[0]);
            Arrays.sort(pointIndices);
            for (Object point : pointIndices) {
                if (point == null) continue;
                String p = this.points.get(point);
                if (s.length() > 0) {
                    s.append(" ");
                }
                s.append(p);
            }
            return s.toString();
        }
    }
}

