/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000BoxType;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.in.JPEG2000MetadataParser;
import loci.formats.meta.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPEG2000Reader
extends FormatReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPEG2000Reader.class);
    private Integer resolutionLevels;
    private int[][] lut;
    private long pixelsOffset;
    private int lastSeries = -1;
    private byte[] lastSeriesPlane;

    public JPEG2000Reader() {
        super("JPEG-2000", new String[]{"jp2", "j2k", "jpf"});
        this.suffixSufficient = false;
        this.suffixNecessary = false;
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        boolean validStart;
        int blockLen = 40;
        if (!FormatTools.validStream(stream, 40, false)) {
            return false;
        }
        boolean bl = validStart = (stream.readShort() & 0xFFFF) == 65359;
        if (!validStart) {
            stream.skipBytes(2);
            boolean bl2 = validStart = stream.readInt() == JPEG2000BoxType.SIGNATURE.getCode();
            if (validStart) {
                stream.skipBytes(12);
                validStart = !stream.readString(4).equals("jpx ");
            }
        }
        stream.seek(stream.length() - 2L);
        boolean validEnd = (stream.readShort() & 0xFFFF) == 65497;
        return validStart && validEnd;
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.lut == null || FormatTools.getBytesPerPixel(this.getPixelType()) != 1) {
            return null;
        }
        byte[][] byteLut = new byte[this.lut.length][this.lut[0].length];
        for (int i = 0; i < this.lut.length; ++i) {
            for (int j = 0; j < this.lut[i].length; ++j) {
                byteLut[i][j] = (byte)(this.lut[i][j] & 0xFF);
            }
        }
        return byteLut;
    }

    public short[][] get16BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.lut == null || FormatTools.getBytesPerPixel(this.getPixelType()) != 2) {
            return null;
        }
        short[][] shortLut = new short[this.lut.length][this.lut[0].length];
        for (int i = 0; i < this.lut.length; ++i) {
            for (int j = 0; j < this.lut[i].length; ++j) {
                shortLut[i][j] = (short)(this.lut[i][j] & 0xFFFF);
            }
        }
        return shortLut;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.resolutionLevels = null;
            this.lut = null;
            this.pixelsOffset = 0L;
            this.lastSeries = -1;
            this.lastSeriesPlane = null;
        }
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.lastSeries == this.getCoreIndex() && this.lastSeriesPlane != null) {
            RandomAccessInputStream s = new RandomAccessInputStream(this.lastSeriesPlane);
            this.readPlane(s, x, y, w, h, buf);
            s.close();
            return buf;
        }
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.interleaved = this.isInterleaved();
        options.littleEndian = this.isLittleEndian();
        if (this.resolutionLevels != null) {
            options.resolution = Math.abs(this.getCoreIndex() - this.resolutionLevels);
        } else if (this.core.length > 1) {
            options.resolution = this.getCoreIndex();
        }
        this.in.seek(this.pixelsOffset);
        this.lastSeriesPlane = new JPEG2000Codec().decompress(this.in, (CodecOptions)options);
        RandomAccessInputStream s = new RandomAccessInputStream(this.lastSeriesPlane);
        this.readPlane(s, x, y, w, h, buf);
        s.close();
        this.lastSeries = this.getCoreIndex();
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        JPEG2000MetadataParser metadataParser = new JPEG2000MetadataParser(this.in);
        if (metadataParser.isRawCodestream()) {
            LOGGER.info("Codestream is raw, using codestream dimensions.");
            this.core[0].sizeX = metadataParser.getCodestreamSizeX();
            this.core[0].sizeY = metadataParser.getCodestreamSizeY();
            this.core[0].sizeC = metadataParser.getCodestreamSizeC().shortValue();
            this.core[0].pixelType = metadataParser.getCodestreamPixelType();
        } else {
            LOGGER.info("Codestream is JP2 boxed, using header dimensions.");
            this.core[0].sizeX = metadataParser.getHeaderSizeX();
            this.core[0].sizeY = metadataParser.getHeaderSizeY();
            this.core[0].sizeC = metadataParser.getHeaderSizeC().shortValue();
            this.core[0].pixelType = metadataParser.getHeaderPixelType();
        }
        this.lut = metadataParser.getLookupTable();
        this.pixelsOffset = metadataParser.getCodestreamOffset();
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].interleaved = true;
        this.core[0].littleEndian = false;
        boolean bl = this.core[0].indexed = !this.isRGB() && this.lut != null;
        if (this.resolutionLevels != null) {
            CoreMetadata[] newCore = new CoreMetadata[this.resolutionLevels + 1];
            newCore[0] = this.core[0];
            if (!this.hasFlattenedResolutions()) {
                newCore[0].resolutionCount = newCore.length;
            }
            for (i = 1; i < newCore.length; ++i) {
                newCore[i] = new CoreMetadata(this, 0);
                newCore[i].sizeX = newCore[i - 1].sizeX / 2;
                newCore[i].sizeY = newCore[i - 1].sizeY / 2;
                newCore[i].thumbnail = true;
            }
            this.core = newCore;
        }
        ArrayList<String> comments = metadataParser.getComments();
        for (i = 0; i < comments.size(); ++i) {
            String comment = comments.get(i);
            int equal = comment.indexOf("=");
            if (equal >= 0) {
                String key = comment.substring(0, equal);
                String value = comment.substring(equal + 1);
                this.addGlobalMeta(key, value);
                continue;
            }
            this.addGlobalMeta("Comment #" + (i + 1), comment);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
    }
}

