/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class INRReader
extends FormatReader {
    private static final String INR_MAGIC = "#INRIMAGE";
    private static final int HEADER_SIZE = 256;

    public INRReader() {
        super("INR", "inr");
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = INR_MAGIC.length();
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        return stream.readString(blockLen).indexOf(INR_MAGIC) == 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        long planeSize = FormatTools.getPlaneSize(this);
        this.in.seek(256L + (long)no * planeSize);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Reading header");
        String header = this.in.readString(256);
        String[] lines = header.split("\n");
        Double physicalSizeX = null;
        Double physicalSizeY = null;
        Double physicalSizeZ = null;
        boolean isSigned = false;
        int nBits = 0;
        for (String line : lines) {
            int index = line.indexOf("=");
            if (index < 0) continue;
            String key = line.substring(0, index);
            String value = line.substring(index + 1);
            this.addGlobalMeta(key, value);
            if (key.equals("XDIM")) {
                this.core[0].sizeX = Integer.parseInt(value);
                continue;
            }
            if (key.equals("YDIM")) {
                this.core[0].sizeY = Integer.parseInt(value);
                continue;
            }
            if (key.equals("ZDIM")) {
                this.core[0].sizeZ = Integer.parseInt(value);
                continue;
            }
            if (key.equals("VDIM")) {
                this.core[0].sizeT = Integer.parseInt(value);
                continue;
            }
            if (key.equals("TYPE")) {
                isSigned = value.toLowerCase().startsWith("signed");
                continue;
            }
            if (key.equals("PIXSIZE")) {
                String bits = value.substring(0, value.indexOf(" "));
                nBits = Integer.parseInt(bits);
                continue;
            }
            if (key.equals("VX")) {
                physicalSizeX = new Double(value);
                continue;
            }
            if (key.equals("VY")) {
                physicalSizeY = new Double(value);
                continue;
            }
            if (!key.equals("VZ")) continue;
            physicalSizeZ = new Double(value);
        }
        LOGGER.info("Populating metadata");
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        this.core[0].sizeC = 1;
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        this.core[0].pixelType = FormatTools.pixelTypeFromBytes(nBits / 8, isSigned, false);
        this.core[0].dimensionOrder = "XYZTC";
        LOGGER.info("Populating OME metadata");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            if (physicalSizeX != null && physicalSizeX > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(physicalSizeX), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", (Object)physicalSizeX);
            }
            if (physicalSizeY != null && physicalSizeY > 0.0) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(physicalSizeY), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", (Object)physicalSizeY);
            }
            if (physicalSizeZ != null && physicalSizeZ > 0.0) {
                store.setPixelsPhysicalSizeZ(new PositiveFloat(physicalSizeZ), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeZ; got {}", (Object)physicalSizeZ);
            }
        }
    }
}

