/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class HRDGDFReader
extends FormatReader {
    private static final String MAGIC_STRING = "SURFACE WIND COMPONENTS";
    private double[][] surfaceWind;

    public HRDGDFReader() {
        super("NOAA-HRD Gridded Data Format", "");
        this.domains = new String[]{"Unknown"};
        this.suffixSufficient = false;
        this.suffixNecessary = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = MAGIC_STRING.length();
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        String check = stream.readString(blockLen);
        return check.equals(MAGIC_STRING);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int nextBufIndex = 0;
        for (int row = y; row < h + y; ++row) {
            for (int col = x; col < w + x; ++col) {
                long v = Double.doubleToLongBits(this.surfaceWind[no][row * this.getSizeX() + col]);
                DataTools.unpackBytes(v, buf, nextBufIndex, 8, this.isLittleEndian());
                nextBufIndex += 8;
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.surfaceWind = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        String[] data = DataTools.readFile(id).split("[\r\n]");
        String hurricane = data[0].substring(data[0].lastIndexOf(" ") + 1);
        String pixelSize = data[1].substring(data[1].indexOf(" ") + 1, data[1].lastIndexOf(" "));
        Double physicalSize = new Double(pixelSize) * 1.0E9;
        String centerLine = data[2];
        centerLine = centerLine.replaceAll("STORM CENTER LOCALE IS ", "");
        String[] center = centerLine.split(" ");
        Double centerLongitude = new Double(center[0]);
        Double centerLatitude = new Double(center[5]);
        int lineNumber = 3;
        while (!data[lineNumber++].startsWith(MAGIC_STRING)) {
        }
        String dims = data[lineNumber++].trim();
        String x = dims.substring(0, dims.indexOf(" ")).trim();
        String y = dims.substring(dims.indexOf(" ") + 1).trim();
        this.surfaceWind = new double[2][Integer.parseInt(y) * Integer.parseInt(x)];
        int pixIndex = 0;
        while (lineNumber < data.length) {
            String line = data[lineNumber++];
            while (line.indexOf("(") != -1) {
                int end = line.indexOf(")");
                String pixel = line.substring(line.indexOf("(") + 1, end);
                line = line.substring(end + 1);
                int comma = pixel.indexOf(",");
                this.surfaceWind[0][pixIndex] = new Double(pixel.substring(0, comma).trim());
                this.surfaceWind[1][pixIndex] = new Double(pixel.substring(comma + 1).trim());
                ++pixIndex;
            }
        }
        this.addGlobalMeta("Hurricane", hurricane);
        this.addGlobalMeta("DX (kilometers)", pixelSize);
        this.addGlobalMeta("DY (kilometers)", pixelSize);
        this.addGlobalMeta("Storm center (Latitude)", centerLatitude);
        this.addGlobalMeta("Storm center (Longitude)", centerLongitude);
        this.core[0].sizeX = Integer.parseInt(x);
        this.core[0].sizeY = Integer.parseInt(y);
        this.core[0].sizeC = 2;
        this.core[0].rgb = false;
        this.core[0].pixelType = 7;
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = this.getSizeC() * this.getSizeZ() * this.getSizeT();
        this.core[0].indexed = false;
        this.core[0].littleEndian = false;
        this.core[0].dimensionOrder = "XYCTZ";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            if (physicalSize > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(physicalSize), 0);
                store.setPixelsPhysicalSizeY(new PositiveFloat(physicalSize), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSize; got {}", (Object)physicalSize);
            }
        }
    }
}

