/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import loci.formats.DimensionSwapper;
import loci.formats.FilePattern;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.ImageWriter;
import loci.formats.gui.BufferedImageReader;
import loci.formats.gui.BufferedImageWriter;
import loci.formats.gui.GUITools;
import loci.formats.gui.LegacyQTTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConverter
extends JFrame
implements ActionListener,
ChangeListener,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataConverter.class);
    private static final String TITLE = "Data Converter";
    private static final int COLUMNS = 24;
    private FileStitcher reader = new FileStitcher(true);
    private DimensionSwapper swap = new DimensionSwapper(this.reader);
    private BufferedImageReader biReader = new BufferedImageReader(this.swap);
    private ImageWriter writer = new ImageWriter();
    private BufferedImageWriter biWriter = new BufferedImageWriter(this.writer);
    private JFileChooser rc = GUITools.buildFileChooser(this.swap);
    private JFileChooser wc = GUITools.buildFileChooser(this.writer);
    private boolean shutdown;
    private boolean force = true;
    private JTextField input;
    private JTextField output;
    private JCheckBox qtJava;
    private JCheckBox forceType;
    private JCheckBox includeZ;
    private JCheckBox includeT;
    private JCheckBox includeC;
    private JLabel zLabel;
    private JLabel tLabel;
    private JLabel cLabel;
    private JComboBox zChoice;
    private JComboBox tChoice;
    private JComboBox cChoice;
    private JComboBox codec;
    private JSpinner fps;
    private JSpinner series;
    private JPanel seriesRow;
    private JProgressBar progress;
    private JButton convert;

    public DataConverter() {
        super(TITLE);
        JPanel pane = new JPanel();
        pane.setBorder(new EmptyBorder(5, 5, 5, 5));
        pane.setLayout(new BoxLayout(pane, 1));
        this.setContentPane(pane);
        RowPanel row1 = new RowPanel();
        row1.setLayout(new BoxLayout(row1, 0));
        pane.add(row1);
        pane.add(Box.createVerticalStrut(4));
        JLabel inputLabel = new JLabel("Input");
        row1.add(inputLabel);
        row1.add(Box.createHorizontalStrut(4));
        this.input = new JTextField(24);
        this.input.setEditable(false);
        row1.add(this.input);
        this.limitHeight(this.input);
        row1.add(Box.createHorizontalStrut(4));
        JButton chooseInput = new JButton("Choose");
        row1.add(chooseInput);
        chooseInput.setActionCommand("input");
        chooseInput.addActionListener(this);
        row1.add(Box.createHorizontalStrut(4));
        RowPanel row2 = new RowPanel();
        row2.setLayout(new BoxLayout(row2, 0));
        pane.add(row2);
        pane.add(Box.createVerticalStrut(9));
        JLabel outputLabel = new JLabel("Output");
        row2.add(outputLabel);
        inputLabel.setPreferredSize(outputLabel.getPreferredSize());
        row2.add(Box.createHorizontalStrut(4));
        this.output = new JTextField(24);
        this.output.setEditable(false);
        row2.add(this.output);
        this.limitHeight(this.output);
        row2.add(Box.createHorizontalStrut(4));
        JButton chooseOutput = new JButton("Choose");
        row2.add(chooseOutput);
        chooseOutput.setActionCommand("output");
        chooseOutput.addActionListener(this);
        row2.add(Box.createHorizontalStrut(4));
        this.seriesRow = new RowPanel();
        this.seriesRow.setLayout(new BoxLayout(this.seriesRow, 0));
        pane.add(this.seriesRow);
        RowPanel row3 = new RowPanel();
        row3.setLayout(new BoxLayout(row3, 0));
        pane.add(row3);
        pane.add(Box.createVerticalStrut(9));
        String[] axisNames = new String[]{"Time", "Slice", "Channel"};
        this.zLabel = new JLabel(" 1) Slice       <0-0>");
        this.tLabel = new JLabel(" 2) Time      <0-0>");
        this.cLabel = new JLabel(" 3) Channel <0-0>");
        this.zChoice = new JComboBox<String>(axisNames);
        this.zChoice.setSelectedIndex(1);
        this.zChoice.setPreferredSize(new Dimension(5, 9));
        this.zChoice.setActionCommand("zChoice");
        this.zChoice.addActionListener(this);
        this.tChoice = new JComboBox<String>(axisNames);
        this.tChoice.setSelectedIndex(0);
        this.tChoice.setPreferredSize(new Dimension(5, 9));
        this.tChoice.setActionCommand("tChoice");
        this.tChoice.addActionListener(this);
        this.cChoice = new JComboBox<String>(axisNames);
        this.cChoice.setSelectedIndex(2);
        this.cChoice.setPreferredSize(new Dimension(5, 9));
        this.cChoice.setActionCommand("cChoice");
        this.cChoice.addActionListener(this);
        this.includeZ = new JCheckBox("Include in file");
        this.includeZ.setEnabled(false);
        this.includeT = new JCheckBox("Include in file");
        this.includeT.setEnabled(false);
        this.includeC = new JCheckBox("Include in file");
        this.includeC.setEnabled(false);
        row3.add(this.zLabel);
        row3.add(this.zChoice);
        row3.add(this.includeZ);
        row3.add(Box.createHorizontalStrut(4));
        row3 = new RowPanel();
        row3.setLayout(new BoxLayout(row3, 0));
        pane.add(row3);
        pane.add(Box.createVerticalStrut(9));
        row3.add(this.tLabel);
        row3.add(this.tChoice);
        row3.add(this.includeT);
        row3.add(Box.createHorizontalStrut(4));
        row3 = new RowPanel();
        row3.setLayout(new BoxLayout(row3, 0));
        pane.add(row3);
        pane.add(Box.createVerticalStrut(9));
        row3.add(this.cLabel);
        row3.add(this.cChoice);
        row3.add(this.includeC);
        row3.add(Box.createHorizontalStrut(4));
        RowPanel row4 = new RowPanel();
        row4.setLayout(new BoxLayout(row4, 0));
        pane.add(row4);
        pane.add(Box.createVerticalStrut(9));
        JLabel fpsLabel = new JLabel("Frames per second: ");
        row4.add(fpsLabel);
        this.fps = new JSpinner(new SpinnerNumberModel(10, 1, 100, 1));
        row4.add(this.fps);
        row4.add(Box.createHorizontalStrut(3));
        JLabel codecLabel = new JLabel("Output compression type: ");
        row4.add(codecLabel);
        this.codec = new JComboBox<String>(new String[0]);
        row4.add(this.codec);
        RowPanel row5 = new RowPanel();
        row5.setLayout(new BoxLayout(row5, 0));
        pane.add(row5);
        pane.add(Box.createVerticalStrut(9));
        boolean canDoQT = new LegacyQTTools().canDoQT();
        this.qtJava = new JCheckBox("Use QTJava", canDoQT);
        this.qtJava.setEnabled(canDoQT);
        row5.add(this.qtJava);
        row5.add(Box.createHorizontalStrut(3));
        this.forceType = new JCheckBox("Force", true);
        this.forceType.setActionCommand("force");
        this.forceType.addActionListener(this);
        row5.add(this.forceType);
        row5.add(Box.createHorizontalStrut(3));
        row5.add(Box.createHorizontalGlue());
        this.convert = new JButton("Convert");
        row5.add(this.convert);
        this.convert.setActionCommand("convert");
        this.convert.addActionListener(this);
        row5.add(Box.createHorizontalStrut(4));
        JButton quit = new JButton("Quit");
        row5.add(quit);
        quit.setActionCommand("quit");
        quit.addActionListener(this);
        RowPanel row6 = new RowPanel();
        row6.setLayout(new BoxLayout(row6, 0));
        pane.add(row6);
        this.progress = new JProgressBar();
        this.progress.setString("");
        this.progress.setStringPainted(true);
        row6.add(this.progress);
        row6.add(Box.createHorizontalStrut(8));
        JLabel version = new JLabel("Built on 7 February 2013");
        version.setFont(version.getFont().deriveFont(2));
        row6.add(version);
        this.setDefaultCloseOperation(2);
        this.setLocation(100, 100);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("input".equals(cmd)) {
            int rval = this.rc.showOpenDialog(this);
            if (rval != 0) {
                return;
            }
            File file2 = this.rc.getSelectedFile();
            if (file2 != null) {
                this.wc.setCurrentDirectory(file2);
            }
            String pattern = FilePattern.findPattern(file2);
            this.input.setText(pattern);
            try {
                this.swap.setId(pattern);
                if (this.swap.getSeriesCount() > 1 && this.series == null) {
                    JLabel seriesLabel = new JLabel("Series: ");
                    this.series = new JSpinner(new SpinnerNumberModel(1, 1, this.swap.getSeriesCount(), 1));
                    this.series.addChangeListener(this);
                    this.seriesRow.add(seriesLabel);
                    this.seriesRow.add(this.series);
                    this.pack();
                } else if (this.series != null) {
                    ((SpinnerNumberModel)this.series.getModel()).setMaximum(new Integer(this.swap.getSeriesCount()));
                    this.pack();
                } else if (this.swap.getSeriesCount() == 1 && this.series != null) {
                    this.seriesRow.remove(this.series);
                    this.series = null;
                    this.pack();
                }
            }
            catch (FormatException exc) {
                LOGGER.info("", (Throwable)exc);
            }
            catch (IOException exc) {
                LOGGER.info("", (Throwable)exc);
            }
            this.updateLabels(pattern);
        } else if ("output".equals(cmd)) {
            int rval = this.wc.showSaveDialog(this);
            if (rval != 0) {
                return;
            }
            File file3 = this.wc.getSelectedFile();
            if (file3 != null) {
                this.rc.setCurrentDirectory(file3);
            }
            String s = file3.getPath();
            this.output.setText(s);
            try {
                this.writer.setId(s);
                if (!this.writer.canDoStacks()) {
                    this.includeZ.setEnabled(false);
                    this.includeT.setEnabled(false);
                    this.includeC.setEnabled(false);
                }
                this.codec.removeAllItems();
                String[] codecs = this.writer.getWriter().getCompressionTypes();
                if (codecs == null) {
                    codecs = new String[]{"Uncompressed"};
                }
                for (int i = 0; i < codecs.length; ++i) {
                    this.codec.addItem(codecs[i]);
                }
            }
            catch (FormatException exc) {
                LOGGER.info("", (Throwable)exc);
            }
            catch (IOException exc) {
                LOGGER.info("", (Throwable)exc);
            }
        } else if ("zChoice".equals(cmd)) {
            String newName = (String)this.zChoice.getSelectedItem();
            String label = this.zLabel.getText();
            String oldName = label.substring(4, label.indexOf(" ", 4));
            label = label.replaceAll(oldName, newName);
            this.zLabel.setText(label);
        } else if ("tChoice".equals(cmd)) {
            String newName = (String)this.tChoice.getSelectedItem();
            String label = this.tLabel.getText();
            String oldName = label.substring(4, label.indexOf(" ", 4));
            label = label.replaceAll(oldName, newName);
            this.tLabel.setText(label);
        } else if ("cChoice".equals(cmd)) {
            String newName = (String)this.cChoice.getSelectedItem();
            String label = this.cLabel.getText();
            String oldName = label.substring(4, label.indexOf(" ", 4));
            label = label.replaceAll(oldName, newName);
            this.cLabel.setText(label);
        } else if ("convert".equals(cmd)) {
            new Thread((Runnable)this, "Converter").start();
        } else if ("force".equals(cmd)) {
            this.force = this.forceType.isSelected();
        } else if ("quit".equals(cmd)) {
            this.shutdown = true;
            new Thread("Quitter"){

                public void run() {
                    DataConverter.this.dispose();
                }
            }.start();
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.series) {
            this.swap.setSeries((Integer)this.series.getValue() - 1);
            this.updateLabels(this.input.getText());
        }
    }

    public void run() {
        this.convert.setEnabled(false);
        this.includeZ.setEnabled(false);
        this.includeT.setEnabled(false);
        this.includeC.setEnabled(false);
        this.zChoice.setEnabled(false);
        this.tChoice.setEnabled(false);
        this.cChoice.setEnabled(false);
        this.input.setEditable(false);
        this.fps.setEnabled(false);
        if (this.series != null) {
            this.series.setEnabled(false);
        }
        this.forceType.setEnabled(false);
        this.codec.setEnabled(false);
        this.progress.setString("Getting ready");
        try {
            String in = this.input.getText();
            String out = this.output.getText();
            if (in.trim().equals("")) {
                this.msg("Please specify input files.");
                this.convert.setEnabled(true);
                this.progress.setString("");
                return;
            }
            if (out.trim().equals("")) {
                File f = new File(in);
                String name = new FilePattern(in).getPrefix();
                String stitchDir = name + "-stitched";
                new File(f.getParent() + File.separator + stitchDir).mkdir();
                out = f.getParent() + File.separator + stitchDir + File.separator + name + ".tif";
                out = out.replaceAll(File.separator + File.separator, File.separator);
                this.output.setText(out);
            }
            this.output.setEditable(false);
            this.swap.setId(in);
            if (this.series != null) {
                this.swap.setSeries((Integer)this.series.getValue() - 1);
            }
            this.writer.setFramesPerSecond((Integer)this.fps.getValue());
            try {
                this.writer.getWriter(out).setCompression((String)this.codec.getSelectedItem());
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            String order = this.swap.getDimensionOrder();
            if (this.zLabel.getText().indexOf("Time") != -1) {
                order = order.replace('Z', 'T');
            } else if (this.zLabel.getText().indexOf("Channel") != -1) {
                order = order.replace('Z', 'C');
            }
            if (this.tLabel.getText().indexOf("Slice") != -1) {
                order = order.replace('T', 'Z');
            } else if (this.tLabel.getText().indexOf("Channel") != -1) {
                order = order.replace('T', 'C');
            }
            if (this.cLabel.getText().indexOf("Time") != -1) {
                order = order.replace('C', 'T');
            } else if (this.cLabel.getText().indexOf("Slice") != -1) {
                order = order.replace('C', 'Z');
            }
            this.swap.swapDimensions(order);
            int internalZ = this.includeZ.isSelected() ? this.swap.getSizeZ() : 1;
            int internalT = this.includeT.isSelected() ? this.swap.getSizeT() : 1;
            int internalC = this.includeC.isSelected() ? this.swap.getEffectiveSizeC() : 1;
            int externalZ = this.includeZ.isSelected() ? 1 : this.swap.getSizeZ();
            int externalT = this.includeT.isSelected() ? 1 : this.swap.getSizeT();
            int externalC = this.includeC.isSelected() ? 1 : this.swap.getEffectiveSizeC();
            int zDigits = ("" + externalZ).length();
            int tDigits = ("" + externalT).length();
            int cDigits = ("" + externalC).length();
            this.progress.setMaximum(2 * this.swap.getImageCount());
            int star = out.lastIndexOf(".");
            if (star < 0) {
                star = out.length();
            }
            String pre = out.substring(0, star);
            String post = out.substring(star);
            int type = this.swap.getPixelType();
            this.writer.setId(out);
            if (this.force && !this.writer.isSupportedType(type)) {
                int[] types = this.writer.getPixelTypes();
                for (int i = 0; i < types.length; ++i) {
                    if (types[i] > type) {
                        type = i == 0 ? types[i] : types[i - 1];
                        break;
                    }
                    if (i != types.length - 1) continue;
                    type = types[i];
                }
            } else if (!this.force && !this.writer.isSupportedType(type)) {
                throw new FormatException("Unsupported pixel type: " + FormatTools.getPixelTypeString(type) + "\nTo write to this format, the \"force\" box must be checked.\n" + "This may result in a loss of precision; for best results, " + "convert to TIFF instead.");
            }
            long start = System.currentTimeMillis();
            int plane = 0;
            for (int i = 0; i < externalZ; ++i) {
                for (int j = 0; j < externalT; ++j) {
                    for (int k = 0; k < externalC; ++k) {
                        String num;
                        String zBlock = "";
                        String tBlock = "";
                        String cBlock = "";
                        if (externalZ > 1) {
                            num = "" + i;
                            while (num.length() < zDigits) {
                                num = "0" + num;
                            }
                            zBlock = "Z" + num + "_";
                        }
                        if (externalT > 1) {
                            num = "" + j;
                            while (num.length() < tDigits) {
                                num = "0" + num;
                            }
                            tBlock = "T" + num + "_";
                        }
                        if (externalC > 1) {
                            num = "" + k;
                            while (num.length() < cDigits) {
                                num = "0" + num;
                            }
                            cBlock = "C" + num;
                        }
                        String outFile = pre;
                        if (zBlock.length() > 1) {
                            outFile = outFile + zBlock;
                        }
                        if (tBlock.length() > 1) {
                            outFile = outFile + tBlock;
                        }
                        if (cBlock.length() > 1) {
                            outFile = outFile + cBlock;
                        }
                        if (outFile.endsWith("_")) {
                            outFile = outFile.substring(0, outFile.length() - 1);
                        }
                        outFile = outFile + post;
                        String outName = new File(outFile).getName();
                        int planesPerFile = internalZ * internalT * internalC;
                        int filePlane = 0;
                        for (int z = 0; z < internalZ; ++z) {
                            block21: for (int t = 0; t < internalT; ++t) {
                                for (int c = 0; c < internalC; ++c) {
                                    int zPos = z * externalZ + i;
                                    int tPos = t * externalT + j;
                                    int cPos = c * externalC + k;
                                    this.progress.setString(outName + " " + (filePlane + 1) + "/" + planesPerFile);
                                    ++filePlane;
                                    this.progress.setValue(2 * (plane + 1));
                                    ++plane;
                                    int ndx = this.swap.getIndex(zPos, cPos, tPos);
                                    BufferedImage img = this.biReader.openImage(ndx);
                                    this.writer.setId(out);
                                    if (this.force && !this.writer.isSupportedType(this.swap.getPixelType())) {
                                        int pixelType = 0;
                                        switch (type) {
                                            case 0: 
                                            case 1: {
                                                pixelType = 0;
                                                break;
                                            }
                                            case 2: {
                                                pixelType = 1;
                                                break;
                                            }
                                            case 3: {
                                                pixelType = 2;
                                                break;
                                            }
                                            case 4: 
                                            case 5: {
                                                pixelType = 3;
                                                break;
                                            }
                                            case 6: {
                                                pixelType = 4;
                                                break;
                                            }
                                            case 7: {
                                                pixelType = 5;
                                            }
                                        }
                                    }
                                    this.writer.setId(outFile);
                                    this.biWriter.savePlane(filePlane, img);
                                    if (this.shutdown) continue block21;
                                }
                            }
                        }
                    }
                }
            }
            this.progress.setValue(2 * this.swap.getImageCount());
            this.progress.setString("Finishing");
            if (this.writer != null) {
                this.writer.close();
            }
            long end = System.currentTimeMillis();
            double time = (double)(end - start) / 1000.0;
            long avg = (end - start) / (long)this.swap.getImageCount();
            this.progress.setString(time + " s elapsed (" + avg + " ms/plane)");
            this.progress.setValue(0);
            if (this.swap != null) {
                this.swap.close();
            }
        }
        catch (FormatException exc) {
            LOGGER.info("", (Throwable)exc);
            String err = exc.getMessage();
            if (err == null) {
                err = exc.getClass().getName();
            }
            this.msg("Sorry, an error occurred: " + err);
            this.progress.setString("");
            this.progress.setValue(0);
        }
        catch (IOException exc) {
            LOGGER.info("", (Throwable)exc);
            String err = exc.getMessage();
            if (err == null) {
                err = exc.getClass().getName();
            }
            this.msg("Sorry, an error occurred: " + err);
            this.progress.setString("");
            this.progress.setValue(0);
        }
        this.convert.setEnabled(true);
        this.includeZ.setEnabled(true);
        this.includeT.setEnabled(true);
        this.includeC.setEnabled(true);
        this.zChoice.setEnabled(true);
        this.tChoice.setEnabled(true);
        this.cChoice.setEnabled(true);
        this.input.setEditable(true);
        this.output.setEditable(true);
        this.fps.setEnabled(true);
        if (this.series != null) {
            this.series.setEnabled(true);
        }
        this.forceType.setEnabled(true);
        this.codec.setEnabled(true);
    }

    private void limitHeight(JComponent jc) {
        int w = jc.getMaximumSize().width;
        int h = jc.getPreferredSize().height;
        jc.setMaximumSize(new Dimension(w, h));
    }

    private void msg(String msg) {
        JOptionPane.showMessageDialog(this, msg, TITLE, 0);
    }

    private void updateLabels(String pattern) {
        try {
            this.swap.setId(pattern);
            String z = this.zLabel.getText();
            z = z.substring(0, z.indexOf("<"));
            z = z + "<1-" + this.swap.getSizeZ() + ">";
            this.zLabel.setText(z);
            String t = this.tLabel.getText();
            t = t.substring(0, t.indexOf("<"));
            t = t + "<1-" + this.swap.getSizeT() + ">";
            this.tLabel.setText(t);
            String c = this.cLabel.getText();
            c = c.substring(0, c.indexOf("<"));
            c = c + "<1-" + this.swap.getEffectiveSizeC() + ">";
            this.cLabel.setText(c);
            this.includeZ.setEnabled(true);
            this.includeT.setEnabled(true);
            this.includeC.setEnabled(true);
        }
        catch (FormatException exc) {
            LOGGER.info("", (Throwable)exc);
        }
        catch (IOException exc) {
            LOGGER.info("", (Throwable)exc);
        }
    }

    public static void main(String[] args) {
        new DataConverter().setVisible(true);
    }

    private class RowPanel
    extends JPanel {
        private RowPanel() {
        }

        public Dimension getMaximumSize() {
            int w = super.getMaximumSize().width;
            int h = this.getPreferredSize().height;
            return new Dimension(w, h);
        }
    }
}

