/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import loci.common.Location;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.ImageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxisGuesser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AxisGuesser.class);
    public static final int UNKNOWN_AXIS = 0;
    public static final int Z_AXIS = 1;
    public static final int T_AXIS = 2;
    public static final int C_AXIS = 3;
    public static final int S_AXIS = 4;
    protected static final String[] Z = new String[]{"fp", "sec", "z", "zs", "focal", "focalplane"};
    protected static final String[] T = new String[]{"t", "tl", "tp", "time"};
    protected static final String[] C = new String[]{"c", "ch", "w", "wavelength"};
    protected static final String[] S = new String[]{"s", "series", "sp"};
    protected static final String ONE = "1";
    protected static final String TWO = "2";
    protected static final String THREE = "3";
    protected FilePattern fp;
    protected String dimOrder;
    protected String newOrder;
    protected int[] axisTypes;
    protected boolean certain;

    public AxisGuesser(FilePattern fp, String dimOrder, int sizeZ, int sizeT, int sizeC, boolean isCertain) {
        char[] ch;
        this.fp = fp;
        this.dimOrder = dimOrder;
        this.newOrder = dimOrder;
        String[] prefixes = fp.getPrefixes();
        String suffix = fp.getSuffix();
        String[][] elements = fp.getElements();
        this.axisTypes = new int[elements.length];
        boolean foundZ = false;
        boolean foundT = false;
        boolean foundC = false;
        for (int i = 0; i < this.axisTypes.length; ++i) {
            int third;
            int j;
            int f;
            int l;
            String p = prefixes[i].toLowerCase();
            ch = p.toCharArray();
            for (l = ch.length - 1; l >= 0 && (ch[l] >= '0' && ch[l] <= '9' || ch[l] == ' ' || ch[l] == '-' || ch[l] == '_' || ch[l] == '.'); --l) {
            }
            for (f = l; f >= 0 && ch[f] >= 'a' && ch[f] <= 'z'; --f) {
            }
            p = p.substring(f + 1, l + 1);
            for (j = 0; j < Z.length; ++j) {
                if (!p.equals(Z[j])) continue;
                this.axisTypes[i] = 1;
                foundZ = true;
                break;
            }
            if (this.axisTypes[i] != 0) continue;
            for (j = 0; j < T.length; ++j) {
                if (!p.equals(T[j])) continue;
                this.axisTypes[i] = 2;
                foundT = true;
                break;
            }
            if (this.axisTypes[i] != 0) continue;
            for (j = 0; j < C.length; ++j) {
                if (!p.equals(C[j])) continue;
                this.axisTypes[i] = 3;
                foundC = true;
                break;
            }
            if (this.axisTypes[i] != 0) continue;
            for (j = 0; j < S.length; ++j) {
                if (!p.equals(S[j])) continue;
                this.axisTypes[i] = 4;
                break;
            }
            if (this.axisTypes[i] != 0) continue;
            if (suffix.equalsIgnoreCase(".pic") && i == this.axisTypes.length - 1 && (elements[i].length == 2 && (elements[i][0].equals(ONE) || elements[i][0].equals(TWO)) && (elements[i][1].equals(TWO) || elements[i][1].equals(THREE)) || elements[i].length == 3 && elements[i][0].equals(ONE) && elements[i][1].equals(TWO) && elements[i][2].equals(THREE))) {
                this.axisTypes[i] = 3;
                continue;
            }
            if (elements[i].length != 2 && elements[i].length != 3) continue;
            char first = elements[i][0].toLowerCase().charAt(0);
            char second = elements[i][1].toLowerCase().charAt(0);
            int n = third = elements[i].length == 2 ? 98 : (int)elements[i][2].toLowerCase().charAt(0);
            if (first != 'r' && second != 'r' && third != 114 || first != 'g' && second != 'g' && third != 103 || first != 'b' && second != 'b' && third != 98) continue;
            this.axisTypes[i] = 3;
        }
        if (!isCertain && (foundZ && !foundT && sizeZ > 1 && sizeT == 1 || foundT && !foundZ && sizeT > 1 && sizeZ == 1)) {
            int indexZ = this.newOrder.indexOf(90);
            int indexT = this.newOrder.indexOf(84);
            ch = this.newOrder.toCharArray();
            ch[indexZ] = 84;
            ch[indexT] = 90;
            this.newOrder = new String(ch);
            int sz = sizeT;
            sizeT = sizeZ;
            sizeZ = sz;
        }
        boolean canBeZ = !foundZ && sizeZ == 1;
        boolean canBeT = !foundT && sizeT == 1;
        boolean canBeC = !foundC && sizeC == 1;
        this.certain = isCertain;
        for (int i = 0; i < this.axisTypes.length; ++i) {
            if (this.axisTypes[i] != 0) continue;
            this.certain = false;
            if (canBeZ) {
                this.axisTypes[i] = 1;
                canBeZ = false;
                continue;
            }
            if (canBeT) {
                this.axisTypes[i] = 2;
                canBeT = false;
                continue;
            }
            if (canBeC) {
                this.axisTypes[i] = 3;
                canBeC = false;
                continue;
            }
            char lastAxis = this.newOrder.charAt(this.newOrder.length() - 1);
            this.axisTypes[i] = lastAxis == 'C' ? 3 : (lastAxis == 'Z' ? 1 : 2);
        }
    }

    public FilePattern getFilePattern() {
        return this.fp;
    }

    public String getOriginalOrder() {
        return this.dimOrder;
    }

    public String getAdjustedOrder() {
        return this.newOrder;
    }

    public boolean isCertain() {
        return this.certain;
    }

    public int[] getAxisTypes() {
        return this.axisTypes;
    }

    public void setAxisTypes(int[] axes) {
        this.axisTypes = axes;
    }

    public int getAxisCountZ() {
        return this.getAxisCount(1);
    }

    public int getAxisCountT() {
        return this.getAxisCount(2);
    }

    public int getAxisCountC() {
        return this.getAxisCount(3);
    }

    public int getAxisCountS() {
        return this.getAxisCount(4);
    }

    public int getAxisCount(int axisType) {
        int num = 0;
        for (int i = 0; i < this.axisTypes.length; ++i) {
            if (this.axisTypes[i] != axisType) continue;
            ++num;
        }
        return num;
    }

    public static int getAxisType(String label) {
        String lowerLabel = label.toLowerCase();
        for (String p : Z) {
            if (!p.equals(lowerLabel) && !lowerLabel.endsWith(p)) continue;
            return 1;
        }
        for (String p : C) {
            if (!p.equals(lowerLabel) && !lowerLabel.endsWith(p)) continue;
            return 3;
        }
        for (String p : T) {
            if (!p.equals(lowerLabel) && !lowerLabel.endsWith(p)) continue;
            return 2;
        }
        for (String p : S) {
            if (!p.equals(lowerLabel) && !lowerLabel.endsWith(p)) continue;
            return 4;
        }
        return 0;
    }

    public static void main(String[] args) throws FormatException, IOException {
        Location file2 = args.length < 1 ? new Location(System.getProperty("user.dir")).listFiles()[0] : new Location(args[0]);
        LOGGER.info("File = {}", (Object)file2.getAbsoluteFile());
        String pat = FilePattern.findPattern(file2);
        if (pat == null) {
            LOGGER.info("No pattern found.");
        } else {
            LOGGER.info("Pattern = {}", (Object)pat);
            FilePattern fp = new FilePattern(pat);
            if (fp.isValid()) {
                LOGGER.info("Pattern is valid.");
                String id = fp.getFiles()[0];
                if (!new Location(id).exists()) {
                    LOGGER.info("File '{}' does not exist.", (Object)id);
                } else {
                    LOGGER.info("Reading first file ");
                    ImageReader reader = new ImageReader();
                    reader.setId(id);
                    String dimOrder = reader.getDimensionOrder();
                    int sizeZ = reader.getSizeZ();
                    int sizeT = reader.getSizeT();
                    int sizeC = reader.getSizeC();
                    boolean certain = reader.isOrderCertain();
                    reader.close();
                    LOGGER.info("[done]");
                    LOGGER.info("\tdimOrder = {} ({})", (Object)dimOrder, (Object)(certain ? "certain" : "uncertain"));
                    LOGGER.info("\tsizeZ = {}", (Object)sizeZ);
                    LOGGER.info("\tsizeT = {}", (Object)sizeT);
                    LOGGER.info("\tsizeC = {}", (Object)sizeC);
                    AxisGuesser ag = new AxisGuesser(fp, dimOrder, sizeZ, sizeT, sizeC, certain);
                    String[] blocks = fp.getBlocks();
                    String[] prefixes = fp.getPrefixes();
                    int[] axes = ag.getAxisTypes();
                    String newOrder = ag.getAdjustedOrder();
                    boolean isCertain = ag.isCertain();
                    LOGGER.info("Axis types:");
                    for (int i = 0; i < blocks.length; ++i) {
                        String axis;
                        switch (axes[i]) {
                            case 1: {
                                axis = "Z";
                                break;
                            }
                            case 2: {
                                axis = "T";
                                break;
                            }
                            case 3: {
                                axis = "C";
                                break;
                            }
                            default: {
                                axis = "?";
                            }
                        }
                        LOGGER.info("\t{}\t{} (prefix = {})", new Object[]{blocks[i], axis, prefixes[i]});
                    }
                    if (!dimOrder.equals(newOrder)) {
                        LOGGER.info("Adjusted dimension order = {} ({})", (Object)newOrder, (Object)(isCertain ? "certain" : "uncertain"));
                    }
                }
            } else {
                LOGGER.info("Pattern is invalid: {}", (Object)fp.getErrorMessage());
            }
        }
    }
}

